/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity.drone;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.api.item.IProgrammable;
import me.desht.pneumaticcraft.client.render.area.AreaRenderManager;
import me.desht.pneumaticcraft.common.block.entity.AbstractTickingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IGUITextFieldSensitive;
import me.desht.pneumaticcraft.common.drone.progwidgets.IAreaProvider;
import me.desht.pneumaticcraft.common.drone.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.IVariableWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetLabel;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetStart;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetText;
import me.desht.pneumaticcraft.common.drone.progwidgets.WidgetSerializer;
import me.desht.pneumaticcraft.common.inventory.ProgrammerMenu;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.network.PacketProgrammerSync;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import me.desht.pneumaticcraft.common.registry.ModCriterionTriggers;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.registry.ModSounds;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.NBTUtils;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.wrapper.PlayerMainInvWrapper;

public class ProgrammerBlockEntity
extends AbstractTickingBlockEntity
implements IGUITextFieldSensitive,
MenuProvider {
    private static final int PROGRAM_SLOT = 0;
    private static final int INVENTORY_SIZE = 1;
    public final List<IProgWidget> progWidgets = new ArrayList<IProgWidget>();
    private final ProgrammerItemHandler inventory = new ProgrammerItemHandler();
    public double translatedX;
    public double translatedY;
    public int zoomState;
    public boolean showInfo = true;
    public boolean showFlow = true;
    @GuiSynced
    public boolean recentreStartPiece = false;
    @GuiSynced
    public boolean canUndo;
    @GuiSynced
    public boolean canRedo;
    @GuiSynced
    public boolean programOnInsert;
    @GuiSynced
    public int availablePuzzlePieces;
    @DescSynced
    public ItemStack displayedStack = ItemStack.EMPTY;
    private ListTag history = new ListTag();
    private int historyIndex;

    public ProgrammerBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntityTypes.PROGRAMMER.get(), pos, state);
        this.saveToHistory();
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        this.inventory.deserializeNBT(tag.getCompound("Items"));
        this.displayedStack = this.inventory.getStackInSlot(0);
        this.programOnInsert = tag.getBoolean("ProgramOnInsert");
        this.history = tag.getList("history", 10);
        if (this.history.isEmpty()) {
            this.saveToHistory();
        }
        this.readProgWidgetsFromNBT(tag);
    }

    @Override
    public void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        tag.put("Items", (Tag)this.inventory.serializeNBT());
        tag.put("history", (Tag)this.history);
        tag.putBoolean("ProgramOnInsert", this.programOnInsert);
        this.writeProgWidgetsToNBT(tag);
    }

    public List<IProgWidget> mergeWidgetsFromNBT(CompoundTag tag) {
        List<IProgWidget> mergedWidgets = WidgetSerializer.getWidgetsFromNBT(tag);
        ArrayList<IProgWidget> result = new ArrayList<IProgWidget>(this.progWidgets);
        if (!this.progWidgets.isEmpty() && !mergedWidgets.isEmpty()) {
            PuzzleExtents extents1 = this.getPuzzleExtents(this.progWidgets);
            PuzzleExtents extents2 = this.getPuzzleExtents(mergedWidgets);
            for (IProgWidget w2 : mergedWidgets) {
                w2.setX(w2.getX() - extents2.x() + extents1.x() + extents1.width() + 10);
                w2.setY(w2.getY() - extents2.y() + extents1.y());
            }
        }
        mergedWidgets.forEach(w -> {
            if (w instanceof ProgWidgetStart) {
                ProgWidgetLabel lab = new ProgWidgetLabel();
                lab.setX(w.getX());
                lab.setY(w.getY());
                result.add(lab);
                ProgWidgetText text = new ProgWidgetText();
                text.string = "Merge #" + this.nonNullLevel().getGameTime();
                text.setX(lab.getX() + lab.getWidth() / 2);
                text.setY(lab.getY());
                result.add(text);
            } else {
                result.add((IProgWidget)w);
            }
        });
        return result;
    }

    private PuzzleExtents getPuzzleExtents(List<IProgWidget> widgets) {
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        for (IProgWidget w : widgets) {
            minX = Math.min(minX, w.getX());
            maxX = Math.max(maxX, w.getX() + w.getWidth());
            minY = Math.min(minY, w.getY());
            maxY = Math.max(maxY, w.getY() + w.getHeight());
        }
        return new PuzzleExtents(minX, minY, maxX - minX, maxY - minY);
    }

    public void readProgWidgetsFromNBT(CompoundTag tag) {
        this.progWidgets.clear();
        this.progWidgets.addAll(WidgetSerializer.getWidgetsFromNBT(tag));
        ProgrammerBlockEntity.updatePuzzleConnections(this.progWidgets);
    }

    public CompoundTag writeProgWidgetsToNBT(CompoundTag tag) {
        WidgetSerializer.putWidgetsToNBT(this.progWidgets, tag);
        return tag;
    }

    public static void updatePuzzleConnections(List<IProgWidget> progWidgets) {
        List<ProgWidgetType<?>> parameters;
        for (IProgWidget widget : progWidgets) {
            widget.setParent(null);
            parameters = widget.getParameters();
            for (int i = 0; i < parameters.size() * 2; ++i) {
                widget.setParameter(i, null);
            }
            if (!widget.hasStepOutput()) continue;
            widget.setOutputWidget(null);
        }
        for (IProgWidget checkedWidget : progWidgets) {
            parameters = checkedWidget.getParameters();
            if (!parameters.isEmpty()) {
                for (IProgWidget widget : progWidgets) {
                    if (widget == checkedWidget || checkedWidget.getX() + checkedWidget.getWidth() / 2 != widget.getX()) continue;
                    for (int i = 0; i < parameters.size(); ++i) {
                        if (!checkedWidget.canSetParameter(i) || parameters.get(i) != widget.returnType() || checkedWidget.getY() + i * 11 != widget.getY()) continue;
                        checkedWidget.setParameter(i, widget);
                        widget.setParent(checkedWidget);
                    }
                }
            }
            if (!checkedWidget.hasStepOutput()) continue;
            for (IProgWidget widget : progWidgets) {
                if (!widget.hasStepInput() || widget.getX() != checkedWidget.getX() || widget.getY() != checkedWidget.getY() + checkedWidget.getHeight() / 2) continue;
                checkedWidget.setOutputWidget(widget);
            }
        }
        for (IProgWidget checkedWidget : progWidgets) {
            if (checkedWidget.returnType() != null) continue;
            parameters = checkedWidget.getParameters();
            for (int i = 0; i < parameters.size(); ++i) {
                if (!checkedWidget.canSetParameter(i)) continue;
                for (IProgWidget widget : progWidgets) {
                    if (parameters.get(i) != widget.returnType() || widget == checkedWidget || widget.getX() + widget.getWidth() / 2 != checkedWidget.getX() || widget.getY() != checkedWidget.getY() + i * 11) continue;
                    IProgWidget root = widget;
                    while (root.getParent() != null) {
                        root = root.getParent();
                    }
                    checkedWidget.setParameter(i + parameters.size(), root);
                }
            }
        }
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
        switch (tag) {
            case "program_when": {
                this.programOnInsert = !this.programOnInsert;
                this.setChanged();
                break;
            }
            case "import": {
                this.tryImport(shiftHeld);
                break;
            }
            case "export": {
                this.tryProgramDrone((Player)player);
                break;
            }
            case "undo": {
                this.undo();
                break;
            }
            case "redo": {
                this.redo();
            }
        }
        this.sendDescriptionPacket();
    }

    @Nonnull
    public ItemStack getItemInProgrammingSlot() {
        return this.inventory.getStackInSlot(0);
    }

    @Override
    public IItemHandler getItemHandler(@Nullable Direction dir) {
        return this.inventory;
    }

    @Override
    public void setText(int textFieldID, String text) {
        ItemStack stack = this.inventory.getStackInSlot(0).copy();
        if (textFieldID == 0 && !stack.isEmpty()) {
            stack.setHoverName((Component)Component.literal((String)text));
            this.inventory.setStackInSlot(0, stack);
        }
    }

    @Override
    public String getText(int textFieldID) {
        return this.inventory.getStackInSlot(0).getHoverName().getString();
    }

    private void tryImport(boolean merge) {
        CompoundTag nbt;
        ItemStack stack = this.inventory.getStackInSlot(0);
        CompoundTag compoundTag = nbt = stack.isEmpty() ? null : stack.getTag();
        if (nbt != null) {
            List<IProgWidget> widgets = merge ? this.mergeWidgetsFromNBT(nbt) : WidgetSerializer.getWidgetsFromNBT(nbt);
            this.setProgWidgets(widgets, null);
        } else if (!merge) {
            this.setProgWidgets(Collections.emptyList(), null);
        }
    }

    public void tryProgramDrone(Player player) {
        if (this.inventory.getStackInSlot(0).getItem() instanceof IProgrammable) {
            if (player == null || !player.isCreative()) {
                int required = this.getRequiredPuzzleCount();
                if (required > 0) {
                    if (!this.takePuzzlePieces(player, true)) {
                        if (player instanceof ServerPlayer) {
                            NetworkHandler.sendToPlayer(new PacketPlaySound((SoundEvent)ModSounds.MINIGUN_STOP.get(), SoundSource.BLOCKS, this.getBlockPos(), 1.0f, 1.5f, false), (ServerPlayer)player);
                        }
                        return;
                    }
                    this.takePuzzlePieces(player, false);
                } else if (required < 0) {
                    this.returnPuzzlePieces(player, -required);
                }
            }
            ItemStack stack = this.inventory.getStackInSlot(0);
            this.writeProgWidgetsToNBT(stack.getOrCreateTag());
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                NetworkHandler.sendToPlayer(new PacketPlaySound((SoundEvent)ModSounds.HUD_INIT_COMPLETE.get(), SoundSource.BLOCKS, this.getBlockPos(), 1.0f, 1.0f, false), sp);
                ModCriterionTriggers.PROGRAM_DRONE.get().trigger(sp);
            }
        }
    }

    private void returnPuzzlePieces(@Nullable Player player, int count) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.PROGRAMMING_PUZZLE.get());
        for (Direction d : DirectionUtil.VALUES) {
            BlockEntity te = this.getCachedNeighbor(d);
            if (te != null) {
                while (count > 0) {
                    int toInsert = Math.min(count, stack.getMaxStackSize());
                    int inserted = IOHelper.getInventoryForBlock(te, d.getOpposite()).map(h -> {
                        ItemStack excess = ItemHandlerHelper.insertItem((IItemHandler)h, (ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)toInsert), (boolean)false);
                        return toInsert - excess.getCount();
                    }).orElse(0);
                    if (inserted == 0) break;
                    count -= inserted;
                }
            }
            if (count > 0) continue;
            return;
        }
        while (count > 0) {
            int size = Math.min(count, stack.getMaxStackSize());
            if (player != null) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size));
            } else {
                PneumaticCraftUtils.dropItemOnGround(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size), this.getLevel(), this.getBlockPos());
            }
            count -= size;
        }
    }

    public int getRequiredPuzzleCount() {
        ItemStack stackInSlot = this.inventory.getStackInSlot(0);
        if (!stackInSlot.isEmpty() && ((IProgrammable)stackInSlot.getItem()).usesPieces(stackInSlot)) {
            List<IProgWidget> inDrone = ProgrammerBlockEntity.getProgWidgets(stackInSlot);
            int dronePieces = (int)inDrone.stream().filter(p -> !p.freeToUse()).count();
            int required = (int)this.progWidgets.stream().filter(p -> !p.freeToUse()).count();
            return (required - dronePieces) * stackInSlot.getCount();
        }
        return 0;
    }

    public static List<IProgWidget> getProgWidgets(ItemStack iStack) {
        if (NBTUtils.hasTag(iStack, "pneumaticcraft:progWidgets")) {
            return WidgetSerializer.getWidgetsFromNBT(Objects.requireNonNull(iStack.getTag()));
        }
        return new ArrayList<IProgWidget>();
    }

    private boolean takePuzzlePieces(@Nullable Player player, boolean simulate) {
        int required = this.getRequiredPuzzleCount();
        if (required <= 0) {
            return true;
        }
        int found = 0;
        if (player != null && (found += this.extractPuzzlePieces((IItemHandler)new PlayerMainInvWrapper(player.getInventory()), required, simulate)) >= required) {
            return true;
        }
        for (Direction d : DirectionUtil.VALUES) {
            BlockEntity te = this.getCachedNeighbor(d);
            if (te == null) continue;
            int r = required - found;
            if ((found += IOHelper.getInventoryForBlock(te, d.getOpposite()).map(h -> this.extractPuzzlePieces((IItemHandler)h, r, simulate)).orElse(0).intValue()) < required) continue;
            return true;
        }
        return false;
    }

    private int extractPuzzlePieces(IItemHandler handler, int max, boolean simulate) {
        int n = 0;
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack extracted;
            ItemStack stackInSlot = handler.getStackInSlot(i);
            if (stackInSlot.getItem() != ModItems.PROGRAMMING_PUZZLE.get() || (n += (extracted = handler.extractItem(i, Math.min(max - n, stackInSlot.getMaxStackSize()), simulate)).getCount()) < max) continue;
            return n;
        }
        return n;
    }

    public Set<String> getAllVariables() {
        HashSet<String> variables = new HashSet<String>();
        for (IProgWidget widget : this.progWidgets) {
            if (!(widget instanceof IVariableWidget)) continue;
            ((IVariableWidget)((Object)widget)).addVariables(variables);
        }
        variables.remove("");
        return variables;
    }

    @Override
    public void tickServer() {
        super.tickServer();
        if ((this.nonNullLevel().getGameTime() & 0xFL) == 0L && this.countPlayersUsing() > 0) {
            int total = 0;
            for (Direction dir : DirectionUtil.VALUES) {
                BlockEntity te = this.getCachedNeighbor(dir);
                if (te == null) continue;
                total += IOHelper.getInventoryForBlock(te, dir.getOpposite()).map(handler -> IOHelper.countItems(handler, stack -> stack.getItem() == ModItems.PROGRAMMING_PUZZLE.get())).orElse(0).intValue();
            }
            this.availablePuzzlePieces = total;
        }
    }

    public void previewArea(IProgWidget progWidget) {
        if (progWidget == null) {
            AreaRenderManager.getInstance().removeHandlers(this);
        } else if (progWidget instanceof IAreaProvider) {
            HashSet<BlockPos> area = new HashSet<BlockPos>();
            ((IAreaProvider)((Object)progWidget)).getArea(area);
            AreaRenderManager.getInstance().showArea(area, -1878982912, (BlockEntity)this);
        }
    }

    private void saveToHistory() {
        CompoundTag tag = new CompoundTag();
        this.writeProgWidgetsToNBT(tag);
        if (this.history.isEmpty() || !this.history.getCompound(this.historyIndex).equals((Object)tag)) {
            while (this.history.size() > this.historyIndex + 1) {
                this.history.remove(this.historyIndex + 1);
            }
            this.history.add((Object)tag);
            if (this.history.size() > 20) {
                this.history.remove(0);
            }
            this.historyIndex = this.history.size() - 1;
            this.updateUndoRedoState();
        }
    }

    private void undo() {
        if (this.canUndo) {
            --this.historyIndex;
            this.readProgWidgetsFromNBT(this.history.getCompound(this.historyIndex));
            this.updateUndoRedoState();
            this.syncToClient(null);
        }
    }

    private void redo() {
        if (this.canRedo) {
            ++this.historyIndex;
            this.readProgWidgetsFromNBT(this.history.getCompound(this.historyIndex));
            this.updateUndoRedoState();
            this.syncToClient(null);
        }
    }

    private void updateUndoRedoState() {
        this.canUndo = this.historyIndex > 0;
        this.canRedo = this.historyIndex < this.history.size() - 1;
        this.setChanged();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player playerEntity) {
        return new ProgrammerMenu(i, playerInventory, this.getBlockPos());
    }

    public void setProgWidgets(List<IProgWidget> widgets, Player player) {
        this.progWidgets.clear();
        this.progWidgets.addAll(widgets);
        ProgrammerBlockEntity.updatePuzzleConnections(this.progWidgets);
        if (!this.nonNullLevel().isClientSide) {
            this.setChanged();
            this.saveToHistory();
            this.syncToClient(player);
        }
    }

    private void syncToClient(Player updatingPlayer) {
        if (!this.nonNullLevel().isClientSide) {
            List players = this.nonNullLevel().getEntitiesOfClass(ServerPlayer.class, new AABB(this.worldPosition).inflate(5.0));
            for (ServerPlayer player : players) {
                if (player == updatingPlayer || !(player.containerMenu instanceof ProgrammerMenu)) continue;
                NetworkHandler.sendToPlayer(PacketProgrammerSync.forBlockEntity(this), player);
            }
        }
    }

    private class ProgrammerItemHandler
    extends BaseItemStackHandler {
        ProgrammerItemHandler() {
            super(ProgrammerBlockEntity.this, 1);
        }

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (ProgrammerBlockEntity.this.programOnInsert && slot == 0 && !this.getStackInSlot(slot).isEmpty() && !this.te.getLevel().isClientSide) {
                ProgrammerBlockEntity.this.tryProgramDrone(null);
            }
            ProgrammerBlockEntity.this.displayedStack = this.getStackInSlot(slot);
        }

        public boolean isItemValid(int slot, ItemStack itemStack) {
            return itemStack.getItem() instanceof IProgrammable && ((IProgrammable)itemStack.getItem()).canProgram(itemStack);
        }
    }

    private record PuzzleExtents(int x, int y, int width, int height) {
    }
}

