/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity.heat;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.client.util.TintColor;
import me.desht.pneumaticcraft.common.block.entity.AbstractTickingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IComparatorSupport;
import me.desht.pneumaticcraft.common.block.entity.IHeatExchangingTE;
import me.desht.pneumaticcraft.common.block.entity.IHeatTinted;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import me.desht.pneumaticcraft.common.heat.SyncedTemperature;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class CompressedIronBlockBlockEntity
extends AbstractTickingBlockEntity
implements IComparatorSupport,
IHeatTinted,
IHeatExchangingTE {
    protected final IHeatExchangerLogic heatExchanger = PneumaticRegistry.getInstance().getHeatRegistry().makeHeatExchangerLogic();
    private int comparatorOutput = 0;
    @DescSynced
    protected final SyncedTemperature syncedTemperature = new SyncedTemperature(this.heatExchanger);

    public CompressedIronBlockBlockEntity(BlockPos pos, BlockState state) {
        this(ModBlockEntityTypes.COMPRESSED_IRON_BLOCK.get(), pos, state);
    }

    CompressedIronBlockBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.heatExchanger.setThermalCapacity(10.0);
    }

    @Override
    public boolean hasItemCapability() {
        return false;
    }

    @Override
    public void tickServer() {
        super.tickServer();
        this.syncedTemperature.tick();
        int newComparatorOutput = HeatUtil.getComparatorOutput((int)this.heatExchanger.getTemperature());
        if (this.comparatorOutput != newComparatorOutput) {
            this.comparatorOutput = newComparatorOutput;
            this.nonNullLevel().updateNeighbourForOutputSignal(this.getBlockPos(), this.getBlockState().getBlock());
        }
    }

    @Override
    protected boolean shouldRerenderChunkOnDescUpdate() {
        return true;
    }

    @Override
    public IItemHandler getItemHandler(@Nullable Direction dir) {
        return null;
    }

    @Override
    public int getComparatorValue() {
        return this.comparatorOutput;
    }

    @Override
    public TintColor getColorForTintIndex(int tintIndex) {
        return HeatUtil.getColourForTemperature(this.syncedTemperature.getSyncedTemp());
    }

    @Override
    public IHeatExchangerLogic getHeatExchanger(Direction dir) {
        return this.heatExchanger;
    }
}

