/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity.hopper;

import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.common.block.OmnidirectionalHopperBlock;
import me.desht.pneumaticcraft.common.block.entity.AbstractTickingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IComparatorSupport;
import me.desht.pneumaticcraft.common.block.entity.IRedstoneControl;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class AbstractHopperBlockEntity<T extends BlockEntity>
extends AbstractTickingBlockEntity
implements IRedstoneControl<T>,
IComparatorSupport,
MenuProvider {
    private static final int BASE_TICK_RATE = 8;
    private int lastComparatorValue = -1;
    private int cooldown;
    private int entityScanCooldown;
    @GuiSynced
    int leaveMaterialCount;
    @DescSynced
    public boolean isCreative;
    private boolean wasCreative = false;
    Direction inputDir = Direction.UP;
    AABB inputAABB;
    AABB outputAABB;
    final List<Entity> cachedInputEntities = new ArrayList<Entity>();
    final List<Entity> cachedOutputEntities = new ArrayList<Entity>();
    private boolean firstTick = true;

    AbstractHopperBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state, 4);
    }

    public Direction getInputDirection() {
        return (Direction)this.getBlockState().getValue(OmnidirectionalHopperBlock.INPUT_FACING);
    }

    @Override
    public void onBlockRotated() {
        super.onBlockRotated();
        this.inputDir = this.getInputDirection();
        this.setupInputOutputRegions();
    }

    @Override
    public void tickServer() {
        this.inputDir = this.getInputDirection();
        if (this.firstTick) {
            this.isCreative = this.getUpgrades(ModUpgrades.CREATIVE.get()) > 0;
            this.setupInputOutputRegions();
            this.firstTick = false;
        }
        super.tickServer();
        if (this.getRedstoneController().shouldRun()) {
            if (--this.entityScanCooldown <= 0) {
                this.cachedInputEntities.clear();
                if (this.shouldScanForEntities(this.inputDir)) {
                    this.cachedInputEntities.addAll(this.nonNullLevel().getEntitiesOfClass(Entity.class, this.inputAABB, EntitySelector.ENTITY_STILL_ALIVE));
                }
                this.cachedOutputEntities.clear();
                if (this.shouldScanForEntities(this.getRotation())) {
                    this.cachedOutputEntities.addAll(this.nonNullLevel().getEntitiesOfClass(Entity.class, this.outputAABB, EntitySelector.ENTITY_STILL_ALIVE));
                }
                this.entityScanCooldown = 8;
            }
            if (--this.cooldown <= 0) {
                int maxItems = this.getMaxItems();
                boolean success = this.doImport(maxItems);
                int n = this.cooldown = (success |= this.doExport(maxItems)) ? this.getItemTransferInterval() : 8;
                if (this.lastComparatorValue != this.getComparatorValueInternal()) {
                    this.lastComparatorValue = this.getComparatorValueInternal();
                }
            }
        }
    }

    @Override
    protected boolean shouldRerenderChunkOnDescUpdate() {
        boolean rerender = this.wasCreative != this.isCreative;
        this.wasCreative = this.isCreative;
        return rerender;
    }

    public int getMaxItems() {
        int upgrades = this.getUpgrades(ModUpgrades.SPEED.get());
        if (upgrades > 3) {
            return Math.min(1 << upgrades - 3, 256);
        }
        return 1;
    }

    public int getItemTransferInterval() {
        return 8 / (1 << this.getUpgrades(ModUpgrades.SPEED.get()));
    }

    protected abstract void setupInputOutputRegions();

    protected abstract boolean doExport(int var1);

    protected abstract boolean doImport(int var1);

    protected abstract int getComparatorValueInternal();

    @Override
    public void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        tag.putInt("leaveMaterialCount", this.leaveMaterialCount);
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        this.leaveMaterialCount = tag.contains("leaveMaterial") ? (int)((byte)(tag.getBoolean("leaveMaterial") ? 1 : 0)) : tag.getInt("leaveMaterialCount");
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
        if (this.getRedstoneController().parseRedstoneMode(tag)) {
            return;
        }
        switch (tag) {
            case "empty": {
                this.leaveMaterialCount = 0;
                break;
            }
            case "leave": {
                this.leaveMaterialCount = 1;
            }
        }
        this.setChanged();
    }

    public boolean doesLeaveMaterial() {
        return this.leaveMaterialCount > 0;
    }

    @Override
    public int getComparatorValue() {
        return this.getComparatorValueInternal();
    }

    @Override
    public void onUpgradesChanged() {
        super.onUpgradesChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.isCreative = this.getUpgrades(ModUpgrades.CREATIVE.get()) > 0;
        }
    }

    @Override
    public boolean shouldPreserveStateOnBreak() {
        return true;
    }

    abstract boolean shouldScanForEntities(Direction var1);

    protected final boolean isInputBlocked() {
        BlockPos inputPos = this.worldPosition.relative(this.inputDir);
        return Block.isShapeFullBlock((VoxelShape)this.nonNullLevel().getBlockState(inputPos).getShape((BlockGetter)this.nonNullLevel(), inputPos));
    }
}

