/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity.hopper;

import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.data.PneumaticCraftTags;
import me.desht.pneumaticcraft.common.block.OmnidirectionalHopperBlock;
import me.desht.pneumaticcraft.common.block.entity.RedstoneController;
import me.desht.pneumaticcraft.common.block.entity.hopper.AbstractHopperBlockEntity;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.inventory.OmnidirectionalHopperMenu;
import me.desht.pneumaticcraft.common.inventory.handler.ComparatorItemStackHandler;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class OmnidirectionalHopperBlockEntity
extends AbstractHopperBlockEntity<OmnidirectionalHopperBlockEntity> {
    public static final int INVENTORY_SIZE = 5;
    private final ComparatorItemStackHandler itemHandler = new ComparatorItemStackHandler(this, this.getInvSize());
    @GuiSynced
    public boolean roundRobin;
    private int rrSlot;
    @GuiSynced
    private final RedstoneController<OmnidirectionalHopperBlockEntity> rsController = new RedstoneController<OmnidirectionalHopperBlockEntity>(this);
    private BlockCapabilityCache<IItemHandler, Direction> inputCache;
    private BlockCapabilityCache<IItemHandler, Direction> outputCache;

    public OmnidirectionalHopperBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntityTypes.OMNIDIRECTIONAL_HOPPER.get(), pos, state);
    }

    protected int getInvSize() {
        return 5;
    }

    private BlockCapabilityCache<IItemHandler, Direction> getInputCache() {
        if (this.inputCache == null) {
            this.inputCache = this.createItemHandlerCache(this.inputDir);
        }
        return this.inputCache;
    }

    private BlockCapabilityCache<IItemHandler, Direction> getOutputCache() {
        if (this.outputCache == null) {
            this.outputCache = this.createItemHandlerCache(this.getRotation());
        }
        return this.outputCache;
    }

    @Override
    public void onBlockRotated() {
        super.onBlockRotated();
        this.outputCache = null;
        this.inputCache = null;
    }

    @Override
    protected int getComparatorValueInternal() {
        return this.itemHandler.getComparatorValue();
    }

    @Override
    protected boolean doExport(int maxItems) {
        Direction outputDir = this.getRotation();
        IItemHandler destInv = (IItemHandler)this.getOutputCache().getCapability();
        int notExported = maxItems;
        if (destInv != null) {
            notExported = this.exportToInventory(destInv, maxItems);
        } else if (this.getUpgrades(ModUpgrades.ENTITY_TRACKER.get()) > 0) {
            notExported = this.tryEntityExport(maxItems, outputDir.getOpposite());
        }
        if (notExported == maxItems && ((Boolean)ConfigHelper.common().machines.omniHopperDispenser.get()).booleanValue() && this.getUpgrades(ModUpgrades.DISPENSER.get()) > 0) {
            notExported = this.exportToInventory(new DropInWorldHandler(this.getLevel(), this.getBlockPos(), outputDir), maxItems);
        }
        return notExported < maxItems;
    }

    private int tryEntityExport(int maxItems, Direction dir) {
        for (Entity e : this.cachedOutputEntities) {
            int notExported;
            if (!e.isAlive() || (notExported = IOHelper.getInventoryForEntity(e, dir).map(h -> this.exportToInventory((IItemHandler)h, maxItems)).orElse(maxItems).intValue()) >= maxItems) continue;
            return notExported;
        }
        return maxItems;
    }

    private int exportToInventory(IItemHandler otherHandler, int maxItems) {
        int remaining = maxItems;
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            int amount;
            int slot = this.actualSlot(i);
            ItemStack exportedStack = this.itemHandler.extractItem(slot, (amount = this.itemHandler.getStackInSlot(slot).getCount()) - this.leaveMaterialCount, true);
            if (exportedStack.getCount() <= this.leaveMaterialCount) continue;
            exportedStack.setCount(Math.min(exportedStack.getCount(), remaining));
            ItemStack excess = ItemHandlerHelper.insertItem((IItemHandler)otherHandler, (ItemStack)exportedStack, (boolean)false);
            int exportedCount = exportedStack.getCount() - excess.getCount();
            if (!this.isCreative && exportedCount > 0) {
                this.itemHandler.extractItem(slot, exportedCount, false);
            }
            if ((remaining -= exportedCount) > this.leaveMaterialCount) continue;
            if (!this.roundRobin) break;
            this.rrSlot = slot + 1;
            if (this.rrSlot < this.itemHandler.getSlots()) break;
            this.rrSlot = 0;
            break;
        }
        return remaining;
    }

    private int actualSlot(int i) {
        if (this.roundRobin) {
            int slot = this.rrSlot + i;
            if (slot >= this.itemHandler.getSlots()) {
                slot -= this.itemHandler.getSlots();
            }
            return slot;
        }
        return i;
    }

    @Override
    protected boolean doImport(int maxItems) {
        boolean success = false;
        if (this.isInventoryFull()) {
            return false;
        }
        IItemHandler srcInv = (IItemHandler)this.getInputCache().getCapability();
        if (srcInv != null) {
            int imported = this.importFromInventory(srcInv, maxItems, false);
            return imported > 0;
        }
        if (this.getUpgrades(ModUpgrades.ENTITY_TRACKER.get()) > 0 && this.tryEntityImport(maxItems) > 0) {
            return true;
        }
        if (!this.isInputBlocked()) {
            for (Entity e : this.cachedInputEntities) {
                if (!e.isAlive() || !(e instanceof ItemEntity)) continue;
                ItemEntity entity = (ItemEntity)e;
                ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)this.itemHandler, (ItemStack)entity.getItem(), (boolean)false);
                if (remainder.isEmpty()) {
                    entity.discard();
                    success = true;
                    continue;
                }
                if (remainder.getCount() >= entity.getItem().getCount()) continue;
                entity.setItem(remainder);
                success = true;
            }
        }
        return success;
    }

    private int tryEntityImport(int maxItems) {
        Direction dir = this.inputDir.getOpposite();
        int remaining = maxItems;
        for (Entity e : this.cachedInputEntities) {
            boolean playerArmor;
            if (!e.isAlive() || e.getType().is(PneumaticCraftTags.EntityTypes.OMNIHOPPER_BLACKLISTED)) continue;
            int r = remaining;
            boolean bl = playerArmor = e instanceof Player && dir.getAxis().isHorizontal();
            int imported = IOHelper.getInventoryForEntity(e, dir).map(h -> this.importFromInventory((IItemHandler)h, r, playerArmor)).orElse(0);
            if ((remaining -= imported) > 0) continue;
            return maxItems - remaining;
        }
        return 0;
    }

    private int importFromInventory(IItemHandler inv, int maxItems, boolean playerArmor) {
        int remaining = maxItems;
        for (int i = 0; i < inv.getSlots(); ++i) {
            if (inv.getStackInSlot(i).isEmpty()) continue;
            ItemStack toExtract = inv.extractItem(i, remaining, true);
            if (playerArmor && EnchantmentHelper.hasBindingCurse((ItemStack)toExtract)) continue;
            ItemStack excess = ItemHandlerHelper.insertItemStacked((IItemHandler)this.itemHandler, (ItemStack)toExtract, (boolean)false);
            int transferred = toExtract.getCount() - excess.getCount();
            if (transferred <= 0) continue;
            inv.extractItem(i, transferred, false);
            if ((remaining -= transferred) > 0) continue;
            return maxItems;
        }
        return maxItems - remaining;
    }

    private boolean isInventoryFull() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (!stack.isEmpty() && stack.getCount() >= stack.getMaxStackSize()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void setupInputOutputRegions() {
        AABB bowl = OmnidirectionalHopperBlock.INPUT_SHAPES[this.inputDir.get3DDataValue()].bounds().move(this.worldPosition);
        this.inputAABB = bowl.minmax(new AABB(this.worldPosition.relative(this.inputDir)));
        this.outputAABB = new AABB(this.getBlockPos().relative(this.getRotation()));
        this.cachedInputEntities.clear();
        this.cachedOutputEntities.clear();
    }

    @Override
    boolean shouldScanForEntities(Direction dir) {
        if (this.isInputBlocked() || dir == this.getRotation() && this.getUpgrades(ModUpgrades.ENTITY_TRACKER.get()) == 0) {
            return false;
        }
        BlockEntity te = this.getCachedNeighbor(dir);
        return te == null || IOHelper.getInventoryForBlock(te, dir.getOpposite()).isEmpty();
    }

    @Override
    public int getItemTransferInterval() {
        return 8 / (1 << this.getUpgrades(ModUpgrades.SPEED.get()));
    }

    @Override
    public void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        tag.put("Items", (Tag)this.itemHandler.serializeNBT());
        tag.putBoolean("RoundRobin", this.roundRobin);
        if (this.roundRobin) {
            tag.putInt("RRSlot", this.rrSlot);
        }
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        this.itemHandler.deserializeNBT(tag.getCompound("Items"));
        this.roundRobin = tag.getBoolean("RoundRobin");
        this.rrSlot = tag.getInt("RRSlot");
    }

    @Override
    public IItemHandler getItemHandler(@Nullable Direction dir) {
        return this.itemHandler;
    }

    @javax.annotation.Nullable
    public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player playerEntity) {
        return new OmnidirectionalHopperMenu(i, playerInventory, this.getBlockPos());
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
        if (tag.equals("rr")) {
            this.roundRobin = !this.roundRobin;
            this.setChanged();
        } else {
            super.handleGUIButtonPress(tag, shiftHeld, player);
        }
    }

    @Override
    public RedstoneController<OmnidirectionalHopperBlockEntity> getRedstoneController() {
        return this.rsController;
    }

    private record DropInWorldHandler(Level world, BlockPos pos, Direction outputDir) implements IItemHandler
    {
        private DropInWorldHandler(Level world, BlockPos pos, Direction outputDir) {
            this.world = world;
            this.pos = pos.relative(outputDir);
            this.outputDir = outputDir;
        }

        public int getSlots() {
            return 1;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return ItemStack.EMPTY;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!Block.canSupportCenter((LevelReader)this.world, (BlockPos)this.pos, (Direction)this.outputDir.getOpposite())) {
                if (!simulate) {
                    PneumaticCraftUtils.dropItemOnGroundPrecisely(stack, this.world, (double)this.pos.getX() + 0.5, (double)this.pos.getY() + 0.5, (double)this.pos.getZ() + 0.5);
                }
                return ItemStack.EMPTY;
            }
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.EMPTY;
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return true;
        }
    }
}

