/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity.processing;

import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.common.block.entity.processing.AbstractAssemblyRobotBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.processing.AssemblyPlatformBlockEntity;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.recipes.assembly.AssemblyProgram;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import me.desht.pneumaticcraft.common.registry.ModRecipeTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class AssemblyLaserBlockEntity
extends AbstractAssemblyRobotBlockEntity {
    @DescSynced
    public boolean isLaserOn;
    private int laserStep;
    private static final float ITEM_SIZE = 10.0f;

    public AssemblyLaserBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntityTypes.ASSEMBLY_LASER.get(), pos, state);
    }

    @Override
    public boolean hasItemCapability() {
        return false;
    }

    @Override
    public void tickServer() {
        super.tickServer();
        if (this.laserStep > 0) {
            AbstractAssemblyRobotBlockEntity.TargetDirections platformDirection = this.getPlatformDirection();
            if (platformDirection == null) {
                this.laserStep = 105;
            }
            switch (this.laserStep) {
                case 1: {
                    this.slowMode = false;
                    break;
                }
                case 2: {
                    this.hoverOverNeighbour(platformDirection);
                    break;
                }
                case 3: {
                    this.slowMode = true;
                    this.gotoNeighbour(platformDirection);
                    break;
                }
                case 104: {
                    AssemblyPlatformBlockEntity platform;
                    ItemStack output;
                    this.hoverOverNeighbour(platformDirection);
                    this.isLaserOn = false;
                    this.slowMode = true;
                    BlockEntity te = this.getTileEntityForCurrentDirection();
                    if (!(te instanceof AssemblyPlatformBlockEntity) || (output = this.getLaseredOutputForItem((platform = (AssemblyPlatformBlockEntity)te).getHeldStack())).isEmpty()) break;
                    platform.setHeldStack(output);
                    break;
                }
                case 105: {
                    this.slowMode = false;
                    this.isLaserOn = false;
                    this.gotoHomePosition();
                    break;
                }
                default: {
                    this.isLaserOn = true;
                    this.slowMode = false;
                    float progress = (float)(this.laserStep - 4) / 100.0f * (float)Math.PI * 2.0f;
                    this.targetAngles[AbstractAssemblyRobotBlockEntity.EnumAngles.BASE.getIndex()] = 100.0f - Mth.sin((float)progress) * 10.0f;
                    this.targetAngles[AbstractAssemblyRobotBlockEntity.EnumAngles.MIDDLE.getIndex()] = -10.0f + Mth.sin((float)progress) * 10.0f;
                    this.targetAngles[AbstractAssemblyRobotBlockEntity.EnumAngles.TAIL.getIndex()] = 0.0f;
                    int n = AbstractAssemblyRobotBlockEntity.EnumAngles.TURN.getIndex();
                    this.targetAngles[n] = (float)((double)this.targetAngles[n] + (double)(Mth.sin((float)progress) * 10.0f) * 0.03);
                }
            }
            if (this.isDoneInternal() || this.laserStep >= 4 && this.laserStep <= 103) {
                ++this.laserStep;
                if (this.laserStep > 105) {
                    this.laserStep = 0;
                }
            }
        }
    }

    public void startLasering() {
        if (this.laserStep == 0) {
            this.laserStep = 1;
        }
    }

    @Override
    public boolean gotoNeighbour(AbstractAssemblyRobotBlockEntity.TargetDirections targetDirections) {
        boolean diagonal = super.gotoNeighbour(targetDirections);
        int n = AbstractAssemblyRobotBlockEntity.EnumAngles.TURN.getIndex();
        this.targetAngles[n] = (float)((double)this.targetAngles[n] - 4.5);
        return diagonal;
    }

    private boolean isDoneInternal() {
        return super.isDoneMoving();
    }

    @Override
    public boolean isIdle() {
        return this.laserStep == 0 && this.isDoneInternal();
    }

    @Override
    public AssemblyProgram.EnumMachine getAssemblyType() {
        return AssemblyProgram.EnumMachine.LASER;
    }

    @Override
    public void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        tag.putBoolean("laser", this.isLaserOn);
        tag.putInt("laserStep", this.laserStep);
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        this.isLaserOn = tag.getBoolean("laser");
        this.laserStep = tag.getInt("laserStep");
    }

    @Override
    public IItemHandler getItemHandler(@Nullable Direction dir) {
        return null;
    }

    @Override
    public boolean canMoveToDiagonalNeighbours() {
        return false;
    }

    @Nonnull
    private ItemStack getLaseredOutputForItem(ItemStack input) {
        return ModRecipeTypes.ASSEMBLY_LASER.get().stream(this.level).map(RecipeHolder::value).filter(recipe -> recipe.matches(input)).findFirst().map(recipe -> recipe.getOutput().copy()).orElse(ItemStack.EMPTY);
    }

    @Override
    public boolean reset() {
        if (this.isIdle()) {
            return true;
        }
        this.isLaserOn = false;
        this.laserStep = 105;
        return false;
    }
}

