/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity.processing;

import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.common.block.entity.AbstractTickingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IResettable;
import me.desht.pneumaticcraft.common.block.entity.processing.AssemblyControllerBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.processing.IAssemblyMachine;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.LazySynced;
import me.desht.pneumaticcraft.common.recipes.assembly.AssemblyProgram;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class AssemblyPlatformBlockEntity
extends AbstractTickingBlockEntity
implements IAssemblyMachine,
IResettable {
    @DescSynced
    private boolean shouldClawClose;
    @DescSynced
    @LazySynced
    public float clawProgress;
    public float oldClawProgress;
    @DescSynced
    private final BaseItemStackHandler itemHandler = new BaseItemStackHandler(this, 1);
    private float speed = 1.0f;
    private BlockPos controllerPos;

    public AssemblyPlatformBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntityTypes.ASSEMBLY_PLATFORM.get(), pos, state);
    }

    @Override
    public boolean hasItemCapability() {
        return false;
    }

    @Override
    public void tickCommonPre() {
        super.tickCommonPre();
        this.oldClawProgress = this.clawProgress;
        if (!this.shouldClawClose && this.clawProgress > 0.0f) {
            this.clawProgress = Math.max(this.clawProgress - 0.05f * this.speed, 0.0f);
        } else if (this.shouldClawClose && this.clawProgress < 1.0f) {
            this.clawProgress = Math.min(this.clawProgress + 0.05f * this.speed, 1.0f);
        }
    }

    private boolean isClawDone() {
        return this.clawProgress == (this.shouldClawClose ? 1.0f : 0.0f);
    }

    @Override
    public boolean isIdle() {
        return !this.shouldClawClose && this.isClawDone() && this.getHeldStack().isEmpty();
    }

    @Override
    public boolean reset() {
        this.openClaw();
        return this.isIdle();
    }

    boolean closeClaw() {
        this.shouldClawClose = true;
        this.sendDescriptionPacket();
        return this.isClawDone();
    }

    boolean openClaw() {
        this.shouldClawClose = false;
        this.sendDescriptionPacket();
        return this.isClawDone();
    }

    @Nonnull
    public ItemStack getHeldStack() {
        return this.itemHandler.getStackInSlot(0);
    }

    public void setHeldStack(@Nonnull ItemStack stack) {
        this.itemHandler.setStackInSlot(0, stack);
    }

    @Override
    public void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        tag.putBoolean("clawClosing", this.shouldClawClose);
        tag.putFloat("clawProgress", this.clawProgress);
        tag.putFloat("speed", this.speed);
        tag.put("Items", (Tag)this.itemHandler.serializeNBT());
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        this.shouldClawClose = tag.getBoolean("clawClosing");
        this.clawProgress = tag.getFloat("clawProgress");
        this.speed = tag.getFloat("speed");
        this.itemHandler.deserializeNBT(tag.getCompound("Items"));
    }

    @Override
    public void setSpeed(float speed) {
        this.speed = speed;
    }

    @Override
    public AssemblyProgram.EnumMachine getAssemblyType() {
        return AssemblyProgram.EnumMachine.PLATFORM;
    }

    @Override
    public void setControllerPos(BlockPos controllerPos) {
        this.controllerPos = controllerPos;
    }

    @Override
    public void onNeighborBlockUpdate(BlockPos fromPos) {
        super.onNeighborBlockUpdate(fromPos);
        this.invalidateSystem();
    }

    @Override
    public IItemHandler getItemHandler(@Nullable Direction dir) {
        return this.itemHandler;
    }

    private void invalidateSystem() {
        BlockEntity te;
        if (this.controllerPos != null && (te = this.nonNullLevel().getBlockEntity(this.controllerPos)) instanceof AssemblyControllerBlockEntity) {
            ((AssemblyControllerBlockEntity)te).invalidateAssemblySystem();
        }
    }
}

