/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity.processing;

import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import me.desht.pneumaticcraft.common.block.entity.IRedstoneControl;
import me.desht.pneumaticcraft.common.block.entity.RedstoneController;
import me.desht.pneumaticcraft.common.block.entity.processing.PressureChamberValveBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.processing.PressureChamberWallBlockEntity;
import me.desht.pneumaticcraft.common.inventory.PressureChamberInterfaceMenu;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.LazySynced;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import me.desht.pneumaticcraft.common.registry.ModRecipeTypes;
import me.desht.pneumaticcraft.common.registry.ModSounds;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.util.AcceptabilityCache;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.ITranslatableEnum;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;

public class PressureChamberInterfaceBlockEntity
extends PressureChamberWallBlockEntity
implements IRedstoneControl<PressureChamberInterfaceBlockEntity>,
MenuProvider {
    public static final int MAX_PROGRESS = 40;
    public static final int INVENTORY_SIZE = 1;
    private static final int MIN_SOUND_INTERVAL = 400;
    private static final AcceptabilityCache<Item> acceptedItemCache = new AcceptabilityCache();
    @DescSynced
    private final PressureChamberInterfaceHandler inventory = new PressureChamberInterfaceHandler();
    @DescSynced
    private float doorSpeed = 1.0f;
    @DescSynced
    @LazySynced
    public float inputProgress;
    public float oldInputProgress;
    @DescSynced
    @LazySynced
    public float outputProgress;
    public float oldOutputProgress;
    @GuiSynced
    public InterfaceDirection interfaceMode = InterfaceDirection.NONE;
    @GuiSynced
    private boolean enoughAir = true;
    private boolean isOpeningInput;
    private boolean isOpeningOutput;
    private int soundTimer;
    @DescSynced
    private boolean shouldOpenInput;
    @DescSynced
    private boolean shouldOpenOutput;
    @GuiSynced
    public final RedstoneController<PressureChamberInterfaceBlockEntity> rsController = new RedstoneController<PressureChamberInterfaceBlockEntity>(this);
    private int inputTimeOut;
    private int oldItemCount;
    @GuiSynced
    public boolean exportAny;

    public PressureChamberInterfaceBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntityTypes.PRESSURE_CHAMBER_INTERFACE.get(), pos, state, 4);
    }

    public static void clearCachedItems() {
        acceptedItemCache.clear();
    }

    @Override
    public boolean hasItemCapability() {
        return true;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player playerEntity) {
        return new PressureChamberInterfaceMenu(i, playerInventory, this.getBlockPos());
    }

    @Override
    public void tickCommonPre() {
        super.tickCommonPre();
        boolean wasOpeningI = this.isOpeningInput;
        boolean wasOpeningO = this.isOpeningOutput;
        this.oldInputProgress = this.inputProgress;
        this.oldOutputProgress = this.outputProgress;
        PressureChamberValveBlockEntity core = this.getPrimaryValve();
        if (!this.nonNullLevel().isClientSide) {
            this.doorSpeed = this.getSpeedMultiplierFromUpgrades();
            int itemCount = this.inventory.getStackInSlot(0).getCount();
            if (this.oldItemCount != itemCount) {
                this.oldItemCount = itemCount;
                this.inputTimeOut = 0;
            }
            this.interfaceMode = this.getInterfaceMode(core);
            this.enoughAir = true;
            if (this.interfaceMode != InterfaceDirection.NONE) {
                if (!this.inventory.getStackInSlot(0).isEmpty() && ++this.inputTimeOut > 10) {
                    this.shouldOpenInput = false;
                    if (this.inputProgress == 0.0f) {
                        this.shouldOpenOutput = true;
                        if (this.outputProgress == 40.0f) {
                            if (this.interfaceMode == InterfaceDirection.IMPORT) {
                                this.outputInChamber();
                            } else {
                                this.exportToInventory();
                            }
                        }
                    }
                } else {
                    this.shouldOpenOutput = false;
                    if (this.outputProgress == 0.0f) {
                        this.shouldOpenInput = true;
                        if (this.interfaceMode == InterfaceDirection.EXPORT && this.inputProgress == 40.0f && this.rsController.shouldRun()) {
                            this.importFromChamber(core);
                        }
                    }
                }
            } else {
                this.shouldOpenInput = false;
                this.shouldOpenOutput = false;
            }
        }
        if (this.shouldOpenInput) {
            this.inputProgress = Math.min(this.inputProgress + this.doorSpeed, 40.0f);
            this.isOpeningInput = true;
        } else {
            this.inputProgress = Math.max(this.inputProgress - this.doorSpeed, 0.0f);
            this.isOpeningInput = false;
        }
        if (this.shouldOpenOutput) {
            this.outputProgress = Math.min(this.outputProgress + this.doorSpeed, 40.0f);
            this.isOpeningOutput = true;
        } else {
            this.outputProgress = Math.max(this.outputProgress - this.doorSpeed, 0.0f);
            this.isOpeningOutput = false;
        }
        if (this.nonNullLevel().isClientSide && this.soundTimer++ >= 400 && (wasOpeningI != this.isOpeningInput || wasOpeningO != this.isOpeningOutput)) {
            this.nonNullLevel().playLocalSound((double)this.getBlockPos().getX() + 0.5, (double)this.getBlockPos().getY() + 0.5, (double)this.getBlockPos().getZ() + 0.5, (SoundEvent)ModSounds.INTERFACE_DOOR.get(), SoundSource.BLOCKS, 0.5f, 1.0f, true);
            this.soundTimer = 0;
        }
    }

    public ItemStack getStackInInterface() {
        return this.inventory.getStackInSlot(0);
    }

    private void exportToInventory() {
        Direction facing = this.getRotation();
        BlockEntity te = this.getCachedNeighbor(facing);
        ItemStack stack = this.inventory.getStackInSlot(0);
        if (te != null) {
            int count = stack.getCount();
            ItemStack leftoverStack = IOHelper.insert(te, stack.copy(), facing.getOpposite(), false);
            stack.shrink(count - leftoverStack.getCount());
        } else if (this.getUpgrades(ModUpgrades.DISPENSER.get()) > 0) {
            BlockPos pos = this.getBlockPos().relative(this.getRotation());
            PneumaticCraftUtils.dropItemOnGroundPrecisely(stack, this.getLevel(), (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
            this.inventory.setStackInSlot(0, ItemStack.EMPTY);
        }
    }

    private void importFromChamber(PressureChamberValveBlockEntity core) {
        CombinedInvWrapper chamberHandler = this.exportAny ? core.allItems : core.craftedItems;
        for (int i = 0; i < chamberHandler.getSlots(); ++i) {
            ItemStack toTransferStack;
            ItemStack excess;
            IAirHandlerMachine coreAirHandler;
            int maxAllowedItems;
            ItemStack stackInInterface;
            ItemStack chamberStack = chamberHandler.getStackInSlot(i);
            if (chamberStack.isEmpty() || !(stackInInterface = this.inventory.getStackInSlot(0)).isEmpty() && !ItemStack.isSameItem((ItemStack)stackInInterface, (ItemStack)chamberStack) || (maxAllowedItems = Math.abs((coreAirHandler = Objects.requireNonNull(core.getAirHandler(null))).getAir()) / 1000) <= 0) continue;
            maxAllowedItems = Math.min(maxAllowedItems, chamberStack.getMaxStackSize() - stackInInterface.getCount());
            int transferredItems = Math.min(chamberStack.getCount(), maxAllowedItems);
            if (transferredItems <= 0 || (excess = this.inventory.insertItem(0, toTransferStack = chamberStack.copy().split(transferredItems), true)).getCount() >= toTransferStack.getCount()) continue;
            transferredItems = toTransferStack.getCount() - excess.getCount();
            core.addAir((coreAirHandler.getAir() > 0 ? -1 : 1) * transferredItems * 1000);
            toTransferStack.setCount(transferredItems);
            this.inventory.insertItem(0, toTransferStack, false);
            chamberHandler.extractItem(i, transferredItems, false);
        }
    }

    private void outputInChamber() {
        PressureChamberValveBlockEntity valve = this.getPrimaryValve();
        if (valve != null) {
            ItemStack inputStack = this.inventory.getStackInSlot(0);
            IAirHandlerMachine valveAirHandler = Objects.requireNonNull(valve.getAirHandler(null));
            boolean bl = this.enoughAir = Math.abs(valveAirHandler.getAir()) > inputStack.getCount() * 1000;
            if (this.enoughAir) {
                ItemStack excess = valve.insertItemToChamber(inputStack);
                int inserted = inputStack.getCount() - excess.getCount();
                valve.addAir((valveAirHandler.getAir() > 0 ? -1 : 1) * inserted * 1000);
                this.inventory.setStackInSlot(0, excess);
            }
        }
    }

    private InterfaceDirection getInterfaceMode(PressureChamberValveBlockEntity core) {
        if (core != null) {
            boolean xMid = this.getBlockPos().getX() != core.multiBlockX && this.getBlockPos().getX() != core.multiBlockX + core.multiBlockSize - 1;
            boolean yMid = this.getBlockPos().getY() != core.multiBlockY && this.getBlockPos().getY() != core.multiBlockY + core.multiBlockSize - 1;
            boolean zMid = this.getBlockPos().getZ() != core.multiBlockZ && this.getBlockPos().getZ() != core.multiBlockZ + core.multiBlockSize - 1;
            Direction rotation = this.getRotation();
            if (xMid && yMid && rotation == Direction.NORTH || xMid && zMid && rotation == Direction.DOWN || yMid && zMid && rotation == Direction.WEST) {
                if (this.getBlockPos().getX() == core.multiBlockX || this.getBlockPos().getY() == core.multiBlockY || this.getBlockPos().getZ() == core.multiBlockZ) {
                    return InterfaceDirection.EXPORT;
                }
                return InterfaceDirection.IMPORT;
            }
            if (xMid && yMid && rotation == Direction.SOUTH || xMid && zMid && rotation == Direction.UP || yMid && zMid && rotation == Direction.EAST) {
                if (this.getBlockPos().getX() == core.multiBlockX || this.getBlockPos().getY() == core.multiBlockY || this.getBlockPos().getZ() == core.multiBlockZ) {
                    return InterfaceDirection.IMPORT;
                }
                return InterfaceDirection.EXPORT;
            }
        }
        return InterfaceDirection.NONE;
    }

    public boolean hasEnoughPressure() {
        return this.enoughAir;
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        this.inventory.deserializeNBT(tag.getCompound("Items"));
        this.outputProgress = tag.getFloat("outputProgress");
        this.inputProgress = tag.getFloat("inputProgress");
        this.interfaceMode = InterfaceDirection.values()[tag.getInt("interfaceMode")];
        this.exportAny = tag.getBoolean("exportAny");
    }

    @Override
    public void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        tag.put("Items", (Tag)this.inventory.serializeNBT());
        tag.putFloat("outputProgress", this.outputProgress);
        tag.putFloat("inputProgress", this.inputProgress);
        tag.putInt("interfaceMode", this.interfaceMode.ordinal());
        tag.putBoolean("exportAny", this.exportAny);
    }

    @Override
    public boolean isGuiUseableByPlayer(Player player) {
        return this.nonNullLevel().getBlockEntity(this.getBlockPos()) == this && player.distanceToSqr((double)this.getBlockPos().getX() + 0.5, (double)this.getBlockPos().getY() + 0.5, (double)this.getBlockPos().getZ() + 0.5) <= 64.0;
    }

    @Override
    public IItemHandler getItemHandler(@Nullable Direction dir) {
        return this.inventory;
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
        if (this.rsController.parseRedstoneMode(tag)) {
            return;
        }
        if (tag.equals("export_mode")) {
            this.exportAny = !this.exportAny;
            this.setChanged();
        }
    }

    @Override
    public RedstoneController<PressureChamberInterfaceBlockEntity> getRedstoneController() {
        return this.rsController;
    }

    private class PressureChamberInterfaceHandler
    extends BaseItemStackHandler {
        PressureChamberInterfaceHandler() {
            super(PressureChamberInterfaceBlockEntity.this, 1);
        }

        @Override
        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return PressureChamberInterfaceBlockEntity.this.inputProgress == 40.0f && this.isValidItem(stack) ? super.insertItem(slot, stack, simulate) : stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return PressureChamberInterfaceBlockEntity.this.outputProgress == 40.0f ? super.extractItem(slot, amount, simulate) : ItemStack.EMPTY;
        }

        private boolean isValidItem(ItemStack stack) {
            if (PressureChamberInterfaceBlockEntity.this.interfaceMode == InterfaceDirection.IMPORT) {
                return acceptedItemCache.isAcceptable(stack.getItem(), () -> ModRecipeTypes.PRESSURE_CHAMBER.get().stream(PressureChamberInterfaceBlockEntity.this.level).map(RecipeHolder::value).anyMatch(recipe -> recipe.isValidInputItem(stack)));
            }
            return PressureChamberInterfaceBlockEntity.this.interfaceMode == InterfaceDirection.EXPORT;
        }
    }

    public static enum InterfaceDirection implements ITranslatableEnum
    {
        NONE,
        IMPORT,
        EXPORT;


        @Override
        public String getTranslationKey() {
            return "pneumaticcraft.gui.pressureChamberInterface.mode." + this.toString().toLowerCase(Locale.ROOT);
        }
    }
}

