/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity.processing;

import com.google.common.math.IntMath;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.api.block.PNCBlockStateProperties;
import me.desht.pneumaticcraft.api.crafting.recipe.PressureChamberRecipe;
import me.desht.pneumaticcraft.api.pressure.PressureTier;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import me.desht.pneumaticcraft.api.tileentity.IAirListener;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.PNCDamageSource;
import me.desht.pneumaticcraft.common.block.IBlockPressureChamber;
import me.desht.pneumaticcraft.common.block.PressureChamberGlassBlock;
import me.desht.pneumaticcraft.common.block.PressureChamberValveBlock;
import me.desht.pneumaticcraft.common.block.entity.AbstractAirHandlingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.AbstractPneumaticCraftBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.block.entity.processing.PressureChamberWallBlockEntity;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.inventory.PressureChamberValveMenu;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticle;
import me.desht.pneumaticcraft.common.particle.AirParticleData;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import me.desht.pneumaticcraft.common.registry.ModRecipeTypes;
import me.desht.pneumaticcraft.common.util.CountedItemStacks;
import me.desht.pneumaticcraft.common.util.ItemStackHandlerIterable;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.SizeLimitedItemHandlerWrapper;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PressureChamberValveBlockEntity
extends AbstractAirHandlingBlockEntity
implements IMinWorkingPressure,
IAirListener,
MenuProvider {
    private static final int CHAMBER_INV_SIZE = 18;
    private static final int OUTPUT_INV_SIZE = 9;
    @DescSynced
    public int multiBlockX;
    @DescSynced
    public int multiBlockY;
    @DescSynced
    public int multiBlockZ;
    @DescSynced
    public int multiBlockSize;
    @DescSynced
    public boolean hasGlass;
    @DescSynced
    private float roundedPressure;
    @GuiSynced
    public boolean isValidRecipeInChamber;
    @GuiSynced
    public boolean isSufficientPressureInChamber;
    @GuiSynced
    public float recipePressure;
    private final ItemStackHandler itemsInChamber = new ChamberStackHandler();
    final ItemStackHandler craftedItems = new OutputStackHandler();
    @DescSynced
    final CombinedInvWrapper allItems = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.itemsInChamber, this.craftedItems});
    public final List<ItemStack> renderedItems = new ArrayList<ItemStack>();
    public List<PressureChamberValveBlockEntity> accessoryValves;
    private final List<BlockPos> nbtValveList;
    private final List<ApplicableRecipe> applicableRecipes = new ArrayList<ApplicableRecipe>();
    private boolean recipeRecalcNeeded = true;
    private long lastSoundTick;
    private int nParticles;
    private boolean triedRebuild;
    private int savedMultiblockSize = 0;

    public PressureChamberValveBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntityTypes.PRESSURE_CHAMBER_VALVE.get(), pos, state, PressureTier.TIER_ONE, 16000, 4);
        this.accessoryValves = new ArrayList<PressureChamberValveBlockEntity>();
        this.nbtValveList = new ArrayList<BlockPos>();
    }

    @Override
    public boolean hasItemCapability() {
        return false;
    }

    @Override
    protected boolean shouldRerenderChunkOnDescUpdate() {
        return true;
    }

    @Override
    public boolean canConnectPneumatic(Direction side) {
        return side.getAxis() == this.getRotation().getAxis();
    }

    @Override
    public List<IAirHandlerMachine> addConnectedPneumatics(List<IAirHandlerMachine> airHandlers) {
        if (this.accessoryValves != null) {
            for (PressureChamberValveBlockEntity valve : this.accessoryValves) {
                if (valve == this) continue;
                airHandlers.add(valve.airHandler);
            }
        }
        return airHandlers;
    }

    @Override
    public void tickClient() {
        super.tickClient();
        if (this.hasGlass && this.isPrimaryValve() && ((Boolean)ConfigHelper.client().general.pressureChamberParticles.get()).booleanValue() && (double)this.roundedPressure > 0.2 && ClientUtils.getClientPlayer().distanceToSqr((double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ()) < 256.0) {
            Level level = this.nonNullLevel();
            for (int i = 0; i < this.nParticles; ++i) {
                double posX = (double)this.multiBlockX + 1.0 + level.random.nextDouble() * ((double)this.multiBlockSize - 2.0);
                double posY = (double)this.multiBlockY + 1.5 + level.random.nextDouble() * ((double)this.multiBlockSize - 2.5);
                double posZ = (double)this.multiBlockZ + 1.0 + level.random.nextDouble() * ((double)this.multiBlockSize - 2.0);
                level.addParticle((ParticleOptions)AirParticleData.DENSE, posX, posY, posZ, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public void tickServer() {
        super.tickServer();
        this.checkForAirLeak();
        if (this.multiBlockSize != 0) {
            this.roundedPressure = (float)((int)(this.getPressure() * 4.0f)) / 4.0f;
            this.checkForRecipeRecalc();
            this.processApplicableRecipes();
            if (this.getPressure() > 1.0f) {
                this.handleEntitiesInChamber();
            }
        }
    }

    private void checkForRecipeRecalc() {
        if (this.recipeRecalcNeeded) {
            this.isValidRecipeInChamber = false;
            this.isSufficientPressureInChamber = false;
            this.recipePressure = Float.MAX_VALUE;
            this.applicableRecipes.clear();
            SizeLimitedItemHandlerWrapper h = new SizeLimitedItemHandlerWrapper((IItemHandler)this.itemsInChamber);
            if (h.getSlots() > 0) {
                ModRecipeTypes.PRESSURE_CHAMBER.get().stream(this.level).map(RecipeHolder::value).forEach(recipe -> {
                    IntCollection slots = recipe.findIngredients(h);
                    if (!slots.isEmpty()) {
                        this.applicableRecipes.add(new ApplicableRecipe((PressureChamberRecipe)recipe, slots));
                    }
                });
            }
            this.isValidRecipeInChamber = !this.applicableRecipes.isEmpty();
            this.recipeRecalcNeeded = !this.isValidRecipeInChamber && this.coalesceItems();
        }
    }

    private boolean coalesceItems() {
        CountedItemStacks count = new CountedItemStacks((IItemHandler)this.itemsInChamber);
        if (!count.canCoalesce()) {
            return false;
        }
        NonNullList<ItemStack> coalesced = count.coalesce();
        for (int i = 0; i < this.itemsInChamber.getSlots(); ++i) {
            if (i < coalesced.size()) {
                this.itemsInChamber.setStackInSlot(i, (ItemStack)coalesced.get(i));
                continue;
            }
            this.itemsInChamber.setStackInSlot(i, ItemStack.EMPTY);
        }
        return true;
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.doPostNBTSetup();
    }

    private void doPostNBTSetup() {
        if (!this.nbtValveList.isEmpty()) {
            BlockState state = this.nonNullLevel().getBlockState(this.getBlockPos());
            if (state.getBlock() instanceof PressureChamberValveBlock) {
                this.nonNullLevel().setBlock(this.getBlockPos(), (BlockState)state.setValue((Property)PNCBlockStateProperties.FORMED, (Comparable)Boolean.valueOf(this.isPrimaryValve())), 2);
            }
            this.accessoryValves.clear();
            for (BlockPos valve : this.nbtValveList) {
                BlockEntity te = this.nonNullLevel().getBlockEntity(valve);
                if (!(te instanceof PressureChamberValveBlockEntity)) continue;
                this.accessoryValves.add((PressureChamberValveBlockEntity)te);
            }
            if (this.isPrimaryValve()) {
                this.hasGlass = this.checkForGlass();
                this.sendDescriptionPacket();
            }
            this.nbtValveList.clear();
        }
    }

    private void checkForAirLeak() {
        PressureChamberValveBlockEntity primaryValve;
        BitSet disconnected = this.getDisconnectedSides();
        List<IAirHandlerMachine.Connection> l = this.airHandler.getConnectedAirHandlers(this);
        for (IAirHandlerMachine.Connection c : l) {
            if (c.getDirection() == null) continue;
            disconnected.clear(c.getDirection().get3DDataValue());
        }
        if (this.accessoryValves.isEmpty() && !this.triedRebuild) {
            if (PressureChamberValveBlockEntity.checkIfProperlyFormed(this.level, this.worldPosition, true)) {
                Log.warning("Rebuilt damaged pressure chamber multiblock: valve pos = " + this.worldPosition, new Object[0]);
            }
            this.triedRebuild = true;
        }
        PressureChamberValveBlockEntity pressureChamberValveBlockEntity = primaryValve = this.accessoryValves.isEmpty() ? null : this.accessoryValves.get(this.accessoryValves.size() - 1);
        if (primaryValve != null) {
            switch (this.getRotation().getAxis()) {
                case X: {
                    if (primaryValve.multiBlockX == this.getBlockPos().getX()) {
                        disconnected.clear(Direction.EAST.get3DDataValue());
                        break;
                    }
                    disconnected.clear(Direction.WEST.get3DDataValue());
                    break;
                }
                case Y: {
                    if (primaryValve.multiBlockY == this.getBlockPos().getY()) {
                        disconnected.clear(Direction.UP.get3DDataValue());
                        break;
                    }
                    disconnected.clear(Direction.DOWN.get3DDataValue());
                    break;
                }
                case Z: {
                    if (primaryValve.multiBlockZ == this.getBlockPos().getZ()) {
                        disconnected.clear(Direction.SOUTH.get3DDataValue());
                        break;
                    }
                    disconnected.clear(Direction.NORTH.get3DDataValue());
                }
            }
        }
        this.airHandler.setSideLeaking(disconnected.isEmpty() ? null : this.getRotation());
    }

    @NotNull
    private BitSet getDisconnectedSides() {
        BitSet disconnected = new BitSet(6);
        switch (this.getRotation().getAxis()) {
            case X: {
                disconnected.set(Direction.WEST.get3DDataValue());
                disconnected.set(Direction.EAST.get3DDataValue());
                break;
            }
            case Y: {
                disconnected.set(Direction.UP.get3DDataValue());
                disconnected.set(Direction.DOWN.get3DDataValue());
                break;
            }
            case Z: {
                disconnected.set(Direction.NORTH.get3DDataValue());
                disconnected.set(Direction.SOUTH.get3DDataValue());
            }
        }
        return disconnected;
    }

    private void processApplicableRecipes() {
        for (ApplicableRecipe applicableRecipe : this.applicableRecipes) {
            boolean pressureOK;
            PressureChamberRecipe recipe = applicableRecipe.recipe;
            float requiredPressure = recipe.getCraftingPressure((IItemHandler)this.itemsInChamber, applicableRecipe.slots);
            boolean bl = pressureOK = requiredPressure <= this.getPressure() && requiredPressure > 0.0f || requiredPressure >= this.getPressure() && requiredPressure < 0.0f;
            if (Math.abs(requiredPressure) < Math.abs(this.recipePressure)) {
                this.recipePressure = requiredPressure;
            }
            if (!pressureOK) continue;
            this.isSufficientPressureInChamber = true;
            if (!this.giveOutput(recipe.craftRecipe((IItemHandler)this.itemsInChamber, applicableRecipe.slots, true), true) || !this.giveOutput(recipe.craftRecipe((IItemHandler)this.itemsInChamber, applicableRecipe.slots, false), false) || this.nonNullLevel().getGameTime() - this.lastSoundTick <= 5L) break;
            this.nonNullLevel().playSound(null, this.getBlockPos(), SoundEvents.CHICKEN_EGG, SoundSource.BLOCKS, 0.7f, 0.8f);
            this.lastSoundTick = this.nonNullLevel().getGameTime();
            break;
        }
    }

    private void handleEntitiesInChamber() {
        AABB bbBox = new AABB((double)(this.multiBlockX + 1), (double)(this.multiBlockY + 1), (double)(this.multiBlockZ + 1), (double)(this.multiBlockX + this.multiBlockSize - 1), (double)(this.multiBlockY + this.multiBlockSize - 1), (double)(this.multiBlockZ + this.multiBlockSize - 1));
        List entities = this.nonNullLevel().getEntitiesOfClass(LivingEntity.class, bbBox);
        for (LivingEntity entity : entities) {
            entity.hurt(PNCDamageSource.pressure(this.getLevel()), (float)((int)((double)this.getPressure() * 2.0)));
        }
    }

    private boolean checkForGlass() {
        BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos();
        for (int x = 0; x < this.multiBlockSize; ++x) {
            for (int y = 0; y < this.multiBlockSize; ++y) {
                for (int z = 0; z < this.multiBlockSize; ++z) {
                    mPos = mPos.set(this.multiBlockX + x, this.multiBlockY + y, this.multiBlockZ + z);
                    if (!(this.nonNullLevel().getBlockState((BlockPos)mPos).getBlock() instanceof PressureChamberGlassBlock)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean giveOutput(List<ItemStack> stacks, boolean simulate) {
        if (stacks.isEmpty()) {
            return false;
        }
        for (ItemStack stack : stacks) {
            ItemStack result = ItemHandlerHelper.insertItem((IItemHandler)this.craftedItems, (ItemStack)(stack = stack.copy()), (boolean)simulate);
            if (result.isEmpty()) continue;
            return false;
        }
        return true;
    }

    ItemStack insertItemToChamber(ItemStack stack) {
        return ItemHandlerHelper.insertItem((IItemHandler)this.itemsInChamber, (ItemStack)stack.copy(), (boolean)false);
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        this.setupMultiBlock(tag.getInt("multiBlockSize"), tag.getInt("multiBlockX"), tag.getInt("multiBlockY"), tag.getInt("multiBlockZ"));
        ItemStackHandler handler = new ItemStackHandler();
        handler.deserializeNBT(tag.getCompound("itemsInChamber"));
        for (int i = 0; i < handler.getSlots() && i < 18; ++i) {
            this.itemsInChamber.setStackInSlot(i, handler.getStackInSlot(i));
        }
        ItemStackHandler outHandler = new ItemStackHandler();
        outHandler.deserializeNBT(tag.getCompound("craftedItems"));
        for (int i = 0; i < outHandler.getSlots() && i < 9; ++i) {
            this.craftedItems.setStackInSlot(i, outHandler.getStackInSlot(i));
        }
        ListTag accList = tag.getList("Valves", 10);
        this.nbtValveList.clear();
        for (int i = 0; i < accList.size(); ++i) {
            CompoundTag tagCompound = accList.getCompound(i);
            this.nbtValveList.add(NbtUtils.readBlockPos((CompoundTag)tagCompound));
        }
    }

    @Override
    public void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        tag.putInt("multiBlockX", this.multiBlockX);
        tag.putInt("multiBlockY", this.multiBlockY);
        tag.putInt("multiBlockZ", this.multiBlockZ);
        tag.putInt("multiBlockSize", this.multiBlockSize);
        tag.put("itemsInChamber", (Tag)this.itemsInChamber.serializeNBT());
        tag.put("craftedItems", (Tag)this.craftedItems.serializeNBT());
        ListTag accList = this.accessoryValves.stream().map(valve -> NbtUtils.writeBlockPos((BlockPos)valve.getBlockPos())).collect(Collectors.toCollection(ListTag::new));
        tag.put("Valves", (Tag)accList);
    }

    public void onMultiBlockBreak() {
        if (this.isPrimaryValve()) {
            Iterator<ItemStack> itemsInChamberIterator = new ItemStackHandlerIterable((IItemHandlerModifiable)this.allItems).iterator();
            while (itemsInChamberIterator.hasNext()) {
                ItemStack stack = itemsInChamberIterator.next();
                if (stack.isEmpty()) continue;
                this.dropItemOnGround(stack);
                itemsInChamberIterator.remove();
            }
            this.invalidateMultiBlock();
        }
    }

    private void dropItemOnGround(ItemStack stack) {
        PneumaticCraftUtils.dropItemOnGroundPrecisely(stack, this.getLevel(), (double)this.multiBlockX + (double)this.multiBlockSize / 2.0, (double)this.multiBlockY + 1.0, (double)this.multiBlockZ + (double)this.multiBlockSize / 2.0);
    }

    private void invalidateMultiBlock() {
        for (int x = 0; x < this.multiBlockSize; ++x) {
            for (int y = 0; y < this.multiBlockSize; ++y) {
                for (int z = 0; z < this.multiBlockSize; ++z) {
                    BlockEntity te = this.nonNullLevel().getBlockEntity(new BlockPos(x + this.multiBlockX, y + this.multiBlockY, z + this.multiBlockZ));
                    if (!(te instanceof PressureChamberWallBlockEntity)) continue;
                    PressureChamberWallBlockEntity teWall = (PressureChamberWallBlockEntity)te;
                    teWall.setPrimaryValve(null);
                }
            }
        }
        if (this.accessoryValves != null) {
            for (PressureChamberValveBlockEntity valve : this.accessoryValves) {
                valve.savedMultiblockSize = valve.multiBlockSize;
                float pressure = valve.getPressure();
                valve.setupMultiBlock(0, 0, 0, 0);
                valve.airHandler.setPressure(pressure);
                if (valve != this) {
                    valve.accessoryValves.clear();
                    valve.sendDescriptionPacket();
                }
                valve.setChanged();
            }
            this.accessoryValves.clear();
        }
        this.sendDescriptionPacket();
    }

    private void setupMultiBlock(int size, int baseX, int baseY, int baseZ) {
        this.multiBlockSize = size;
        this.multiBlockX = baseX;
        this.multiBlockY = baseY;
        this.multiBlockZ = baseZ;
        int vol = 16000;
        this.airHandler.setBaseVolume(this.multiBlockSize > 3 ? vol * IntMath.pow((int)(this.multiBlockSize - 2), (int)3) : vol);
    }

    @Override
    public void onDescUpdate() {
        super.onDescUpdate();
        this.nParticles = (int)(Math.min(1.0f, this.roundedPressure / this.getDangerPressure() * (float)(this.multiBlockSize - 2) * (float)(this.multiBlockSize - 2)) * 2.0f);
    }

    @Override
    public IItemHandler getItemHandler(@Nullable Direction dir) {
        return null;
    }

    public static boolean checkIfProperlyFormed(Level world, BlockPos pos) {
        return PressureChamberValveBlockEntity.checkIfProperlyFormed(world, pos, false);
    }

    public static boolean checkIfProperlyFormed(Level world, BlockPos pos, boolean forceRebuild) {
        for (int i = 3; i < 6; ++i) {
            if (!PressureChamberValveBlockEntity.checkForShiftedCubeOfSize(i, world, pos, forceRebuild)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkForShiftedCubeOfSize(int size, Level world, BlockPos pos, boolean forceRebuild) {
        int baseX = pos.getX();
        int baseY = pos.getY();
        int baseZ = pos.getZ();
        BlockPos rebuildPos = forceRebuild ? pos : null;
        for (int wallX = 0; wallX < size; ++wallX) {
            for (int wallY = 0; wallY < size; ++wallY) {
                if (PressureChamberValveBlockEntity.checkForCubeOfSize(size, world, baseX, baseY - wallY, baseZ - wallX, rebuildPos)) {
                    return true;
                }
                if (PressureChamberValveBlockEntity.checkForCubeOfSize(size, world, baseX, baseY + wallY, baseZ + wallX, rebuildPos)) {
                    return true;
                }
                if (PressureChamberValveBlockEntity.checkForCubeOfSize(size, world, baseX - wallX, baseY - wallY, baseZ, rebuildPos)) {
                    return true;
                }
                if (PressureChamberValveBlockEntity.checkForCubeOfSize(size, world, baseX + wallX, baseY + wallY, baseZ, rebuildPos)) {
                    return true;
                }
                if (PressureChamberValveBlockEntity.checkForCubeOfSize(size, world, baseX - wallX, baseY, baseZ - wallY, rebuildPos)) {
                    return true;
                }
                if (PressureChamberValveBlockEntity.checkForCubeOfSize(size, world, baseX + wallX, baseY, baseZ + wallY, rebuildPos)) {
                    return true;
                }
                if (PressureChamberValveBlockEntity.checkForCubeOfSize(size, world, baseX - size + 1, baseY - wallY, baseZ - wallX, rebuildPos)) {
                    return true;
                }
                if (PressureChamberValveBlockEntity.checkForCubeOfSize(size, world, baseX - size + 1, baseY + wallY, baseZ + wallX, rebuildPos)) {
                    return true;
                }
                if (PressureChamberValveBlockEntity.checkForCubeOfSize(size, world, baseX - wallX, baseY - wallY, baseZ - size + 1, rebuildPos)) {
                    return true;
                }
                if (PressureChamberValveBlockEntity.checkForCubeOfSize(size, world, baseX + wallX, baseY + wallY, baseZ - size + 1, rebuildPos)) {
                    return true;
                }
                if (PressureChamberValveBlockEntity.checkForCubeOfSize(size, world, baseX - wallX, baseY - size + 1, baseZ - wallY, rebuildPos)) {
                    return true;
                }
                if (!PressureChamberValveBlockEntity.checkForCubeOfSize(size, world, baseX + wallX, baseY - size + 1, baseZ + wallY, rebuildPos)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean checkForCubeOfSize(int size, Level world, int baseX, int baseY, int baseZ, BlockPos rebuildPos) {
        ArrayList<PressureChamberValveBlockEntity> valveList = new ArrayList<PressureChamberValveBlockEntity>();
        BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos();
        for (int x = 0; x < size; ++x) {
            for (int y = 0; y < size; ++y) {
                for (int z = 0; z < size; ++z) {
                    PressureChamberValveBlockEntity teV;
                    mPos = mPos.set(x + baseX, y + baseY, z + baseZ);
                    BlockState state = world.getBlockState((BlockPos)mPos);
                    if (x != 0 && x != size - 1 && y != 0 && y != size - 1 && z != 0 && z != size - 1) {
                        if (world.isEmptyBlock((BlockPos)mPos)) continue;
                        return false;
                    }
                    if (!(state.getBlock() instanceof IBlockPressureChamber)) {
                        return false;
                    }
                    if (state.getBlock() instanceof PressureChamberValveBlock) {
                        boolean xMid = x != 0 && x != size - 1;
                        boolean yMid = y != 0 && y != size - 1;
                        boolean zMid = z != 0 && z != size - 1;
                        Direction facing = (Direction)state.getValue((Property)BlockStateProperties.FACING);
                        if (xMid && yMid && facing.getAxis() == Direction.Axis.Z || xMid && zMid && facing.getAxis() == Direction.Axis.Y || yMid && zMid && facing.getAxis() == Direction.Axis.X) {
                            BlockEntity te = world.getBlockEntity((BlockPos)mPos);
                            if (!(te instanceof PressureChamberValveBlockEntity)) continue;
                            valveList.add((PressureChamberValveBlockEntity)te);
                            continue;
                        }
                        return false;
                    }
                    BlockEntity te = world.getBlockEntity((BlockPos)mPos);
                    if (!(te instanceof PressureChamberWallBlockEntity) || (teV = ((PressureChamberWallBlockEntity)te).getPrimaryValve()) == null || rebuildPos != null && rebuildPos.equals((Object)teV.getBlockPos())) continue;
                    return false;
                }
            }
        }
        if (valveList.isEmpty()) {
            return false;
        }
        PressureChamberValveBlockEntity primaryValve = (PressureChamberValveBlockEntity)valveList.get(valveList.size() - 1);
        valveList.forEach(valve -> {
            valve.accessoryValves = new ArrayList<PressureChamberValveBlockEntity>(valveList);
        });
        if (valveList.size() > 1) {
            PressureChamberValveBlockEntity.maybeMoveUpgrades(valveList, primaryValve);
        }
        float pressure = primaryValve.getPressure();
        primaryValve.setupMultiBlock(size, baseX, baseY, baseZ);
        if (primaryValve.savedMultiblockSize == primaryValve.multiBlockSize) {
            primaryValve.airHandler.setPressure(pressure);
        }
        primaryValve.savedMultiblockSize = 0;
        primaryValve.hasGlass = false;
        for (int x = 0; x < size; ++x) {
            for (int y = 0; y < size; ++y) {
                for (int z = 0; z < size; ++z) {
                    BlockEntity be = world.getBlockEntity(new BlockPos(x + baseX, y + baseY, z + baseZ));
                    if (be instanceof PressureChamberWallBlockEntity) {
                        PressureChamberWallBlockEntity wall = (PressureChamberWallBlockEntity)be;
                        wall.setPrimaryValve(primaryValve);
                        if (world.getBlockState(be.getBlockPos()).getBlock() instanceof PressureChamberGlassBlock) {
                            primaryValve.hasGlass = true;
                        }
                    } else if (be instanceof PressureChamberValveBlockEntity) {
                        PressureChamberValveBlockEntity v = (PressureChamberValveBlockEntity)be;
                        BlockState state = world.getBlockState(be.getBlockPos());
                        world.setBlock(be.getBlockPos(), (BlockState)state.setValue((Property)PNCBlockStateProperties.FORMED, (Comparable)Boolean.valueOf(v.isPrimaryValve())), 2);
                    }
                    if (be == null) continue;
                    float dx = x == 0 ? -0.1f : 0.1f;
                    float dz = z == 0 ? -0.1f : 0.1f;
                    NetworkHandler.sendToAllTracking((CustomPacketPayload)new PacketSpawnParticle((ParticleOptions)ParticleTypes.POOF, (double)be.getBlockPos().getX() + 0.5, (double)be.getBlockPos().getY() + 0.5, (double)be.getBlockPos().getZ() + 0.5, (double)dx, 0.3, (double)dz, 5, 0.0, 0.0, 0.0), be);
                }
            }
        }
        primaryValve.captureEntityItemsInChamber();
        primaryValve.scheduleDescriptionPacket();
        valveList.forEach(AbstractPneumaticCraftBlockEntity::setChanged);
        return true;
    }

    private static void maybeMoveUpgrades(List<PressureChamberValveBlockEntity> valveList, PressureChamberValveBlockEntity primaryValve) {
        AbstractPneumaticCraftBlockEntity.UpgradeHandler primaryUpgradeHandler = primaryValve.getUpgradeHandler();
        for (PressureChamberValveBlockEntity valve : valveList) {
            if (valve == primaryValve) continue;
            AbstractPneumaticCraftBlockEntity.UpgradeHandler upgradeHandler = valve.getUpgradeHandler();
            for (int i = 0; i < upgradeHandler.getSlots(); ++i) {
                ItemStack stack = upgradeHandler.getStackInSlot(i);
                if (stack.isEmpty()) continue;
                ItemStack excess = ItemHandlerHelper.insertItemStacked((IItemHandler)primaryUpgradeHandler, (ItemStack)stack, (boolean)false);
                upgradeHandler.setStackInSlot(i, excess);
            }
        }
    }

    private boolean isPrimaryValve() {
        return this.multiBlockSize > 0;
    }

    public AABB getChamberAABB() {
        return new AABB((double)this.multiBlockX, (double)this.multiBlockY, (double)this.multiBlockZ, (double)(this.multiBlockX + this.multiBlockSize), (double)(this.multiBlockY + this.multiBlockSize), (double)(this.multiBlockZ + this.multiBlockSize));
    }

    private void captureEntityItemsInChamber() {
        List items = this.nonNullLevel().getEntitiesOfClass(ItemEntity.class, this.getChamberAABB(), EntitySelector.ENTITY_STILL_ALIVE);
        for (ItemEntity item : items) {
            ItemStack stack = item.getItem();
            ItemStack excess = ItemHandlerHelper.insertItem((IItemHandler)this.itemsInChamber, (ItemStack)stack, (boolean)false);
            if (excess.isEmpty()) {
                item.discard();
                continue;
            }
            item.setItem(excess);
        }
    }

    @Override
    public float getMinWorkingPressure() {
        return this.isValidRecipeInChamber ? this.recipePressure : -3.4028235E38f;
    }

    @javax.annotation.Nullable
    public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player playerEntity) {
        return new PressureChamberValveMenu(i, playerInventory, this.getBlockPos());
    }

    private void rebuildRenderedItems() {
        this.renderedItems.clear();
        for (int i = 0; i < this.allItems.getSlots(); ++i) {
            if (this.allItems.getStackInSlot(i).isEmpty()) continue;
            this.renderedItems.add(this.allItems.getStackInSlot(i));
        }
    }

    private class ChamberStackHandler
    extends ItemStackHandler {
        ChamberStackHandler() {
            super(18);
        }

        protected void onContentsChanged(int slot) {
            PressureChamberValveBlockEntity.this.recipeRecalcNeeded = true;
            if (PressureChamberValveBlockEntity.this.level != null && ((PressureChamberValveBlockEntity)PressureChamberValveBlockEntity.this).level.isClientSide) {
                PressureChamberValveBlockEntity.this.rebuildRenderedItems();
            }
            PressureChamberValveBlockEntity.this.setChanged();
        }
    }

    private class OutputStackHandler
    extends ItemStackHandler {
        OutputStackHandler() {
            super(9);
        }

        protected void onContentsChanged(int slot) {
            if (PressureChamberValveBlockEntity.this.level != null && ((PressureChamberValveBlockEntity)PressureChamberValveBlockEntity.this).level.isClientSide) {
                PressureChamberValveBlockEntity.this.rebuildRenderedItems();
            }
            PressureChamberValveBlockEntity.this.setChanged();
        }
    }

    private static class ApplicableRecipe {
        final PressureChamberRecipe recipe;
        final IntList slots;

        ApplicableRecipe(PressureChamberRecipe recipe, IntCollection slots) {
            this.recipe = recipe;
            this.slots = new IntArrayList(slots);
        }
    }
}

