/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity.processing;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import me.desht.pneumaticcraft.api.block.PNCBlockStateProperties;
import me.desht.pneumaticcraft.api.block.PressureChamberWallState;
import me.desht.pneumaticcraft.api.tileentity.IManoMeasurable;
import me.desht.pneumaticcraft.common.block.entity.AbstractTickingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IInfoForwarder;
import me.desht.pneumaticcraft.common.block.entity.processing.PressureChamberValveBlockEntity;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.event.TickEvent;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class PressureChamberWallBlockEntity
extends AbstractTickingBlockEntity
implements IManoMeasurable,
IInfoForwarder {
    private PressureChamberValveBlockEntity teValve;
    private BlockPos valvePos;

    public PressureChamberWallBlockEntity(BlockPos pos, BlockState state) {
        this(ModBlockEntityTypes.PRESSURE_CHAMBER_WALL.get(), pos, state, 0);
    }

    PressureChamberWallBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int upgradeSize) {
        super(type, pos, state, upgradeSize);
    }

    @Override
    public boolean hasItemCapability() {
        return false;
    }

    public PressureChamberValveBlockEntity getPrimaryValve() {
        if (this.teValve == null && this.valvePos != null) {
            PressureChamberValveBlockEntity v;
            BlockEntity blockEntity = this.nonNullLevel().getBlockEntity(this.valvePos);
            this.setPrimaryValve(blockEntity instanceof PressureChamberValveBlockEntity ? (v = (PressureChamberValveBlockEntity)blockEntity) : null);
        }
        return this.teValve;
    }

    void setPrimaryValve(PressureChamberValveBlockEntity newValve) {
        boolean valveChanging = this.teValve != newValve || newValve == null && this.valvePos != null || newValve != null && this.valvePos == null;
        BlockPos blockPos = this.valvePos = newValve == null ? null : newValve.getBlockPos();
        if (valveChanging && !this.nonNullLevel().isClientSide) {
            this.teValve = newValve;
            PressureWallStateManager.addDeferredUpdate(this, this.teValve);
            this.setChanged();
        }
    }

    public void onBlockBreak() {
        this.teValve = this.getPrimaryValve();
        if (this.teValve != null) {
            this.teValve.onMultiBlockBreak();
        }
    }

    private void updateBlockState(PressureChamberValveBlockEntity valve) {
        if (!(this.isRemoved() || valve != null && valve.isRemoved())) {
            if (this.getBlockState().hasProperty(PNCBlockStateProperties.WALL_STATE)) {
                this.nonNullLevel().setBlock(this.getBlockPos(), this.calcNewWallState(valve), 2);
            } else if (this.getBlockState().hasProperty((Property)PNCBlockStateProperties.FORMED)) {
                this.nonNullLevel().setBlock(this.getBlockPos(), this.calcNewGlassState(valve), 2);
            }
        }
    }

    private BlockState calcNewGlassState(PressureChamberValveBlockEntity valve) {
        return (BlockState)this.getBlockState().setValue((Property)PNCBlockStateProperties.FORMED, (Comparable)Boolean.valueOf(valve != null && !valve.isRemoved()));
    }

    private BlockState calcNewWallState(PressureChamberValveBlockEntity valve) {
        PressureChamberWallState wallState = PressureChamberWallState.NONE;
        if (valve != null && !valve.isRemoved()) {
            boolean zMax;
            boolean xMin = this.getBlockPos().getX() == valve.multiBlockX;
            boolean yMin = this.getBlockPos().getY() == valve.multiBlockY;
            boolean zMin = this.getBlockPos().getZ() == valve.multiBlockZ;
            boolean xMax = this.getBlockPos().getX() == valve.multiBlockX + valve.multiBlockSize - 1;
            boolean yMax = this.getBlockPos().getY() == valve.multiBlockY + valve.multiBlockSize - 1;
            boolean bl = zMax = this.getBlockPos().getZ() == valve.multiBlockZ + valve.multiBlockSize - 1;
            wallState = xMin && yMin && zMin || xMax && yMax && zMax ? PressureChamberWallState.XMIN_YMIN_ZMIN : (xMin && yMin && zMax || xMax && yMax && zMin ? PressureChamberWallState.XMIN_YMIN_ZMAX : (xMin && yMax && zMax || xMax && yMin && zMin ? PressureChamberWallState.XMIN_YMAX_ZMAX : (xMin && yMax && zMin || xMax && yMin && zMax ? PressureChamberWallState.XMIN_YMAX_ZMIN : (yMin && xMin || yMax && xMax || yMin && xMax || yMax && xMin ? PressureChamberWallState.XEDGE : (yMin && zMin || yMax && zMax || yMin && zMax || yMax && zMin ? PressureChamberWallState.ZEDGE : (!yMin && !yMax ? (xMin && zMin || xMax && zMax || xMin && zMax || xMax && zMin ? PressureChamberWallState.YEDGE : PressureChamberWallState.CENTER) : PressureChamberWallState.CENTER))))));
        }
        return (BlockState)this.getBlockState().setValue(PNCBlockStateProperties.WALL_STATE, (Comparable)((Object)wallState));
    }

    @Override
    public void onDescUpdate() {
        super.onDescUpdate();
        this.teValve = null;
    }

    @Override
    public IItemHandler getItemHandler(@Nullable Direction dir) {
        return null;
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        this.valvePos = tag.getBoolean("noValve") ? null : (tag.contains("valvePos") ? NbtUtils.readBlockPos((CompoundTag)tag.getCompound("valvePos")) : new BlockPos(tag.getInt("valveX"), tag.getInt("valveY"), tag.getInt("valveZ")));
        this.teValve = null;
    }

    @Override
    public void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        if (this.valvePos == null) {
            tag.putBoolean("noValve", true);
        } else {
            tag.put("valvePos", (Tag)NbtUtils.writeBlockPos((BlockPos)this.valvePos));
        }
    }

    @Override
    public void printManometerMessage(Player player, List<Component> curInfo) {
        if (this.getPrimaryValve() != null) {
            this.teValve.getAirHandler(null).printManometerMessage(player, curInfo);
        }
    }

    @Override
    protected boolean shouldRerenderChunkOnDescUpdate() {
        return true;
    }

    @Override
    public BlockEntity getInfoBlockEntity() {
        return this.getPrimaryValve();
    }

    @Mod.EventBusSubscriber(modid="pneumaticcraft")
    public static class PressureWallStateManager {
        private static final Deque<WallAndValve> todo = new ArrayDeque<WallAndValve>();

        @SubscribeEvent
        public static void onServerTick(TickEvent.ServerTickEvent event) {
            if (event.phase == TickEvent.Phase.END) {
                while (!todo.isEmpty()) {
                    WallAndValve element = todo.poll();
                    element.wall().updateBlockState(element.valve());
                }
            }
        }

        private static void addDeferredUpdate(PressureChamberWallBlockEntity wall, PressureChamberValveBlockEntity valve) {
            todo.offer(new WallAndValve(wall, valve));
        }

        private record WallAndValve(PressureChamberWallBlockEntity wall, PressureChamberValveBlockEntity valve) {
        }
    }
}

