/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity.processing;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.pressure.PressureTier;
import me.desht.pneumaticcraft.common.block.UVLightBoxBlock;
import me.desht.pneumaticcraft.common.block.entity.AbstractAirHandlingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.block.entity.IRedstoneControl;
import me.desht.pneumaticcraft.common.block.entity.RedstoneController;
import me.desht.pneumaticcraft.common.inventory.UVLightBoxMenu;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.item.EmptyPCBItem;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;

public class UVLightBoxBlockEntity
extends AbstractAirHandlingBlockEntity
implements IMinWorkingPressure,
IRedstoneControl<UVLightBoxBlockEntity>,
MenuProvider {
    private static final String NBT_EXPOSURE = "pneumaticcraft:uv_exposure";
    public static final int INVENTORY_SIZE = 1;
    public static final int PCB_SLOT = 0;
    private static final List<RedstoneController.RedstoneMode<UVLightBoxBlockEntity>> REDSTONE_MODES = ImmutableList.of(new RedstoneController.ReceivingRedstoneMode<UVLightBoxBlockEntity>("standard.always", new ItemStack((ItemLike)Items.GUNPOWDER), te -> true), new RedstoneController.ReceivingRedstoneMode<UVLightBoxBlockEntity>("standard.high_signal", new ItemStack((ItemLike)Items.REDSTONE), te -> te.getCurrentRedstonePower() > 0), new RedstoneController.ReceivingRedstoneMode<UVLightBoxBlockEntity>("standard.low_signal", new ItemStack((ItemLike)Items.REDSTONE_TORCH), te -> te.getCurrentRedstonePower() == 0), new RedstoneController.ReceivingRedstoneMode<UVLightBoxBlockEntity>("uvLightBox.interpolate", new ItemStack((ItemLike)Items.COMPARATOR), te -> te.getCurrentRedstonePower() > 0));
    public static final int RS_MODE_INTERPOLATE = 3;
    private long lastStateUpdateTime = 0L;
    private BlockState pendingState;
    @GuiSynced
    public final RedstoneController<UVLightBoxBlockEntity> rsController = new RedstoneController<UVLightBoxBlockEntity>(this, REDSTONE_MODES);
    @GuiSynced
    public int threshold = 100;
    private final UVInputHandler inputHandler = new UVInputHandler();
    private final ItemStackHandler outputHandler = new BaseItemStackHandler(this, 1);
    private final UVInvWrapper inventoryExt = new UVInvWrapper();
    private BlockCapabilityCache<IItemHandler, Direction> ejectionCache;
    public int ticksExisted;

    public UVLightBoxBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntityTypes.UV_LIGHT_BOX.get(), pos, state, PressureTier.TIER_ONE, 2000, 4);
    }

    @Override
    public void tickServer() {
        super.tickServer();
        ++this.ticksExisted;
        ItemStack stack = this.getLoadedPCB();
        boolean didWork = false;
        if (this.rsController.getCurrentMode() == 3) {
            this.threshold = Math.min(100, 25 + this.rsController.getCurrentRedstonePower() * 5);
        }
        if (!stack.isEmpty() && this.rsController.shouldRun()) {
            int progress = UVLightBoxBlockEntity.getExposureProgress(stack);
            if (this.getPressure() >= 1.0f && progress < 100) {
                this.addAir((int)(-2.0f * this.getSpeedUsageMultiplierFromUpgrades()));
                if (this.ticksExisted % this.ticksPerProgress(progress) == 0) {
                    UVLightBoxBlockEntity.setExposureProgress(stack, ++progress);
                }
                if (progress >= this.threshold && this.outputHandler.insertItem(0, this.inputHandler.getStackInSlot(0), true).isEmpty()) {
                    ItemStack toMove = this.inputHandler.extractItem(0, 1, false);
                    this.outputHandler.insertItem(0, toMove, false);
                }
                didWork = true;
            }
        }
        if (this.getUpgrades(ModUpgrades.DISPENSER.get()) > 0) {
            this.tryEject();
        }
        this.checkStateUpdates(stack, didWork);
    }

    private void checkStateUpdates(ItemStack loadedStack, boolean didWork) {
        BlockState state = this.getBlockState();
        if (state.getBlock() == ModBlocks.UV_LIGHT_BOX.get()) {
            boolean loaded = (Boolean)state.getValue((Property)UVLightBoxBlock.LOADED);
            boolean updateNeeded = false;
            if (loaded == loadedStack.isEmpty()) {
                state = (BlockState)state.setValue((Property)UVLightBoxBlock.LOADED, (Comparable)Boolean.valueOf(!loadedStack.isEmpty()));
                updateNeeded = true;
            }
            if (didWork != (Boolean)this.getBlockState().getValue((Property)UVLightBoxBlock.LIT)) {
                state = (BlockState)state.setValue((Property)UVLightBoxBlock.LIT, (Comparable)Boolean.valueOf(didWork));
                updateNeeded = true;
            }
            long now = this.nonNullLevel().getGameTime();
            if (updateNeeded) {
                if (now - this.lastStateUpdateTime > 10L) {
                    this.updateBlockStateImmediate(state, now);
                } else {
                    this.pendingState = state;
                }
            } else if (this.pendingState != null && now - this.lastStateUpdateTime > 10L) {
                this.updateBlockStateImmediate(this.pendingState, now);
            }
        }
    }

    private void updateBlockStateImmediate(BlockState state, long now) {
        this.nonNullLevel().setBlockAndUpdate(this.worldPosition, state);
        this.pendingState = null;
        this.lastStateUpdateTime = now;
    }

    private void tryEject() {
        ItemStack stack;
        IItemHandler dstHandler;
        Direction dir = this.getUpgradeCache().getEjectDirection();
        if (dir != null && (dstHandler = (IItemHandler)this.getEjectionCache(dir).getCapability()) != null && !(stack = this.outputHandler.extractItem(0, 1, true)).isEmpty() && ItemHandlerHelper.insertItem((IItemHandler)dstHandler, (ItemStack)stack, (boolean)false).isEmpty()) {
            this.outputHandler.extractItem(0, 1, false);
        }
    }

    private BlockCapabilityCache<IItemHandler, Direction> getEjectionCache(@NotNull Direction dir) {
        if (this.ejectionCache == null || this.ejectionCache.context() != dir) {
            this.ejectionCache = this.createItemHandlerCache(dir);
        }
        return this.ejectionCache;
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        this.threshold = tag.getInt("threshold");
        this.inputHandler.deserializeNBT(tag.getCompound("Items"));
        this.outputHandler.deserializeNBT(tag.getCompound("Output"));
    }

    @Override
    public void saveAdditional(CompoundTag nbt) {
        super.saveAdditional(nbt);
        nbt.putInt("threshold", this.threshold);
        nbt.put("Items", (Tag)this.inputHandler.serializeNBT());
        nbt.put("Output", (Tag)this.outputHandler.serializeNBT());
    }

    public static int getExposureProgress(ItemStack stack) {
        return stack.hasTag() ? stack.getTag().getInt(NBT_EXPOSURE) : 0;
    }

    public static ItemStack setExposureProgress(ItemStack stack, int progress) {
        Validate.isTrue((progress >= 0 && progress <= 100 ? 1 : 0) != 0);
        stack.getOrCreateTag().putInt(NBT_EXPOSURE, progress);
        return stack;
    }

    private int ticksPerProgress(int progress) {
        int ticks = progress < 20 ? 20 : (progress < 40 ? 40 : (progress < 60 ? 80 : (progress < 80 ? 160 : 300)));
        return Math.max(1, (int)((float)ticks / this.getSpeedMultiplierFromUpgrades()));
    }

    @Override
    protected boolean shouldRerenderChunkOnDescUpdate() {
        return true;
    }

    @Override
    public void onDescUpdate() {
        this.nonNullLevel().getChunkSource().getLightEngine().checkBlock(this.getBlockPos());
        super.onDescUpdate();
    }

    @Override
    public boolean canConnectPneumatic(Direction side) {
        return side == this.getRotation();
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
        if (this.rsController.parseRedstoneMode(tag)) {
            return;
        }
        try {
            this.threshold = Mth.clamp((int)Integer.parseInt(tag), (int)1, (int)100);
            this.setChanged();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    public IItemHandler getItemHandler(@Nullable Direction dir) {
        return this.inventoryExt;
    }

    public IItemHandler getInputHandler() {
        return this.inputHandler;
    }

    public IItemHandler getOutputHandler() {
        return this.outputHandler;
    }

    @Override
    public RedstoneController<UVLightBoxBlockEntity> getRedstoneController() {
        return this.rsController;
    }

    @Override
    public float getMinWorkingPressure() {
        return 1.0f;
    }

    private ItemStack getLoadedPCB() {
        return this.inputHandler.getStackInSlot(0);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player playerEntity) {
        return new UVLightBoxMenu(i, playerInventory, this.getBlockPos());
    }

    public int getThreshold() {
        return this.threshold;
    }

    private class UVInputHandler
    extends BaseItemStackHandler {
        UVInputHandler() {
            super(UVLightBoxBlockEntity.this, 1);
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        public boolean isItemValid(int slot, ItemStack itemStack) {
            return itemStack.isEmpty() || itemStack.getItem() instanceof EmptyPCBItem && EmptyPCBItem.getEtchProgress(itemStack) == 0;
        }
    }

    private class UVInvWrapper
    implements IItemHandler {
        UVInvWrapper() {
        }

        public int getSlots() {
            return 2;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return slot == 0 ? UVLightBoxBlockEntity.this.inputHandler.getStackInSlot(0) : UVLightBoxBlockEntity.this.outputHandler.getStackInSlot(0);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return slot == 0 ? UVLightBoxBlockEntity.this.inputHandler.insertItem(0, stack, simulate) : stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return slot == 1 ? UVLightBoxBlockEntity.this.outputHandler.extractItem(0, amount, simulate) : ItemStack.EMPTY;
        }

        public int getSlotLimit(int slot) {
            return slot == 0 ? UVLightBoxBlockEntity.this.inputHandler.getSlotLimit(0) : UVLightBoxBlockEntity.this.outputHandler.getSlotLimit(0);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return slot == 0 ? UVLightBoxBlockEntity.this.inputHandler.isItemValid(0, stack) : UVLightBoxBlockEntity.this.outputHandler.isItemValid(0, stack);
        }
    }
}

