/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity.spawning;

import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.item.ISpawnerCoreStats;
import me.desht.pneumaticcraft.api.pressure.PressureTier;
import me.desht.pneumaticcraft.common.block.entity.AbstractAirHandlingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.block.entity.IRangedTE;
import me.desht.pneumaticcraft.common.block.entity.IRedstoneControl;
import me.desht.pneumaticcraft.common.block.entity.RangeManager;
import me.desht.pneumaticcraft.common.block.entity.RedstoneController;
import me.desht.pneumaticcraft.common.block.entity.spawning.VacuumTrapBlockEntity;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.inventory.PressurizedSpawnerMenu;
import me.desht.pneumaticcraft.common.item.SpawnerCoreItem;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.items.IItemHandler;

public class PressurizedSpawnerBlockEntity
extends AbstractAirHandlingBlockEntity
implements IMinWorkingPressure,
IRedstoneControl<PressurizedSpawnerBlockEntity>,
MenuProvider,
IRangedTE {
    public static final int BASE_SPAWN_INTERVAL = 200;
    private static final int MAX_NEARBY_ENTITIES = 32;
    private final SpawnerCoreItem.SpawnerCoreItemHandler inventory = new SpawnerCoreItem.SpawnerCoreItemHandler(this);
    @GuiSynced
    public VacuumTrapBlockEntity.Problems problem = VacuumTrapBlockEntity.Problems.OK;
    @GuiSynced
    private final RedstoneController<PressurizedSpawnerBlockEntity> rsController = new RedstoneController<PressurizedSpawnerBlockEntity>(this);
    private int counter = -1;
    @DescSynced
    private boolean running;
    private final RangeManager rangeManager = new RangeManager(this, 0x60400040).withCustomExtents(this::buildCustomExtents);

    public PressurizedSpawnerBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntityTypes.PRESSURIZED_SPAWNER.get(), pos, state, PressureTier.TIER_TWO, 5000, 4);
    }

    @Override
    public void tickCommonPre() {
        super.tickCommonPre();
        this.rangeManager.setRange(2 + this.getUpgrades(ModUpgrades.RANGE.get()));
        if (this.counter < 0) {
            this.counter = this.getSpawnInterval();
        }
    }

    @Override
    public void tickClient() {
        super.tickClient();
        if (this.running) {
            Level level = this.nonNullLevel();
            double x = (double)this.worldPosition.getX() + level.random.nextDouble();
            double y = (double)this.worldPosition.getY() + level.random.nextDouble();
            double z = (double)this.worldPosition.getZ() + level.random.nextDouble();
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, x, y, z, 0.0, 0.0, 0.0);
            level.addParticle((ParticleOptions)ParticleTypes.FLAME, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void tickServer() {
        super.tickServer();
        ISpawnerCoreStats stats = this.inventory.getStats();
        this.running = false;
        this.problem = VacuumTrapBlockEntity.Problems.OK;
        if (stats == null) {
            this.problem = VacuumTrapBlockEntity.Problems.NO_CORE;
        } else if (this.getPressure() > this.getMinWorkingPressure() && this.rsController.shouldRun()) {
            this.running = true;
            if (--this.counter <= 0) {
                Level level;
                if (!this.trySpawnSomething(stats) && (level = this.level) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.POOF, (double)this.worldPosition.getX() + 0.5, (double)(this.worldPosition.getY() + 1), (double)this.worldPosition.getZ() + 0.5, 5, 0.0, 0.0, 0.0, 0.0);
                }
                this.addAir(-this.getAirUsage());
                this.counter = this.getSpawnInterval();
            }
        }
    }

    private BoundingBox buildCustomExtents() {
        BoundingBox box = new BoundingBox(this.getBlockPos()).inflatedBy(this.getRange());
        return new BoundingBox(box.minX(), box.minY() - 1, box.minZ(), box.maxX(), box.maxY() + 2, box.maxZ());
    }

    private boolean trySpawnSomething(ISpawnerCoreStats stats) {
        Level level;
        EntityType<?> type = stats.pickEntity(true);
        if (type != null && (level = this.level) instanceof ServerLevel) {
            double z;
            double y;
            ServerLevel serverworld = (ServerLevel)level;
            int spawnRange = this.getRange();
            double x = (double)this.worldPosition.getX() + (serverworld.random.nextDouble() - this.level.random.nextDouble()) * (double)spawnRange + 0.5;
            if (serverworld.noCollision(type.getAABB(x, y = (double)(this.worldPosition.getY() + serverworld.random.nextInt(3) - 1), z = (double)this.worldPosition.getZ() + (serverworld.random.nextDouble() - this.level.random.nextDouble()) * (double)spawnRange + 0.5))) {
                Entity entity = type.create((Level)serverworld);
                if (!(entity instanceof Mob)) {
                    return false;
                }
                Mob mobentity = (Mob)entity;
                int entityCount = serverworld.getEntitiesOfClass(Mob.class, this.rangeManager.getExtentsAsAABB()).size();
                if (entityCount >= 32) {
                    return false;
                }
                entity.moveTo(x, y, z, this.level.random.nextFloat() * 360.0f, 0.0f);
                EventHooks.onFinalizeSpawn((Mob)mobentity, (ServerLevelAccessor)serverworld, (DifficultyInstance)serverworld.getCurrentDifficultyAt(this.getPosition()), (MobSpawnType)MobSpawnType.SPAWNER, null, null);
                if (!serverworld.tryAddFreshEntityWithPassengers(entity)) {
                    return false;
                }
                this.level.levelEvent(2004, this.worldPosition, 0);
                mobentity.spawnAnim();
                mobentity.setPersistenceRequired();
                mobentity.getPersistentData().putBoolean("pneumaticcraft:pressurized_spawner", true);
                return true;
            }
        }
        return false;
    }

    public int getSpawnInterval() {
        return (int)(200.0f / this.getSpeedMultiplierFromUpgrades());
    }

    public int getAirUsage() {
        return 150 * (this.getUpgrades(ModUpgrades.SPEED.get()) + 1);
    }

    @Override
    public IItemHandler getItemHandler(@Nullable Direction dir) {
        return this.inventory;
    }

    @Override
    public float getMinWorkingPressure() {
        return ((Double)ConfigHelper.common().machines.pressurizedSpawnerMinPressure.get()).floatValue();
    }

    @Override
    public RedstoneController<PressurizedSpawnerBlockEntity> getRedstoneController() {
        return this.rsController;
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
        this.rsController.parseRedstoneMode(tag);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowId, Inventory inv, Player player) {
        return new PressurizedSpawnerMenu(windowId, inv, this.getBlockPos());
    }

    @Override
    public void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        tag.put("Inventory", (Tag)this.inventory.serializeNBT());
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        this.inventory.deserializeNBT(tag.getCompound("Inventory"));
    }

    public AABB getRenderBoundingBox() {
        return this.rangeManager.shouldShowRange() ? this.rangeManager.getExtentsAsAABB() : new AABB(this.getBlockPos());
    }

    @Override
    public RangeManager getRangeManager() {
        return this.rangeManager;
    }
}

