/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity.spawning;

import java.util.List;
import me.desht.pneumaticcraft.api.pressure.PressureTier;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import me.desht.pneumaticcraft.api.tileentity.IManoMeasurable;
import me.desht.pneumaticcraft.common.block.entity.AbstractAirHandlingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IRedstoneControl;
import me.desht.pneumaticcraft.common.block.entity.RedstoneController;
import me.desht.pneumaticcraft.common.capabilities.MachineAirHandler;
import me.desht.pneumaticcraft.common.inventory.VacuumPumpMenu;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class VacuumPumpBlockEntity
extends AbstractAirHandlingBlockEntity
implements IRedstoneControl<VacuumPumpBlockEntity>,
IManoMeasurable,
MenuProvider {
    @GuiSynced
    private final IAirHandlerMachine vacuumHandler;
    public int rotation;
    public int oldRotation;
    private int turnTimer = -1;
    @DescSynced
    public boolean turning = false;
    private int rotationSpeed;
    @GuiSynced
    public final RedstoneController<VacuumPumpBlockEntity> rsController = new RedstoneController<VacuumPumpBlockEntity>(this);

    public VacuumPumpBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntityTypes.VACUUM_PUMP.get(), pos, state, PressureTier.TIER_ONE, 2000, 4);
        this.vacuumHandler = new MachineAirHandler(PressureTier.TIER_ONE, 2000);
    }

    @Override
    public IAirHandlerMachine getAirHandler(Direction side) {
        if (side == this.getVacuumSide()) {
            return this.vacuumHandler;
        }
        if (side == this.getInputSide() || side == null) {
            return super.getAirHandler(side);
        }
        return null;
    }

    @Override
    public boolean canConnectPneumatic(Direction side) {
        return side == this.getInputSide() || side == this.getVacuumSide();
    }

    @Override
    public IItemHandler getItemHandler(@Nullable Direction dir) {
        return null;
    }

    public Direction getInputSide() {
        return this.getVacuumSide().getOpposite();
    }

    public Direction getVacuumSide() {
        return this.getRotation();
    }

    @Override
    public void tickClient() {
        super.tickClient();
        this.oldRotation = this.rotation;
        this.rotationSpeed = this.turning ? Math.min(this.rotationSpeed + 1, 20) : Math.max(this.rotationSpeed - 1, 0);
        this.rotation += this.rotationSpeed;
    }

    @Override
    public void tickServer() {
        super.tickServer();
        if (this.turnTimer >= 0) {
            --this.turnTimer;
        }
        if (this.airHandler.getPressure() > 2.0f && this.vacuumHandler.getPressure() > -0.99f && this.rsController.shouldRun()) {
            if (this.turnTimer == -1) {
                this.turning = true;
            }
            this.airHandler.addAir((int)(-10.0f * this.getSpeedUsageMultiplierFromUpgrades()));
            this.vacuumHandler.addAir((int)(-4.0f * this.getSpeedMultiplierFromUpgrades()));
            this.turnTimer = 40;
        }
        if (this.turnTimer == 0) {
            this.turning = false;
        }
        this.airHandler.setSideLeaking(this.airHandler.getConnectedAirHandlers(this).isEmpty() ? this.getInputSide() : null);
        this.vacuumHandler.setSideLeaking(this.vacuumHandler.getConnectedAirHandlers(this).isEmpty() ? this.getVacuumSide() : null);
    }

    @Override
    public void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        tag.put("vacuum", this.vacuumHandler.serializeNBT());
        tag.putBoolean("turning", this.turning);
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        this.vacuumHandler.deserializeNBT((Tag)tag.getCompound("vacuum"));
        this.turning = tag.getBoolean("turning");
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
        this.rsController.parseRedstoneMode(tag);
    }

    @Override
    public void printManometerMessage(Player player, List<Component> curInfo) {
        String input = PneumaticCraftUtils.roundNumberTo(this.airHandler.getPressure(), 1);
        String vac = PneumaticCraftUtils.roundNumberTo(this.vacuumHandler.getPressure(), 1);
        curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.message.vacuum_pump.manometer", input, vac).withStyle(ChatFormatting.GREEN));
    }

    @Override
    public RedstoneController<VacuumPumpBlockEntity> getRedstoneController() {
        return this.rsController;
    }

    @javax.annotation.Nullable
    public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player playerEntity) {
        return new VacuumPumpMenu(i, playerInventory, this.getBlockPos());
    }
}

