/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity.utility;

import java.util.Arrays;
import java.util.BitSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.block.AphorismTileBlock;
import me.desht.pneumaticcraft.common.block.entity.AbstractPneumaticCraftBlockEntity;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.tuple.Pair;

public class AphorismTileBlockEntity
extends AbstractPneumaticCraftBlockEntity {
    public static final String NBT_BORDER_COLOR = "borderColor";
    public static final String NBT_BACKGROUND_COLOR = "backgroundColor";
    private static final String NBT_TEXT_ROTATION = "textRot";
    public static final String NBT_TEXT_LINES = "lines";
    public static final String NBT_MARGIN = "margin";
    private static final String NBT_INVISIBLE = "invisible";
    private static final Pattern ITEM_PAT = Pattern.compile("^\\{item:(\\w+:[a-z0-9_.]+)}$");
    private String[] textLines = new String[]{""};
    private ItemStack[] icons = new ItemStack[]{ItemStack.EMPTY};
    private BitSet rsLines = new BitSet(1);
    private int textRotation;
    private int borderColor = DyeColor.BLUE.getId();
    private int backgroundColor = DyeColor.WHITE.getId();
    private int maxLineWidth = -1;
    private byte marginSize;
    private boolean invisible;
    public int currentRedstonePower = 0;
    private long lastPoll = 0L;
    public int cursorX = -1;
    public int cursorY = -1;

    public AphorismTileBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntityTypes.APHORISM_TILE.get(), pos, state);
    }

    @Override
    public boolean hasItemCapability() {
        return false;
    }

    @Override
    public boolean shouldPreserveStateOnBreak() {
        return true;
    }

    @Override
    public void serializeExtraItemData(CompoundTag blockEntityTag, boolean preserveState) {
        this.writeToPacket(blockEntityTag);
    }

    @Override
    public void writeToPacket(CompoundTag tag) {
        super.writeToPacket(tag);
        CompoundTag subTag = new CompoundTag();
        subTag.put(NBT_TEXT_LINES, (Tag)Arrays.stream(this.textLines).map(StringTag::valueOf).collect(Collectors.toCollection(ListTag::new)));
        subTag.putInt(NBT_TEXT_ROTATION, this.textRotation);
        subTag.putInt(NBT_BORDER_COLOR, this.borderColor);
        subTag.putInt(NBT_BACKGROUND_COLOR, this.backgroundColor);
        subTag.putByte(NBT_MARGIN, this.marginSize);
        subTag.putBoolean(NBT_INVISIBLE, this.invisible);
        tag.put("ExtraData", (Tag)subTag);
    }

    @Override
    public void readFromPacket(CompoundTag tag) {
        super.readFromPacket(tag);
        if (tag.contains("ExtraData")) {
            CompoundTag subTag = tag.getCompound("ExtraData");
            ListTag l = subTag.getList(NBT_TEXT_LINES, 8);
            if (l.isEmpty()) {
                this.textLines = new String[]{""};
            } else {
                this.textLines = new String[l.size()];
                IntStream.range(0, this.textLines.length).forEach(i -> {
                    this.textLines[i] = l.getString(i);
                });
            }
            this.updateLineMetadata();
            this.textRotation = subTag.getInt(NBT_TEXT_ROTATION);
            if (subTag.contains(NBT_BORDER_COLOR)) {
                this.borderColor = subTag.getInt(NBT_BORDER_COLOR);
                this.backgroundColor = subTag.getInt(NBT_BACKGROUND_COLOR);
            } else {
                this.borderColor = DyeColor.BLUE.getId();
                this.backgroundColor = DyeColor.WHITE.getId();
            }
            this.setMarginSize(subTag.getByte(NBT_MARGIN));
            this.setInvisible(subTag.getBoolean(NBT_INVISIBLE));
            if (this.level != null) {
                this.forceBlockEntityRerender();
            }
        }
    }

    public String[] getTextLines() {
        return this.textLines;
    }

    public void setTextLines(String[] textLines) {
        this.setTextLines(textLines, true);
    }

    public int getTextRotation() {
        return this.textRotation;
    }

    public void setTextRotation(int textRotation) {
        this.textRotation = textRotation;
    }

    public void setTextLines(String[] textLines, boolean notifyClient) {
        this.textLines = textLines;
        this.maxLineWidth = -1;
        this.icons = new ItemStack[textLines.length];
        if (this.nonNullLevel().isClientSide) {
            this.updateLineMetadata();
        } else if (notifyClient) {
            this.sendDescriptionPacket();
        }
    }

    private void updateLineMetadata() {
        this.icons = new ItemStack[this.textLines.length];
        this.rsLines = new BitSet(this.textLines.length);
        for (int i = 0; i < this.textLines.length; ++i) {
            Matcher m = ITEM_PAT.matcher(this.textLines[i]);
            if (m.matches()) {
                this.icons[i] = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(new ResourceLocation(m.group(1))));
                continue;
            }
            this.icons[i] = ItemStack.EMPTY;
            if (!this.textLines[i].contains("{redstone}")) continue;
            this.rsLines.set(i);
        }
    }

    public ItemStack getIconAt(int line) {
        return line >= 0 && line < this.icons.length ? this.icons[line] : ItemStack.EMPTY;
    }

    public boolean isRedstoneLine(int line) {
        return line >= 0 && line < this.rsLines.size() && this.rsLines.get(line);
    }

    public void setBorderColor(int color) {
        this.borderColor = color;
        if (!this.nonNullLevel().isClientSide) {
            this.sendDescriptionPacket();
        }
    }

    public int getBorderColor() {
        return this.borderColor;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(int color) {
        this.backgroundColor = color;
        if (!this.nonNullLevel().isClientSide) {
            this.sendDescriptionPacket();
        }
    }

    public byte getMarginSize() {
        return this.marginSize;
    }

    public void setMarginSize(int marginSize) {
        this.marginSize = (byte)Mth.clamp((int)marginSize, (int)0, (int)9);
        this.needMaxLineWidthRecalc();
    }

    public boolean isInvisible() {
        return this.invisible;
    }

    public void setInvisible(boolean invisible) {
        BlockState state;
        this.invisible = invisible;
        if (this.level != null && (state = this.getBlockState()).getBlock() instanceof AphorismTileBlock) {
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)AphorismTileBlock.INVISIBLE, (Comparable)Boolean.valueOf(invisible)));
        }
    }

    public int getMaxLineWidth(boolean editing) {
        if (this.maxLineWidth < 0) {
            for (int i = 0; i < this.textLines.length; ++i) {
                int stringWidth;
                String line = this.textLines[i];
                if (!editing && this.isRedstoneLine(i)) {
                    line = line.replaceAll(Pattern.quote("{redstone}"), Integer.toString(this.currentRedstonePower));
                }
                int n = stringWidth = !editing && !this.getIconAt(i).isEmpty() ? 6 : ClientUtils.getStringWidth(line);
                if (stringWidth <= this.maxLineWidth) continue;
                this.maxLineWidth = stringWidth;
            }
            float mul = 1.0f + (float)(this.marginSize + 1) * 0.075f;
            this.maxLineWidth = (int)((float)this.maxLineWidth * mul);
        }
        return this.maxLineWidth;
    }

    public void needMaxLineWidthRecalc() {
        this.maxLineWidth = -1;
    }

    public int pollRedstone() {
        Level level = this.nonNullLevel();
        if (level.getGameTime() - this.lastPoll >= 2L) {
            Direction d = this.getRotation();
            int p = this.nonNullLevel().getSignal(this.worldPosition.relative(d), d);
            if (p != this.currentRedstonePower) {
                this.needMaxLineWidthRecalc();
            }
            this.currentRedstonePower = p;
            this.lastPoll = this.nonNullLevel().getGameTime();
        }
        return this.currentRedstonePower;
    }

    public Pair<Integer, Integer> getCursorPos() {
        int cy = this.cursorY >= 0 && this.cursorY < this.textLines.length ? this.cursorY : this.textLines.length - 1;
        int cx = this.cursorX >= 0 && this.cursorX <= this.textLines[cy].length() ? this.cursorX : this.textLines[cy].length();
        return Pair.of((Object)cx, (Object)cy);
    }

    public void setCursorPos(int cursorX, int cursorY) {
        this.cursorX = cursorX;
        this.cursorY = cursorY;
    }
}

