/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity.utility;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.pressure.PressureTier;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.common.block.ChargingStationBlock;
import me.desht.pneumaticcraft.common.block.entity.AbstractAirHandlingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.CamouflageableBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IRedstoneControl;
import me.desht.pneumaticcraft.common.block.entity.RedstoneController;
import me.desht.pneumaticcraft.common.inventory.ChargingStationMenu;
import me.desht.pneumaticcraft.common.inventory.ChargingStationUpgradeManagerMenu;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.inventory.handler.ChargeableItemHandler;
import me.desht.pneumaticcraft.common.item.IChargeableContainerProvider;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.util.GlobalBlockEntityCacheManager;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.items.IItemHandler;

public class ChargingStationBlockEntity
extends AbstractAirHandlingBlockEntity
implements IRedstoneControl<ChargingStationBlockEntity>,
CamouflageableBlockEntity,
MenuProvider {
    private static final List<RedstoneController.RedstoneMode<ChargingStationBlockEntity>> REDSTONE_MODES = ImmutableList.of(new RedstoneController.EmittingRedstoneMode<ChargingStationBlockEntity>("standard.never", new ItemStack((ItemLike)Items.GUNPOWDER), te -> false), new RedstoneController.EmittingRedstoneMode<ChargingStationBlockEntity>("chargingStation.idle", Textures.GUI_CHARGE_IDLE, ChargingStationBlockEntity::isIdle), new RedstoneController.EmittingRedstoneMode<ChargingStationBlockEntity>("chargingStation.charging", Textures.GUI_CHARGING, te -> te.charging), new RedstoneController.EmittingRedstoneMode<ChargingStationBlockEntity>("chargingStation.discharging", Textures.GUI_DISCHARGING, te -> te.discharging));
    private static final int INVENTORY_SIZE = 1;
    public static final int CHARGE_INVENTORY_INDEX = 0;
    private static final int MAX_REDSTONE_UPDATE_FREQ = 10;
    @DescSynced
    private ItemStack chargingStackSynced = ItemStack.EMPTY;
    private ChargingStationHandler itemHandler = new ChargingStationHandler();
    private ChargeableItemHandler chargeableInventory;
    @GuiSynced
    public float chargingItemPressure;
    @GuiSynced
    public boolean charging;
    @GuiSynced
    public boolean discharging;
    private boolean oldRedstoneStatus;
    private BlockState camoState;
    private long lastRedstoneUpdate;
    private int pendingRedstoneStatus = -1;
    @GuiSynced
    private final RedstoneController<ChargingStationBlockEntity> rsController = new RedstoneController<ChargingStationBlockEntity>(this, REDSTONE_MODES);
    @GuiSynced
    public boolean upgradeOnly = false;

    public ChargingStationBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntityTypes.CHARGING_STATION.get(), pos, state, PressureTier.TIER_TWO, 1000, 4);
    }

    @Nonnull
    public ItemStack getChargingStack() {
        return this.itemHandler.getStackInSlot(0);
    }

    @Nonnull
    public ItemStack getChargingStackSynced() {
        return this.chargingStackSynced;
    }

    @Override
    public void tickServer() {
        super.tickServer();
        this.discharging = false;
        this.charging = false;
        this.chargingStackSynced = this.itemHandler.getStackInSlot(0);
        int airToTransfer = (int)(10.0f * this.getSpeedMultiplierFromUpgrades());
        for (IAirHandler itemAirHandler : this.findChargeable()) {
            float itemPressure = itemAirHandler.getPressure();
            float itemVolume = itemAirHandler.getVolume();
            float chargerPressure = this.getPressure();
            float delta = Math.abs(chargerPressure - itemPressure) / 2.0f;
            int airInItem = itemAirHandler.getAir();
            if (PneumaticCraftUtils.epsilonEquals(chargerPressure, 0.0f) && delta < 0.1f) {
                itemAirHandler.addAir(-airInItem);
                continue;
            }
            if (itemPressure > chargerPressure + 0.01f && itemPressure > 0.0f) {
                int airToMove = Math.min(Math.min(airToTransfer, airInItem), (int)(delta * (float)this.airHandler.getVolume()));
                itemAirHandler.addAir(-airToMove);
                this.addAir(airToMove);
                this.discharging = true;
                continue;
            }
            if (!(itemPressure < chargerPressure - 0.01f) || !(itemPressure < itemAirHandler.maxPressure())) continue;
            int maxAirInItem = (int)(itemAirHandler.maxPressure() * itemVolume);
            float boost = chargerPressure < 15.0f ? 1.0f : 1.0f + (chargerPressure - 15.0f) / 5.0f;
            int airToMove = Math.min(Math.min((int)((float)airToTransfer * boost), this.airHandler.getAir()), maxAirInItem - airInItem);
            airToMove = Math.min((int)(delta * itemVolume), airToMove);
            itemAirHandler.addAir(airToMove);
            this.addAir(-airToMove);
            this.charging = true;
        }
        boolean shouldEmit = this.rsController.shouldEmit();
        if (this.oldRedstoneStatus != shouldEmit) {
            if (this.nonNullLevel().getGameTime() - this.lastRedstoneUpdate > 10L) {
                this.updateRedstoneOutput();
            } else {
                this.pendingRedstoneStatus = shouldEmit ? 1 : 0;
            }
        } else if (this.pendingRedstoneStatus != -1 && this.nonNullLevel().getGameTime() - this.lastRedstoneUpdate > 10L) {
            this.updateRedstoneOutput();
        }
        this.airHandler.setSideLeaking(!this.upgradeOnly && this.hasNoConnectedAirHandlers() ? this.getRotation() : null);
    }

    private void updateRedstoneOutput() {
        this.oldRedstoneStatus = this.rsController.shouldEmit();
        this.updateNeighbours();
        this.pendingRedstoneStatus = -1;
        this.lastRedstoneUpdate = this.nonNullLevel().getGameTime();
    }

    private List<IAirHandler> findChargeable() {
        if (this.upgradeOnly) {
            return Collections.emptyList();
        }
        ArrayList<IAirHandler> res = new ArrayList<IAirHandler>();
        if (this.getChargingStack().getCount() == 1) {
            PNCCapabilities.getAirHandler(this.getChargingStack()).ifPresent(h -> {
                res.add((IAirHandler)h);
                this.chargingItemPressure = h.getPressure();
            });
        }
        if (this.getUpgrades(ModUpgrades.DISPENSER.get()) > 0) {
            List entitiesOnPad = this.nonNullLevel().getEntitiesOfClass(Entity.class, new AABB(this.getBlockPos().above()));
            for (Entity entity : entitiesOnPad) {
                if (entity instanceof ItemEntity) {
                    ItemEntity ie = (ItemEntity)entity;
                    PNCCapabilities.getAirHandler(ie.getItem()).ifPresent(res::add);
                    continue;
                }
                if (entity instanceof Player) {
                    Player p = (Player)entity;
                    Inventory inv = p.getInventory();
                    for (int i = 0; i < inv.getContainerSize(); ++i) {
                        ItemStack stack = inv.getItem(i);
                        if (stack.getCount() != 1) continue;
                        PNCCapabilities.getAirHandler(stack).ifPresent(res::add);
                    }
                    continue;
                }
                PNCCapabilities.getAirHandler(entity).ifPresent(res::add);
            }
        }
        return res;
    }

    @Override
    public boolean canConnectPneumatic(Direction side) {
        return this.getRotation() == side || side == Direction.DOWN;
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
        if (this.rsController.parseRedstoneMode(tag)) {
            return;
        }
        switch (tag) {
            case "open_upgrades": {
                if (!(this.getChargingStack().getItem() instanceof IChargeableContainerProvider)) break;
                MenuProvider provider = ((IChargeableContainerProvider)this.getChargingStack().getItem()).getContainerProvider(this);
                player.openMenu(provider, this.getBlockPos());
                break;
            }
            case "close_upgrades": {
                player.openMenu((MenuProvider)this, this.getBlockPos());
                break;
            }
            case "toggle_upgrade_only": {
                this.upgradeOnly = !this.upgradeOnly;
            }
        }
    }

    @Override
    public IItemHandler getItemHandler(@Nullable Direction dir) {
        return this.itemHandler;
    }

    private boolean isIdle() {
        return !this.charging && !this.discharging && !this.getChargingStack().isEmpty() && PNCCapabilities.getAirHandler(this.getChargingStack()).isPresent();
    }

    public ChargeableItemHandler getChargeableInventory() {
        return this.nonNullLevel().isClientSide ? new ChargeableItemHandler(this) : this.chargeableInventory;
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        this.itemHandler = new ChargingStationHandler();
        this.itemHandler.deserializeNBT(tag.getCompound("Items"));
        ItemStack chargeSlot = this.getChargingStack();
        if (chargeSlot.getItem() instanceof IChargeableContainerProvider) {
            this.chargeableInventory = new ChargeableItemHandler(this);
        }
        this.upgradeOnly = tag.getBoolean("UpgradeOnly");
    }

    @Override
    public void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        if (this.chargeableInventory != null) {
            this.chargeableInventory.writeToNBT();
        }
        tag.put("Items", (Tag)this.itemHandler.serializeNBT());
        if (this.upgradeOnly) {
            tag.putBoolean("UpgradeOnly", true);
        }
    }

    @Override
    public void serializeExtraItemData(CompoundTag blockEntityTag, boolean preserveState) {
        if (this.upgradeOnly) {
            blockEntityTag.putBoolean("UpgradeOnly", true);
        }
    }

    @Override
    public void writeToPacket(CompoundTag tag) {
        super.writeToPacket(tag);
        CamouflageableBlockEntity.writeCamo(tag, this.camoState);
    }

    @Override
    public void readFromPacket(CompoundTag tag) {
        super.readFromPacket(tag);
        this.camoState = CamouflageableBlockEntity.readCamo(tag);
    }

    @Override
    public void onUpgradesChanged() {
        super.onUpgradesChanged();
        if (this.level != null && !this.level.isClientSide) {
            BlockState state = this.level.getBlockState(this.worldPosition);
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)state.setValue((Property)ChargingStationBlock.CHARGE_PAD, (Comparable)Boolean.valueOf(this.getUpgrades(ModUpgrades.DISPENSER.get()) > 0)));
        }
    }

    @Override
    public RedstoneController<ChargingStationBlockEntity> getRedstoneController() {
        return this.rsController;
    }

    @Override
    protected boolean shouldRerenderChunkOnDescUpdate() {
        return true;
    }

    @Override
    public BlockState getCamouflage() {
        return this.camoState;
    }

    @Override
    public void setCamouflage(BlockState state) {
        this.camoState = state;
        CamouflageableBlockEntity.syncToClient(this);
    }

    public void setRemoved() {
        super.setRemoved();
        GlobalBlockEntityCacheManager.getInstance((LevelAccessor)this.getLevel()).getChargingStations().remove(this);
    }

    public void clearRemoved() {
        super.clearRemoved();
        GlobalBlockEntityCacheManager.getInstance((LevelAccessor)this.getLevel()).getChargingStations().add(this);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player playerEntity) {
        return new ChargingStationMenu(i, playerInventory, this.getBlockPos());
    }

    private class ChargingStationHandler
    extends BaseItemStackHandler {
        ChargingStationHandler() {
            super(ChargingStationBlockEntity.this, 1);
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        public boolean isItemValid(int slot, ItemStack itemStack) {
            return slot == 0 && (itemStack.isEmpty() || PNCCapabilities.getAirHandler(itemStack).isPresent());
        }

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            ChargingStationBlockEntity teCS = ChargingStationBlockEntity.this;
            ItemStack newStack = this.getStackInSlot(slot);
            if (!ItemStack.isSameItem((ItemStack)ChargingStationBlockEntity.this.chargingStackSynced, (ItemStack)newStack)) {
                ChargingStationBlockEntity.this.chargingStackSynced = new ItemStack((ItemLike)newStack.getItem());
            }
            if (teCS.nonNullLevel().isClientSide || slot != 0) {
                return;
            }
            teCS.chargeableInventory = newStack.getItem() instanceof IChargeableContainerProvider ? new ChargeableItemHandler(teCS) : null;
            for (Player player : teCS.nonNullLevel().players()) {
                if (!(player instanceof ServerPlayer)) continue;
                ServerPlayer sp = (ServerPlayer)player;
                AbstractContainerMenu abstractContainerMenu = player.containerMenu;
                if (!(abstractContainerMenu instanceof ChargingStationUpgradeManagerMenu)) continue;
                ChargingStationUpgradeManagerMenu manager = (ChargingStationUpgradeManagerMenu)abstractContainerMenu;
                if (manager.blockEntity != this.te) continue;
                sp.openMenu((MenuProvider)ChargingStationBlockEntity.this, ChargingStationBlockEntity.this.getBlockPos());
            }
        }
    }
}

