/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity.utility;

import me.desht.pneumaticcraft.common.block.entity.AbstractPneumaticCraftBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IComparatorSupport;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class DisplayTableBlockEntity
extends AbstractPneumaticCraftBlockEntity
implements IComparatorSupport {
    private final DisplayItemHandler inventory = new DisplayItemHandler(this, 1);
    public ItemStack displayedStack = ItemStack.EMPTY;

    public DisplayTableBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntityTypes.DISPLAY_TABLE.get(), pos, state);
    }

    DisplayTableBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public IItemHandler getItemHandler(@Nullable Direction dir) {
        return this.inventory;
    }

    @Override
    public void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        tag.put("Items", (Tag)this.inventory.serializeNBT());
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        this.inventory.deserializeNBT(tag.getCompound("Items"));
        this.displayedStack = this.inventory.getStackInSlot(0);
    }

    @Override
    public void writeToPacket(CompoundTag tag) {
        super.writeToPacket(tag);
        tag.put("Item", (Tag)this.displayedStack.save(new CompoundTag()));
    }

    @Override
    public void readFromPacket(CompoundTag tag) {
        super.readFromPacket(tag);
        this.displayedStack = ItemStack.of((CompoundTag)tag.getCompound("Item"));
    }

    @Override
    public int getComparatorValue() {
        return this.inventory.getStackInSlot(0).isEmpty() ? 0 : 15;
    }

    class DisplayItemHandler
    extends BaseItemStackHandler {
        DisplayItemHandler(DisplayTableBlockEntity te, int size) {
            super(te, size);
        }

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (slot == 0) {
                DisplayTableBlockEntity.this.displayedStack = this.getStackInSlot(0);
                if (!DisplayTableBlockEntity.this.nonNullLevel().isClientSide) {
                    DisplayTableBlockEntity.this.sendDescriptionPacket();
                }
            }
        }

        public int getSlotLimit(int slot) {
            return 1;
        }
    }
}

