/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity.utility;

import me.desht.pneumaticcraft.common.block.PneumaticDoorBlock;
import me.desht.pneumaticcraft.common.block.entity.AbstractTickingBlockEntity;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.LazySynced;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class PneumaticDoorBlockEntity
extends AbstractTickingBlockEntity {
    @DescSynced
    @LazySynced
    public float rotationAngle;
    public float oldRotationAngle;
    @DescSynced
    public boolean rightGoing;
    @DescSynced
    public int color = DyeColor.WHITE.getId();

    public PneumaticDoorBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntityTypes.PNEUMATIC_DOOR.get(), pos, state);
    }

    @Override
    public boolean hasItemCapability() {
        return false;
    }

    public void setRotationAngle(float rotationAngle) {
        if (this.oldRotationAngle == rotationAngle) {
            return;
        }
        this.oldRotationAngle = this.rotationAngle;
        this.rotationAngle = rotationAngle;
        if (this.oldRotationAngle < 90.0f && rotationAngle == 90.0f) {
            this.nonNullLevel().setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)DoorBlock.OPEN, (Comparable)Boolean.valueOf(true)));
        } else if (this.oldRotationAngle == 90.0f && rotationAngle < 90.0f) {
            this.nonNullLevel().setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)DoorBlock.OPEN, (Comparable)Boolean.valueOf(false)));
        }
        BlockPos otherPos = this.getBlockPos().relative(this.isTopDoor() ? Direction.DOWN : Direction.UP);
        PneumaticCraftUtils.getTileEntityAt((BlockGetter)this.getLevel(), otherPos, PneumaticDoorBlockEntity.class).ifPresent(otherDoorHalf -> {
            otherDoorHalf.rightGoing = this.rightGoing;
            otherDoorHalf.setChanged();
            if (rotationAngle != otherDoorHalf.rotationAngle) {
                otherDoorHalf.setRotationAngle(rotationAngle);
            }
        });
    }

    public boolean setColor(DyeColor dyeColor) {
        if (this.color != dyeColor.getId() && !((Boolean)this.getBlockState().getValue((Property)PneumaticDoorBlock.TOP_DOOR)).booleanValue()) {
            this.color = (byte)dyeColor.getId();
            this.nonNullLevel().getBlockEntity(this.getBlockPos(), ModBlockEntityTypes.PNEUMATIC_DOOR.get()).ifPresent(topHalf -> {
                topHalf.color = this.color;
                if (!this.nonNullLevel().isClientSide) {
                    this.setChanged();
                    topHalf.setChanged();
                    this.sendDescriptionPacket();
                }
            });
            return true;
        }
        return false;
    }

    private boolean isTopDoor() {
        return PneumaticDoorBlock.isTopDoor(this.nonNullLevel().getBlockState(this.getBlockPos()));
    }

    @Override
    public void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        tag.putBoolean("rightGoing", this.rightGoing);
        tag.putInt("color", this.color);
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        this.rightGoing = tag.getBoolean("rightGoing");
        this.color = tag.getInt("color");
        this.scheduleDescriptionPacket();
    }

    @Override
    public void serializeExtraItemData(CompoundTag blockEntityTag, boolean preserveState) {
        super.serializeExtraItemData(blockEntityTag, preserveState);
        blockEntityTag.putInt("color", this.color);
    }

    @Override
    public IItemHandler getItemHandler(@Nullable Direction dir) {
        return null;
    }

    @Override
    public boolean shouldPreserveStateOnBreak() {
        return true;
    }

    public AABB getRenderBoundingBox() {
        return new AABB((double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ(), (double)(this.getBlockPos().getX() + 1), (double)(this.getBlockPos().getY() + 2), (double)(this.getBlockPos().getZ() + 1));
    }
}

