/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity.utility;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.common.block.ReinforcedChestBlock;
import me.desht.pneumaticcraft.common.block.entity.AbstractPneumaticCraftBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IComparatorSupport;
import me.desht.pneumaticcraft.common.inventory.ReinforcedChestMenu;
import me.desht.pneumaticcraft.common.inventory.handler.ComparatorItemStackHandler;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;

public class ReinforcedChestBlockEntity
extends AbstractPneumaticCraftBlockEntity
implements MenuProvider,
IComparatorSupport {
    public static final int CHEST_SIZE = 36;
    public static final String NBT_ITEMS = "Items";
    private static final String NBT_LOOT_TABLE = "LootTable";
    private static final String NBT_LOOT_TABLE_SEED = "LootTableSeed";
    private ResourceLocation lootTable;
    private long lootTableSeed;
    private final ComparatorItemStackHandler inventory = new ComparatorItemStackHandler(this, 36){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return stack.getItem() != ((ReinforcedChestBlock)ModBlocks.REINFORCED_CHEST.get()).asItem() && super.isItemValid(slot, stack);
        }
    };

    public ReinforcedChestBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntityTypes.REINFORCED_CHEST.get(), pos, state);
    }

    @Override
    public IItemHandler getItemHandler(@Nullable Direction dir) {
        return this.inventory;
    }

    @Override
    public void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        if (this.lootTable != null) {
            tag.putString(NBT_LOOT_TABLE, this.lootTable.toString());
            if (this.lootTableSeed != 0L) {
                tag.putLong(NBT_LOOT_TABLE_SEED, this.lootTableSeed);
            }
        } else {
            tag.put(NBT_ITEMS, (Tag)this.inventory.serializeNBT());
        }
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        if (tag.contains(NBT_LOOT_TABLE, 8)) {
            this.lootTable = new ResourceLocation(tag.getString(NBT_LOOT_TABLE));
            this.lootTableSeed = tag.getLong(NBT_LOOT_TABLE_SEED);
        } else {
            this.inventory.deserializeNBT(tag.getCompound(NBT_ITEMS));
        }
    }

    @Override
    public boolean shouldPreserveStateOnBreak() {
        return true;
    }

    @Override
    public void getContentsToDrop(NonNullList<ItemStack> drops) {
    }

    @Override
    public void serializeExtraItemData(CompoundTag blockEntityTag, boolean preserveState) {
        super.serializeExtraItemData(blockEntityTag, preserveState);
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (this.inventory.getStackInSlot(i).isEmpty()) continue;
            blockEntityTag.put(NBT_ITEMS, (Tag)this.inventory.serializeNBT());
            break;
        }
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowId, Inventory inv, Player player) {
        this.maybeFillWithLoot(player);
        return new ReinforcedChestMenu(windowId, inv, this.getBlockPos());
    }

    public void maybeFillWithLoot(Player player) {
        Level level;
        if (this.lootTable != null && (level = this.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            LootTable table = this.level.getServer().getLootData().getLootTable(this.lootTable);
            this.lootTable = null;
            LootParams.Builder builder = new LootParams.Builder(serverLevel).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)this.worldPosition));
            if (player != null) {
                builder.withLuck(player.getLuck()).withParameter(LootContextParams.THIS_ENTITY, (Object)player);
            }
            RecipeWrapper invWrapper = new RecipeWrapper((IItemHandlerModifiable)this.inventory);
            table.fill((Container)invWrapper, builder.create(LootContextParamSets.CHEST), this.lootTableSeed);
            this.setChanged();
        }
    }

    @Override
    public int getComparatorValue() {
        return this.inventory.getComparatorValue();
    }
}

