/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity.utility;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.client.render.area.AreaRenderManager;
import me.desht.pneumaticcraft.common.block.ReinforcedChestBlock;
import me.desht.pneumaticcraft.common.block.SmartChestBlock;
import me.desht.pneumaticcraft.common.block.entity.AbstractTickingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IComparatorSupport;
import me.desht.pneumaticcraft.common.block.entity.IRedstoneControl;
import me.desht.pneumaticcraft.common.block.entity.RedstoneController;
import me.desht.pneumaticcraft.common.block.entity.SideConfigurator;
import me.desht.pneumaticcraft.common.inventory.SmartChestMenu;
import me.desht.pneumaticcraft.common.inventory.handler.ComparatorItemStackHandler;
import me.desht.pneumaticcraft.common.item.ItemRegistry;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticle;
import me.desht.pneumaticcraft.common.network.PacketSyncSmartChest;
import me.desht.pneumaticcraft.common.particle.AirParticleData;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.ITranslatableEnum;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;

public class SmartChestBlockEntity
extends AbstractTickingBlockEntity
implements MenuProvider,
IRedstoneControl<SmartChestBlockEntity>,
IComparatorSupport {
    public static final int CHEST_SIZE = 72;
    private static final String NBT_ITEMS = "Items";
    private final SmartChestItemHandler inventory = new SmartChestItemHandler(this, 72);
    @GuiSynced
    private final RedstoneController<SmartChestBlockEntity> rsController = new RedstoneController<SmartChestBlockEntity>(this);
    @GuiSynced
    private int pushPullModes = 0;
    @GuiSynced
    private int cooldown = 0;
    private final EnumMap<Direction, Integer> pullSlots = new EnumMap(Direction.class);
    private final EnumMap<Direction, Integer> pushSlots = new EnumMap(Direction.class);

    public SmartChestBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntityTypes.SMART_CHEST.get(), pos, state, 4);
    }

    @Override
    public void tickClient() {
        super.tickClient();
        if (this.getUpgrades(ModUpgrades.MAGNET.get()) == 0) {
            AreaRenderManager.getInstance().removeHandlers(this);
        }
    }

    @Override
    public void tickServer() {
        super.tickServer();
        if (this.rsController.shouldRun() && this.nonNullLevel().getGameTime() % (long)Math.max(this.getTickRate(), this.cooldown) == 0L) {
            boolean didWork = false;
            block4: for (SideConfigurator.RelativeFace face : SideConfigurator.RelativeFace.values()) {
                switch (this.getPushPullMode(face)) {
                    case PUSH: {
                        didWork |= this.tryPush(this.getAbsoluteFacing(face, this.getRotation()));
                        continue block4;
                    }
                    case PULL: {
                        didWork |= this.tryPull(this.getAbsoluteFacing(face, this.getRotation()));
                    }
                }
            }
            this.cooldown = didWork ? 0 : Math.min(this.cooldown + 4, 20);
        }
    }

    private boolean tryPush(Direction dir) {
        BlockEntity te = this.getCachedNeighbor(dir);
        if (te == null) {
            return this.tryDispense(dir);
        }
        return IOHelper.getInventoryForBlock(te, dir.getOpposite()).map(dstHandler -> {
            this.validateCachedSlot((Map<Direction, Integer>)this.pushSlots, dir, (IItemHandler)dstHandler);
            ItemStack toPush = this.findNextItem((IItemHandler)this.inventory, this.pushSlots, dir);
            if (toPush.isEmpty()) {
                return false;
            }
            ItemStack excess = ItemHandlerHelper.insertItem((IItemHandler)dstHandler, (ItemStack)toPush, (boolean)false);
            int transferred = toPush.getCount() - excess.getCount();
            if (transferred > 0) {
                this.inventory.extractItem(this.pushSlots.getOrDefault(dir, 0), transferred, false);
                return true;
            }
            this.pushSlots.put(dir, this.scanForward((IItemHandler)this.inventory, this.pushSlots.getOrDefault(dir, 0)));
            return false;
        }).orElse(false);
    }

    private boolean tryDispense(Direction dir) {
        ItemStack toPush;
        if (this.getUpgrades(ModUpgrades.DISPENSER.get()) > 0 && !Block.canSupportCenter((LevelReader)this.nonNullLevel(), (BlockPos)this.worldPosition, (Direction)dir.getOpposite()) && !(toPush = this.findNextItem((IItemHandler)this.inventory, this.pushSlots, dir)).isEmpty()) {
            ItemStack pushed = this.inventory.extractItem(this.pushSlots.getOrDefault(dir, 0), toPush.getCount(), false);
            BlockPos dropPos = this.worldPosition.relative(dir);
            PneumaticCraftUtils.dropItemOnGroundPrecisely(pushed, this.level, (double)dropPos.getX() + 0.5, (double)dropPos.getY() + 0.5, (double)dropPos.getZ() + 0.5);
            return true;
        }
        return false;
    }

    private boolean tryPull(Direction dir) {
        BlockEntity te = this.getCachedNeighbor(dir);
        if (te == null) {
            return this.tryMagnet(dir);
        }
        return IOHelper.getInventoryForBlock(this.getCachedNeighbor(dir), dir.getOpposite()).map(srcHandler -> {
            this.validateCachedSlot((Map<Direction, Integer>)this.pullSlots, dir, (IItemHandler)srcHandler);
            ItemStack toPull = this.findNextItem((IItemHandler)srcHandler, this.pullSlots, dir);
            if (toPull.isEmpty()) {
                return false;
            }
            ItemStack excess = ItemHandlerHelper.insertItem((IItemHandler)this.inventory, (ItemStack)toPull, (boolean)false);
            int transferred = toPull.getCount() - excess.getCount();
            if (transferred > 0) {
                srcHandler.extractItem(this.pullSlots.getOrDefault(dir, 0).intValue(), transferred, false);
                return true;
            }
            this.pullSlots.put(dir, this.scanForward((IItemHandler)this.inventory, this.pullSlots.getOrDefault(dir, 0)));
            return false;
        }).orElse(false);
    }

    private boolean tryMagnet(Direction dir) {
        if (this.getUpgrades(ModUpgrades.MAGNET.get()) > 0) {
            int range = this.getUpgrades(ModUpgrades.RANGE.get());
            BlockPos centrePos = this.worldPosition.relative(dir, range + 2);
            AABB aabb = new AABB(centrePos).inflate((double)(range + 1));
            List items = this.nonNullLevel().getEntitiesOfClass(ItemEntity.class, aabb, item -> item != null && item.isAlive() && !item.hasPickUpDelay() && !ItemRegistry.getInstance().shouldSuppressMagnet((Entity)item));
            boolean didWork = false;
            for (ItemEntity item2 : items) {
                ItemStack stack = item2.getItem();
                ItemStack excess = ItemHandlerHelper.insertItemStacked((IItemHandler)this.inventory, (ItemStack)stack, (boolean)false);
                if (excess.isEmpty()) {
                    item2.discard();
                } else {
                    item2.setItem(excess);
                }
                if (excess.getCount() >= stack.getCount()) continue;
                NetworkHandler.sendToAllTracking((CustomPacketPayload)new PacketSpawnParticle((ParticleOptions)AirParticleData.DENSE, item2.getX(), item2.getY() + 0.5, item2.getZ(), 0.0, 0.0, 0.0, 5, 0.5, 0.5, 0.5), this);
                didWork = true;
            }
            return didWork;
        }
        return false;
    }

    private void validateCachedSlot(Map<Direction, Integer> slotMap, Direction dir, IItemHandler handler) {
        if (slotMap.getOrDefault(dir, 0) >= handler.getSlots()) {
            slotMap.remove(dir);
        }
    }

    private ItemStack findNextItem(IItemHandler handler, EnumMap<Direction, Integer> slotMap, Direction dir) {
        if (handler.getSlots() <= 0) {
            return ItemStack.EMPTY;
        }
        if (handler.getStackInSlot(slotMap.getOrDefault(dir, 0).intValue()).isEmpty()) {
            slotMap.put(dir, this.scanForward(handler, slotMap.getOrDefault(dir, 0)));
        }
        return handler.extractItem(slotMap.getOrDefault(dir, 0).intValue(), this.getMaxItems(), true);
    }

    private int scanForward(IItemHandler handler, int slot) {
        int limit = handler.getSlots();
        for (int i = 0; i < limit; ++i) {
            if (++slot >= limit) {
                slot = 0;
            }
            if (!handler.getStackInSlot(slot).isEmpty()) break;
        }
        return slot;
    }

    public int getTickRate() {
        return 8 >> Math.min(3, this.getUpgrades(ModUpgrades.SPEED.get()));
    }

    public int getMaxItems() {
        int upgrades = this.getUpgrades(ModUpgrades.SPEED.get());
        return upgrades > 3 ? Math.min(1 << upgrades - 3, 256) : 1;
    }

    public Direction getAbsoluteFacing(SideConfigurator.RelativeFace face, Direction dir) {
        return switch (face) {
            default -> throw new IncompatibleClassChangeError();
            case SideConfigurator.RelativeFace.TOP -> Direction.UP;
            case SideConfigurator.RelativeFace.BOTTOM -> Direction.DOWN;
            case SideConfigurator.RelativeFace.FRONT -> dir;
            case SideConfigurator.RelativeFace.RIGHT -> dir.getCounterClockWise();
            case SideConfigurator.RelativeFace.LEFT -> dir.getClockWise();
            case SideConfigurator.RelativeFace.BACK -> dir.getOpposite();
        };
    }

    public PushPullMode getPushPullMode(SideConfigurator.RelativeFace face) {
        int idx = face.ordinal();
        int mask = 3 << idx * 2;
        int n = (this.pushPullModes & mask) >> idx * 2;
        return PushPullMode.values()[n];
    }

    private void setPushPullMode(SideConfigurator.RelativeFace face, PushPullMode mode) {
        int idx = face.ordinal();
        int mask = 3 << idx * 2;
        this.pushPullModes &= ~mask;
        this.pushPullModes |= mode.ordinal() << idx * 2;
    }

    @Override
    public IItemHandler getItemHandler(@Nullable Direction dir) {
        return this.inventory;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowId, Inventory inv, Player player) {
        if (player instanceof ServerPlayer) {
            NetworkHandler.sendToPlayer(PacketSyncSmartChest.forBlockEntity(this), (ServerPlayer)player);
        }
        return new SmartChestMenu(windowId, inv, this.getBlockPos());
    }

    @Override
    public boolean shouldPreserveStateOnBreak() {
        return true;
    }

    @Override
    public void getContentsToDrop(NonNullList<ItemStack> drops) {
    }

    @Override
    public void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        tag.put(NBT_ITEMS, (Tag)this.inventory.serializeNBT());
        tag.putInt("pushPull", this.pushPullModes);
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        this.inventory.deserializeNBT(tag.getCompound(NBT_ITEMS));
        this.pushPullModes = tag.getInt("pushPull");
    }

    @Override
    public void serializeExtraItemData(CompoundTag blockEntityTag, boolean preserveState) {
        boolean shouldSave;
        super.serializeExtraItemData(blockEntityTag, preserveState);
        boolean bl = shouldSave = this.inventory.lastSlot < 72 || this.rsController.getCurrentMode() != 0;
        if (!shouldSave) {
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                if (this.inventory.getStackInSlot(i).isEmpty() && this.inventory.filter[i].isEmpty()) continue;
                shouldSave = true;
            }
        }
        if (shouldSave) {
            blockEntityTag.put(NBT_ITEMS, (Tag)this.inventory.serializeNBT());
            blockEntityTag.putInt("redstoneMode", this.rsController.getCurrentMode());
        }
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
        String[] s;
        if (this.rsController.parseRedstoneMode(tag)) {
            return;
        }
        if (tag.startsWith("push_pull:") && (s = tag.split(":")).length == 2) {
            try {
                SideConfigurator.RelativeFace face = SideConfigurator.RelativeFace.valueOf(s[1]);
                this.cycleMode(face, shiftHeld);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public void cycleMode(SideConfigurator.RelativeFace face, boolean shiftHeld) {
        this.setPushPullMode(face, this.getPushPullMode(face).cycle(shiftHeld));
    }

    public int getLastSlot() {
        return this.inventory.getLastSlot();
    }

    public void setLastSlot(int lastSlot) {
        this.inventory.setLastSlot(lastSlot);
    }

    public List<Pair<Integer, ItemStack>> getFilter() {
        ArrayList<Pair<Integer, ItemStack>> res = new ArrayList<Pair<Integer, ItemStack>>();
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (this.inventory.filter[i].isEmpty()) continue;
            res.add((Pair<Integer, ItemStack>)Pair.of((Object)i, (Object)this.inventory.filter[i].copy()));
        }
        return res;
    }

    public void setFilter(List<Pair<Integer, ItemStack>> l) {
        Arrays.fill(this.inventory.filter, ItemStack.EMPTY);
        for (Pair<Integer, ItemStack> p : l) {
            this.inventory.setFilter((Integer)p.getLeft(), (ItemStack)p.getRight());
        }
    }

    public ItemStack getFilter(int slotId) {
        return this.inventory.filter[slotId];
    }

    public void setFilter(int slotId, ItemStack stack) {
        this.inventory.filter[slotId] = stack.copy();
    }

    @Override
    public RedstoneController<SmartChestBlockEntity> getRedstoneController() {
        return this.rsController;
    }

    @Override
    public int getComparatorValue() {
        return this.inventory.getComparatorValue();
    }

    public static IItemHandler deserializeSmartChest(CompoundTag tag) {
        SmartChestItemHandler res = new SmartChestItemHandler(null, 72);
        res.deserializeNBT(tag);
        return res;
    }

    public static class SmartChestItemHandler
    extends ComparatorItemStackHandler {
        private final ItemStack[] filter = new ItemStack[72];
        private int lastSlot = 72;

        SmartChestItemHandler(BlockEntity te, int size) {
            super(te, size);
            Arrays.fill(this.filter, ItemStack.EMPTY);
        }

        public int getSlots() {
            return Math.min(72, this.lastSlot);
        }

        public int getSlotLimit(int slot) {
            return this.filter[slot].isEmpty() ? super.getSlotLimit(slot) : this.filter[slot].getCount();
        }

        int getLastSlot() {
            return this.lastSlot;
        }

        void setLastSlot(int lastSlot) {
            for (int i = lastSlot; i < this.getSlots(); ++i) {
                if (this.getStackInSlot(i).isEmpty()) continue;
                return;
            }
            this.lastSlot = lastSlot;
        }

        public void setFilter(int slot, ItemStack stack) {
            this.filter[slot] = stack;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return slot < this.lastSlot && (this.filter[slot].isEmpty() || this.filter[slot].getItem() == stack.getItem()) && stack.getItem() != ((ReinforcedChestBlock)ModBlocks.REINFORCED_CHEST.get()).asItem() && stack.getItem() != ((SmartChestBlock)ModBlocks.SMART_CHEST.get()).asItem() && super.isItemValid(slot, stack);
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = super.serializeNBT();
            tag.putInt("LastSlot", this.lastSlot);
            ListTag l = new ListTag();
            for (int i = 0; i < 72; ++i) {
                if (this.filter[i].isEmpty()) continue;
                CompoundTag subTag = new CompoundTag();
                subTag.putInt("Slot", i);
                this.filter[i].save(subTag);
                l.add((Object)subTag);
            }
            tag.put("Filter", (Tag)l);
            tag.putBoolean("V2", true);
            return tag;
        }

        @Override
        public void deserializeNBT(CompoundTag nbt) {
            super.deserializeNBT(nbt);
            this.lastSlot = nbt.getInt("LastSlot");
            ListTag l = nbt.getList("Filter", 10);
            boolean isV2 = nbt.getBoolean("V2");
            for (int i = 0; i < l.size(); ++i) {
                CompoundTag tag = l.getCompound(i);
                ItemStack stack = ItemStack.of((CompoundTag)tag);
                if (!isV2 && stack.getCount() == 1) {
                    stack.setCount(stack.getMaxStackSize());
                }
                this.filter[tag.getInt((String)"Slot")] = stack;
            }
        }
    }

    public static enum PushPullMode implements ITranslatableEnum
    {
        NONE("none"),
        PUSH("push"),
        PULL("pull");

        private final String key;

        private PushPullMode(String key) {
            this.key = key;
        }

        @Override
        public String getTranslationKey() {
            return "pneumaticcraft.gui.tooltip.smartChest.mode." + this.key;
        }

        public PushPullMode cycle(boolean backward) {
            int n = this.ordinal() + (backward ? -1 : 1);
            if (n < 0) {
                n = PushPullMode.values().length - 1;
            } else if (n >= PushPullMode.values().length) {
                n = 0;
            }
            return PushPullMode.values()[n];
        }
    }
}

