/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.capabilities;

import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.pressure.IPressurizableItem;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerItem;
import me.desht.pneumaticcraft.common.registry.ModAttachmentTypes;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.Validate;

public class AirHandlerItemStack
implements IAirHandlerItem {
    public static final String AIR_NBT_KEY = "pneumaticcraft:air";
    private final ItemStack container;
    private final IPressurizableItem pressurizable;
    private int baseVolume;
    private final float maxPressure;

    public AirHandlerItemStack(ItemStack container) {
        Validate.isTrue((boolean)(container.getItem() instanceof IPressurizableItem), (String)("itemstack " + container + " must be an IPressurizableItem!"), (Object[])new Object[0]);
        this.container = container;
        this.pressurizable = (IPressurizableItem)container.getItem();
        this.baseVolume = this.pressurizable.getBaseVolume();
        this.maxPressure = this.pressurizable.getMaxPressure();
    }

    @Override
    @Nonnull
    public ItemStack getContainer() {
        return this.container;
    }

    @Override
    public float getPressure() {
        float pressure = this.pressurizable.getPressure(this.container);
        if (pressure > this.maxPressure) {
            this.container.getOrCreateTag().putInt(AIR_NBT_KEY, (int)(this.maxPressure * (float)this.getVolume()));
            return this.maxPressure;
        }
        return pressure;
    }

    @Override
    public int getAir() {
        return this.pressurizable.getAir(this.container);
    }

    @Override
    public void addAir(int amount) {
        if (this.container.getCount() != 1) {
            return;
        }
        int currentAir = this.getAir();
        int newAir = currentAir + amount;
        if (newAir != 0) {
            this.container.setData(ModAttachmentTypes.AIR.get(), (Object)(currentAir + amount));
        } else {
            this.container.removeData(ModAttachmentTypes.AIR.get());
        }
    }

    @Override
    public int getBaseVolume() {
        return this.baseVolume;
    }

    @Override
    public void setBaseVolume(int newBaseVolume) {
        this.baseVolume = newBaseVolume;
    }

    @Override
    public int getVolume() {
        return this.pressurizable.getEffectiveVolume(this.container);
    }

    @Override
    public float maxPressure() {
        return this.maxPressure;
    }
}

