/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.capabilities;

import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class FluidHandlerSavedItemStack
implements IFluidHandlerItem {
    private final ItemStack holderStack;
    private final String tankName;
    private final Predicate<Fluid> fluidPredicate;
    private final FluidTank fluidTank;

    public FluidHandlerSavedItemStack(ItemStack holderStack, String tankName, int capacity, Predicate<Fluid> fluidPredicate) {
        this.holderStack = holderStack;
        this.tankName = tankName;
        this.fluidPredicate = fluidPredicate;
        FluidTank tank = this.deserializeTank(holderStack, tankName, capacity);
        this.fluidTank = tank == null ? new FluidTank(capacity) : tank;
    }

    public FluidHandlerSavedItemStack(ItemStack holderStack, String tankName, int capacity) {
        this(holderStack, tankName, capacity, fluid -> true);
    }

    private void serializeTank(FluidTank tank, String tagName) {
        CompoundTag tag = this.holderStack.getOrCreateTagElement("BlockEntityTag");
        CompoundTag subTag = tag.getCompound("SavedTanks");
        if (!tank.getFluid().isEmpty()) {
            subTag.put(tagName, (Tag)tank.writeToNBT(new CompoundTag()));
        } else {
            subTag.remove(tagName);
        }
        if (!subTag.isEmpty()) {
            tag.put("SavedTanks", (Tag)subTag);
        } else {
            tag.remove("SavedTanks");
            if (tag.isEmpty()) {
                Objects.requireNonNull(this.holderStack.getTag()).remove("BlockEntityTag");
                if (this.holderStack.getTag().isEmpty()) {
                    this.holderStack.setTag(null);
                }
            }
        }
    }

    private FluidTank deserializeTank(ItemStack stack, String tagName, int capacity) {
        CompoundTag tag = stack.getTagElement("BlockEntityTag");
        if (tag != null && tag.contains("SavedTanks")) {
            FluidTank tank = new FluidTank(capacity);
            CompoundTag subTag = tag.getCompound("SavedTanks");
            return tank.readFromNBT(subTag.getCompound(tagName));
        }
        return null;
    }

    @Nonnull
    public ItemStack getContainer() {
        return this.holderStack;
    }

    public int getTanks() {
        return this.fluidTank == null ? 0 : this.fluidTank.getTanks();
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        return this.fluidTank == null ? FluidStack.EMPTY : this.fluidTank.getFluidInTank(tank);
    }

    public int getTankCapacity(int tank) {
        return this.fluidTank == null ? 0 : this.fluidTank.getTankCapacity(tank);
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return this.fluidTank != null && this.fluidPredicate.test(stack.getFluid()) && this.fluidTank.isFluidValid(tank, stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction doFill) {
        if (this.fluidTank == null || !this.isFluidValid(0, resource)) {
            return 0;
        }
        int filled = this.fluidTank.fill(resource, doFill);
        if (filled > 0 && doFill == IFluidHandler.FluidAction.EXECUTE) {
            this.serializeTank(this.fluidTank, this.tankName);
        }
        return filled;
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction doDrain) {
        if (this.fluidTank == null) {
            return FluidStack.EMPTY;
        }
        FluidStack drained = this.fluidTank.drain(resource, doDrain);
        if (!drained.isEmpty() && doDrain == IFluidHandler.FluidAction.EXECUTE) {
            this.serializeTank(this.fluidTank, this.tankName);
        }
        return drained;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction doDrain) {
        if (this.fluidTank == null) {
            return FluidStack.EMPTY;
        }
        FluidStack drained = this.fluidTank.drain(maxDrain, doDrain);
        if (!drained.isEmpty() && doDrain == IFluidHandler.FluidAction.EXECUTE) {
            this.serializeTank(this.fluidTank, this.tankName);
        }
        return drained;
    }
}

