/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.capabilities;

import java.util.function.Predicate;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.templates.FluidHandlerItemStack;

public class PNCFluidHandlerItemStack
extends FluidHandlerItemStack {
    private final Predicate<Fluid> fluidPredicate;

    public PNCFluidHandlerItemStack(ItemStack container, int capacity, Predicate<Fluid> fluidPredicate) {
        super(container, capacity);
        this.fluidPredicate = fluidPredicate;
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return this.fluidPredicate.test(stack.getFluid());
    }

    protected void setFluid(FluidStack fluid) {
        if (this.fluidPredicate.test(fluid.getFluid())) {
            super.setFluid(fluid);
        }
    }

    public boolean canFillFluidType(FluidStack fluid) {
        return this.fluidPredicate.test(fluid.getFluid());
    }

    public boolean canDrainFluidType(FluidStack fluid) {
        return this.fluidPredicate.test(fluid.getFluid());
    }
}

