/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorUpgradeHandler;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSetGlobalVariable;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorRegistry;
import me.desht.pneumaticcraft.common.util.GlobalPosHelper;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.variables.GlobalVariableHelper;
import me.desht.pneumaticcraft.common.variables.GlobalVariableManager;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.commands.synchronization.SingletonArgumentInfo;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.apache.commons.lang3.StringUtils;

public class ModCommands {
    public static final DeferredRegister<ArgumentTypeInfo<?, ?>> COMMAND_ARGUMENT_TYPES = DeferredRegister.create((ResourceKey)Registries.COMMAND_ARGUMENT_TYPE, (String)"pneumaticcraft");
    private static final DeferredHolder<ArgumentTypeInfo<?, ?>, SingletonArgumentInfo<VarnameType>> VARNAME_COMMAND_ARGUMENT_TYPE = COMMAND_ARGUMENT_TYPES.register("varname", () -> (SingletonArgumentInfo)ArgumentTypeInfos.registerByClass(VarnameType.class, (ArgumentTypeInfo)SingletonArgumentInfo.contextFree(VarnameType::new)));
    private static final ResourceLocation UNKNOWN_ITEM = PneumaticRegistry.RL("unknown");

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"pncr").then(((LiteralArgumentBuilder)Commands.literal((String)"dump_nbt").requires(cs -> cs.hasPermission(2))).executes(ModCommands::dumpNBT))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"global_var").then(Commands.literal((String)"get").then(Commands.argument((String)"varname", (ArgumentType)new VarnameType()).suggests(ModCommands::suggestVarNames).executes(c -> ModCommands.getGlobalVar((CommandContext<CommandSourceStack>)c, StringArgumentType.getString((CommandContext)c, (String)"varname")))))).then(Commands.literal((String)"set").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"varname", (ArgumentType)new VarnameType()).then(Commands.argument((String)"val", (ArgumentType)IntegerArgumentType.integer()).executes(c -> ModCommands.setGlobalVar((CommandContext<CommandSourceStack>)c, StringArgumentType.getString((CommandContext)c, (String)"varname"), (Either<BlockPos, ItemInput>)Either.left((Object)new BlockPos(IntegerArgumentType.getInteger((CommandContext)c, (String)"val"), 0, 0)))))).then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(c -> ModCommands.setGlobalVar((CommandContext<CommandSourceStack>)c, StringArgumentType.getString((CommandContext)c, (String)"varname"), (Either<BlockPos, ItemInput>)Either.left((Object)BlockPosArgument.getBlockPos((CommandContext)c, (String)"pos")))))).then(Commands.argument((String)"item", (ArgumentType)ItemArgument.item((CommandBuildContext)buildContext)).executes(c -> ModCommands.setGlobalVar((CommandContext<CommandSourceStack>)c, StringArgumentType.getString((CommandContext)c, (String)"varname"), (Either<BlockPos, ItemInput>)Either.right((Object)ItemArgument.getItem((CommandContext)c, (String)"item")))))))).then(Commands.literal((String)"delete").then(Commands.argument((String)"varname", (ArgumentType)StringArgumentType.greedyString()).suggests(ModCommands::suggestVarNames).executes(c -> ModCommands.delGlobalVar((CommandContext<CommandSourceStack>)c, StringArgumentType.getString((CommandContext)c, (String)"varname")))))).then(Commands.literal((String)"list").executes(ModCommands::listGlobalVars)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"amadrone_deliver").requires(cs -> cs.hasPermission(2))).then(Commands.argument((String)"toPos", (ArgumentType)BlockPosArgument.blockPos()).then(Commands.argument((String)"fromPos", (ArgumentType)BlockPosArgument.blockPos()).executes(ctx -> ModCommands.amadroneDeliver((CommandSourceStack)ctx.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext)ctx, (String)"toPos"), BlockPosArgument.getLoadedBlockPos((CommandContext)ctx, (String)"fromPos")))))).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"fromPos", (ArgumentType)BlockPosArgument.blockPos()).executes(ctx -> ModCommands.amadroneDeliver((CommandSourceStack)ctx.getSource(), EntityArgument.getPlayer((CommandContext)ctx, (String)"player").blockPosition(), BlockPosArgument.getLoadedBlockPos((CommandContext)ctx, (String)"fromPos"))))))).then(Commands.literal((String)"armor_upgrade").then(Commands.argument((String)"upgrade", (ArgumentType)ResourceLocationArgument.id()).suggests((ctx, builder) -> ModCommands.suggestUpgradeIDs(builder)).then(Commands.argument((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> ModCommands.setArmorUpgrade((CommandSourceStack)ctx.getSource(), ResourceLocationArgument.getId((CommandContext)ctx, (String)"upgrade"), BoolArgumentType.getBool((CommandContext)ctx, (String)"enabled")))))));
    }

    private static int setArmorUpgrade(CommandSourceStack source, ResourceLocation id, boolean enabled) throws CommandSyntaxException {
        Optional<IArmorUpgradeHandler<?>> upgrade = CommonArmorRegistry.getInstance().getArmorUpgradeHandler(id);
        if (upgrade.isPresent()) {
            CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer((Player)source.getPlayerOrException());
            if (handler.upgradeUsable(upgrade.get(), false)) {
                handler.setUpgradeEnabled(upgrade.get(), enabled);
                source.sendSuccess(() -> Component.literal((String)(id + " enabled = " + enabled)), false);
                return 1;
            }
            source.sendFailure((Component)Component.literal((String)("Upgrade " + id + " is not inserted!")).withStyle(ChatFormatting.RED));
            return 0;
        }
        source.sendFailure((Component)Component.literal((String)("Unknown upgrade ID: " + id)).withStyle(ChatFormatting.RED));
        return 0;
    }

    private static CompletableFuture<Suggestions> suggestUpgradeIDs(SuggestionsBuilder builder) {
        return SharedSuggestionProvider.suggest(ArmorUpgradeRegistry.getInstance().getKnownUpgradeIds(), (SuggestionsBuilder)builder);
    }

    private static CompletableFuture<Suggestions> suggestVarNames(CommandContext<CommandSourceStack> ctx, SuggestionsBuilder builder) {
        Collection<String> varNames = GlobalVariableManager.getInstance().getAllActiveVariableNames((Player)((CommandSourceStack)ctx.getSource()).getPlayer());
        return SharedSuggestionProvider.suggest(varNames, (SuggestionsBuilder)builder);
    }

    private static int dumpNBT(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        if (source.getEntity() instanceof Player) {
            ItemStack held = ((Player)source.getEntity()).getMainHandItem();
            if (held.getTag() == null) {
                source.sendFailure((Component)Component.literal((String)"No NBT"));
                return 0;
            }
            if (held.getTag().isEmpty()) {
                source.sendFailure((Component)Component.literal((String)"Empty NBT"));
                return 0;
            }
            source.sendSuccess(() -> Component.literal((String)held.getTag().toString()), false);
            return 1;
        }
        return 0;
    }

    private static int amadroneDeliver(CommandSourceStack source, BlockPos toPos, BlockPos fromPos) {
        BlockEntity te = source.getLevel().getBlockEntity(fromPos);
        int status = IOHelper.getInventoryForBlock(te).map(inv -> {
            ArrayList<ItemStack> deliveredStacks = new ArrayList<ItemStack>();
            for (int i = 0; i < inv.getSlots() && deliveredStacks.size() < 36; ++i) {
                if (inv.getStackInSlot(i).isEmpty()) continue;
                deliveredStacks.add(inv.getStackInSlot(i));
            }
            if (!deliveredStacks.isEmpty()) {
                GlobalPos gPos = GlobalPosHelper.makeGlobalPos((Level)source.getLevel(), toPos);
                PneumaticRegistry.getInstance().getDroneRegistry().deliverItemsAmazonStyle(gPos, deliveredStacks.toArray(new ItemStack[0]));
                source.sendSuccess(() -> PneumaticCraftUtils.xlate("pneumaticcraft.command.deliverAmazon.success", PneumaticCraftUtils.posToString(fromPos), PneumaticCraftUtils.posToString(toPos)), false);
                return 1;
            }
            source.sendFailure((Component)PneumaticCraftUtils.xlate("pneumaticcraft.command.deliverAmazon.noItems", PneumaticCraftUtils.posToString(fromPos)));
            return 0;
        }).orElse(-1);
        if (status == -1) {
            source.sendFailure((Component)PneumaticCraftUtils.xlate("pneumaticcraft.command.deliverAmazon.noInventory", PneumaticCraftUtils.posToString(fromPos)));
        }
        return status;
    }

    private static int listGlobalVars(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        Player playerEntity = source.getEntity() instanceof Player ? (Player)source.getEntity() : null;
        UUID id = playerEntity == null ? null : playerEntity.getUUID();
        Collection<String> varNames = GlobalVariableManager.getInstance().getAllActiveVariableNames(playerEntity);
        source.sendSuccess(() -> Component.literal((String)(varNames.size() + " vars")).withStyle(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.UNDERLINE}), false);
        varNames.stream().sorted().forEach(var -> {
            BlockPos pos = GlobalVariableHelper.getPos(id, var);
            ItemStack stack = GlobalVariableHelper.getStack(id, var);
            String val = PneumaticCraftUtils.posToString(pos) + (String)(stack.isEmpty() ? "" : " / " + PneumaticCraftUtils.getRegistryName(stack.getItem()).orElse(UNKNOWN_ITEM));
            source.sendSuccess(() -> Component.literal((String)var).append(" = [").append(val).append("]"), false);
        });
        return 1;
    }

    private static int getGlobalVar(CommandContext<CommandSourceStack> ctx, String varName0) {
        UUID uUID;
        Entity entity;
        Object varName;
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        if (!GlobalVariableHelper.hasPrefix(varName0)) {
            source.sendSuccess(() -> PneumaticCraftUtils.xlate("pneumaticcraft.command.globalVariable.prefixReminder", varName0).withStyle(ChatFormatting.GOLD), false);
            varName = "#" + varName0;
        } else {
            varName = varName0;
        }
        if (((String)varName).startsWith("%") || !((entity = ((CommandSourceStack)ctx.getSource()).getEntity()) instanceof Player)) {
            uUID = null;
        } else {
            Player player = (Player)entity;
            uUID = player.getUUID();
        }
        UUID id = uUID;
        BlockPos pos = GlobalVariableHelper.getPos(id, (String)varName);
        ItemStack stack = GlobalVariableHelper.getStack(id, (String)varName);
        String val = PneumaticCraftUtils.posToString(pos) + (String)(stack.isEmpty() ? "" : " / " + PneumaticCraftUtils.getRegistryName(stack.getItem()).orElse(UNKNOWN_ITEM));
        if (pos == null && stack.isEmpty()) {
            source.sendFailure((Component)PneumaticCraftUtils.xlate("pneumaticcraft.command.globalVariable.missing", varName));
        } else {
            source.sendSuccess(() -> ModCommands.lambda$getGlobalVar$20((String)varName, val), false);
        }
        return 1;
    }

    private static int setGlobalVar(CommandContext<CommandSourceStack> ctx, String varName0, Either<BlockPos, ItemInput> posOrItem) {
        Object varName;
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        if (!GlobalVariableHelper.hasPrefix(varName0)) {
            source.sendSuccess(() -> PneumaticCraftUtils.xlate("pneumaticcraft.command.globalVariable.prefixReminder", varName0).withStyle(ChatFormatting.GOLD), false);
            varName = "#" + varName0;
        } else {
            varName = varName0;
        }
        try {
            UUID id = ((String)varName).startsWith("%") ? null : ((CommandSourceStack)ctx.getSource()).getPlayerOrException().getUUID();
            Object v = varName;
            posOrItem.ifLeft(arg_0 -> ModCommands.lambda$setGlobalVar$23(id, (String)v, source, arg_0)).ifRight(arg_0 -> ModCommands.lambda$setGlobalVar$25(id, (String)v, source, arg_0));
        }
        catch (CommandSyntaxException e) {
            source.sendFailure((Component)Component.literal((String)"Player-globals require player context!"));
        }
        return 1;
    }

    private static int delGlobalVar(CommandContext<CommandSourceStack> ctx, String varName0) {
        Object varName;
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        if (!GlobalVariableHelper.hasPrefix(varName0)) {
            source.sendSuccess(() -> PneumaticCraftUtils.xlate("pneumaticcraft.command.globalVariable.prefixReminder", varName0).withStyle(ChatFormatting.GOLD), false);
            varName = "#" + varName0;
        } else {
            varName = varName0;
        }
        try {
            UUID id;
            UUID uUID = id = ((String)varName).startsWith("%") ? null : ((CommandSourceStack)ctx.getSource()).getPlayerOrException().getUUID();
            if (GlobalVariableHelper.getPos(id, (String)varName) == null && GlobalVariableHelper.getStack(id, (String)varName).isEmpty()) {
                source.sendFailure((Component)PneumaticCraftUtils.xlate("pneumaticcraft.command.globalVariable.missing", varName));
            } else {
                GlobalVariableHelper.setPos(id, (String)varName, null);
                GlobalVariableHelper.setStack(id, (String)varName, ItemStack.EMPTY);
                if (id != null) {
                    PneumaticRegistry.getInstance().getMiscHelpers().syncGlobalVariable(((CommandSourceStack)ctx.getSource()).getPlayerOrException(), (String)varName);
                } else {
                    NetworkHandler.sendToAll(PacketSetGlobalVariable.forPos((String)varName, null));
                    NetworkHandler.sendToAll(PacketSetGlobalVariable.forItem((String)varName, ItemStack.EMPTY));
                }
                source.sendSuccess(() -> ModCommands.lambda$delGlobalVar$27((String)varName), true);
            }
        }
        catch (CommandSyntaxException e) {
            source.sendFailure((Component)Component.literal((String)"Player-globals require player context!"));
        }
        return 1;
    }

    private static /* synthetic */ Component lambda$delGlobalVar$27(String varName) {
        return PneumaticCraftUtils.xlate("pneumaticcraft.command.globalVariable.delete", varName);
    }

    private static /* synthetic */ void lambda$setGlobalVar$25(UUID id, String v, CommandSourceStack source, ItemInput item) {
        ItemStack stack = new ItemStack((ItemLike)item.getItem());
        GlobalVariableHelper.setStack(id, v, stack);
        source.sendSuccess(() -> PneumaticCraftUtils.xlate("pneumaticcraft.command.globalVariable.output", v, PneumaticCraftUtils.getRegistryName(stack.getItem()).orElse(UNKNOWN_ITEM)), true);
    }

    private static /* synthetic */ void lambda$setGlobalVar$23(UUID id, String v, CommandSourceStack source, BlockPos pos) {
        GlobalVariableHelper.setPos(id, v, pos);
        source.sendSuccess(() -> PneumaticCraftUtils.xlate("pneumaticcraft.command.globalVariable.output", v, PneumaticCraftUtils.posToString(pos)), true);
    }

    private static /* synthetic */ Component lambda$getGlobalVar$20(String varName, String val) {
        return PneumaticCraftUtils.xlate("pneumaticcraft.command.globalVariable.output", varName, val);
    }

    private static class VarnameType
    implements ArgumentType<String> {
        private VarnameType() {
        }

        public String parse(StringReader reader) {
            int start = reader.getCursor();
            if (reader.peek() == '#' || reader.peek() == '%') {
                reader.skip();
            }
            while (reader.canRead() && (StringUtils.isAlphanumeric((CharSequence)String.valueOf(reader.peek())) || reader.peek() == '_')) {
                reader.skip();
            }
            return reader.getString().substring(start, reader.getCursor());
        }
    }
}

