/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.config;

import me.desht.pneumaticcraft.client.pneumatic_armor.ComponentInit;
import me.desht.pneumaticcraft.common.config.ClientConfig;
import me.desht.pneumaticcraft.common.config.CommonConfig;
import me.desht.pneumaticcraft.common.config.ConfigHolder;
import me.desht.pneumaticcraft.common.drone.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.registry.ModFluids;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;

public class ConfigHelper {
    static Fluid cachedXPFluid = null;

    public static ClientConfig client() {
        return ConfigHolder.client;
    }

    public static CommonConfig common() {
        return ConfigHolder.common;
    }

    public static void setProgrammerDifficulty(IProgWidget.WidgetDifficulty difficulty) {
        ConfigHolder.client.general.programmerDifficulty.set((Object)difficulty);
    }

    public static void setGuiRemoteGridSnap(boolean snap) {
        ConfigHolder.client.general.guiRemoteGridSnap.set((Object)snap);
    }

    public static void updateCoordTracker(boolean pathEnabled, boolean wirePath, boolean xRayEnabled, ClientConfig.PathUpdateSetting pathUpdateSetting) {
        ConfigHolder.client.armor.pathEnabled.set((Object)pathEnabled);
        ConfigHolder.client.armor.wirePath.set((Object)wirePath);
        ConfigHolder.client.armor.xRayEnabled.set((Object)xRayEnabled);
        ConfigHolder.client.armor.pathUpdateSetting.set((Object)pathUpdateSetting);
    }

    public static void setShowPressureNumerically(boolean numeric) {
        ConfigHolder.client.armor.showPressureNumerically.set((Object)numeric);
    }

    public static void setShowEnchantGlint(boolean show) {
        ConfigHolder.client.armor.showEnchantGlint.set((Object)show);
    }

    public static void setComponentInit(ComponentInit when) {
        ConfigHolder.client.armor.componentInitMessages.set((Object)when);
    }

    public static Fluid getExperienceFluid() {
        if (cachedXPFluid == null) {
            try {
                ResourceLocation id = new ResourceLocation((String)ConfigHolder.common.machines.defaultXPFluid.get());
                cachedXPFluid = (Fluid)BuiltInRegistries.FLUID.getOrThrow(ResourceKey.create((ResourceKey)Registries.FLUID, (ResourceLocation)id));
            }
            catch (IllegalStateException | ResourceLocationException e) {
                Log.error("invalid resource location {} for 'default_experience_fluid'", ConfigHolder.common.machines.defaultXPFluid.get());
                cachedXPFluid = ModFluids.MEMORY_ESSENCE.get();
            }
        }
        return cachedXPFluid;
    }
}

