/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.config.subconfig;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.config.subconfig.AuxConfigJson;
import me.desht.pneumaticcraft.common.config.subconfig.IAuxConfig;
import me.desht.pneumaticcraft.common.item.MicromissilesItem;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;

public class MicromissileDefaults
extends AuxConfigJson {
    public static final MicromissileDefaults INSTANCE = new MicromissileDefaults();
    public static final Entry FALLBACK = new Entry(0.33333334f, 0.33333334f, 0.33333334f, new PointXY(46, 54), "", MicromissilesItem.FireMode.SMART);
    private final Map<UUID, Entry> defaults = new HashMap<UUID, Entry>();

    private MicromissileDefaults() {
        super(true);
    }

    @Override
    protected void writeToJson(JsonObject json) {
        JsonObject sub = new JsonObject();
        for (Map.Entry<UUID, Entry> entry : this.defaults.entrySet()) {
            sub.add(entry.getKey().toString(), (JsonElement)entry.getValue().toJson());
        }
        json.addProperty("Description", "Stores default Micromissile settings on a per-player basis");
        json.add("defaults", (JsonElement)sub);
    }

    @Override
    protected void readFromJson(JsonObject json) {
        this.defaults.clear();
        JsonObject sub = json.getAsJsonObject("defaults");
        for (Map.Entry entry : sub.entrySet()) {
            if (((JsonElement)entry.getValue()).isJsonObject()) {
                this.defaults.put(UUID.fromString((String)entry.getKey()), Entry.fromJson(((JsonElement)entry.getValue()).getAsJsonObject()));
                continue;
            }
            Log.warning("Invalid JSON? entry '{}' in {}", entry.getKey(), this.getConfigFilename());
        }
    }

    @Override
    public String getConfigFilename() {
        return "MicromissileDefaults";
    }

    @Override
    public IAuxConfig.Sidedness getSidedness() {
        return IAuxConfig.Sidedness.SERVER;
    }

    public void setDefaults(Player player, Entry entry) {
        entry.playerName = player.getName().getString();
        this.defaults.put(player.getUUID(), entry);
    }

    @Nonnull
    public Entry getDefaults(Player player) {
        return this.defaults.getOrDefault(player.getUUID(), FALLBACK);
    }

    public static class Entry {
        public final float topSpeed;
        public final float turnSpeed;
        public final float damage;
        public final PointXY p;
        public final String entityFilter;
        public final MicromissilesItem.FireMode fireMode;
        String playerName = "";

        public Entry(float topSpeed, float turnSpeed, float damage, PointXY p, String entityFilter, MicromissilesItem.FireMode fireMode) {
            this.topSpeed = topSpeed;
            this.turnSpeed = turnSpeed;
            this.damage = damage;
            this.p = p;
            this.entityFilter = entityFilter;
            this.fireMode = fireMode;
        }

        static Entry fromJson(JsonObject value) {
            Entry entry = new Entry(value.get("topSpeed").getAsFloat(), value.get("turnSpeed").getAsFloat(), value.get("damage").getAsFloat(), new PointXY(value.get("px").getAsInt(), value.get("py").getAsInt()), value.get("entityFilter").getAsString(), MicromissilesItem.FireMode.fromString(value.get("fireMode").getAsString()));
            entry.playerName = value.get("playerName").getAsString();
            return entry;
        }

        JsonObject toJson() {
            JsonObject obj = new JsonObject();
            obj.addProperty("topSpeed", (Number)Float.valueOf(this.topSpeed));
            obj.addProperty("turnSpeed", (Number)Float.valueOf(this.turnSpeed));
            obj.addProperty("damage", (Number)Float.valueOf(this.damage));
            obj.addProperty("px", (Number)this.p.x());
            obj.addProperty("py", (Number)this.p.y());
            obj.addProperty("entityFilter", this.entityFilter);
            obj.addProperty("playerName", this.playerName);
            obj.addProperty("fireMode", this.fireMode.toString());
            return obj;
        }

        public CompoundTag toNBT() {
            CompoundTag tag = new CompoundTag();
            tag.putFloat("topSpeed", this.topSpeed);
            tag.putFloat("turnSpeed", this.turnSpeed);
            tag.putFloat("damage", this.damage);
            tag.putString("filter", this.entityFilter);
            tag.putInt("px", this.p.x());
            tag.putInt("py", this.p.y());
            tag.putString("fireMode", this.fireMode.toString());
            return tag;
        }
    }
}

