/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.debug;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;

public class DroneDebugEntry {
    private final int progWidgetId;
    private final String message;
    private final BlockPos pos;
    private long receivedTime;

    public DroneDebugEntry(String message, int progWidgetId, BlockPos pos) {
        this.message = message;
        this.pos = pos != null ? pos : BlockPos.ZERO;
        this.progWidgetId = progWidgetId;
    }

    public DroneDebugEntry(FriendlyByteBuf buf) {
        this.message = buf.readUtf();
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.progWidgetId = buf.readInt();
        this.receivedTime = System.currentTimeMillis();
    }

    public void toNetwork(FriendlyByteBuf buf) {
        buf.writeUtf(this.message);
        buf.writeInt(this.pos.getX());
        buf.writeInt(this.pos.getY());
        buf.writeInt(this.pos.getZ());
        buf.writeInt(this.progWidgetId);
    }

    public String getMessage() {
        return this.message;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public int getProgWidgetId() {
        return this.progWidgetId;
    }

    public long getReceivedTime() {
        return this.receivedTime;
    }

    public boolean hasCoords() {
        return this.pos.getX() != 0 || this.pos.getY() != 0 || this.pos.getZ() != 0;
    }
}

