/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.debug;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.debug.DroneDebugEntry;
import me.desht.pneumaticcraft.common.drone.IDroneBase;
import me.desht.pneumaticcraft.common.entity.drone.DroneEntity;
import me.desht.pneumaticcraft.common.item.PneumaticArmorItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSendDroneDebugEntry;
import me.desht.pneumaticcraft.common.network.PacketSyncDroneProgWidgets;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.event.entity.living.LivingEvent;

public class DroneDebugger {
    private final IDroneBase drone;
    private final DroneDebugList debugList = new DroneDebugList();
    private final Set<ServerPlayer> debuggingPlayers = new HashSet<ServerPlayer>();

    public DroneDebugger(IDroneBase drone) {
        this.drone = drone;
    }

    public DroneDebugEntry getDebugEntry(int widgetID) {
        return this.debugList.get(widgetID);
    }

    public void addEntry(String message) {
        this.addEntry(message, null);
    }

    public void addEntry(String message, BlockPos pos) {
        DroneDebugEntry entry = new DroneDebugEntry(message, this.getActiveWidgetIndex(), pos);
        this.addEntry(entry);
        PacketSendDroneDebugEntry packet = PacketSendDroneDebugEntry.create(this.drone, entry);
        for (ServerPlayer player : this.debuggingPlayers) {
            NetworkHandler.sendToPlayer(packet, player);
        }
    }

    public void addEntry(DroneDebugEntry entry) {
        this.debugList.addEntry(entry);
    }

    public void trackAsDebugged(ServerPlayer player) {
        NetworkHandler.sendToPlayer(PacketSyncDroneProgWidgets.create(this.drone), player);
        for (DroneDebugEntry entry : this.debugList.getAll()) {
            NetworkHandler.sendToPlayer(PacketSendDroneDebugEntry.create(this.drone, entry), player);
        }
        this.debuggingPlayers.add(player);
    }

    public void updateDebuggingPlayers() {
        this.debuggingPlayers.removeIf(player -> !player.isAlive() || !PneumaticArmorItem.isPlayerDebuggingDrone((Player)player, this.drone));
    }

    public Collection<ServerPlayer> getDebuggingPlayers() {
        return this.debuggingPlayers;
    }

    private int getActiveWidgetIndex() {
        return this.drone.getActiveWidgetIndex();
    }

    private class DroneDebugList {
        private final Int2ObjectMap<DroneDebugEntry> debugEntries = new Int2ObjectOpenHashMap();

        private DroneDebugList() {
        }

        void addEntry(DroneDebugEntry entry) {
            this.debugEntries.put(DroneDebugger.this.getActiveWidgetIndex(), (Object)entry);
        }

        public Collection<DroneDebugEntry> getAll() {
            return this.debugEntries.values();
        }

        public DroneDebugEntry get(int widgetId) {
            return (DroneDebugEntry)this.debugEntries.get(widgetId);
        }

        public DroneDebugEntry getCurrent() {
            return (DroneDebugEntry)this.debugEntries.get(DroneDebugger.this.getActiveWidgetIndex());
        }
    }

    @Mod.EventBusSubscriber(modid="pneumaticcraft")
    public static class Listener {
        @SubscribeEvent
        public static void onLivingUpdateEvent(LivingEvent.LivingTickEvent event) {
            Path path;
            DroneEntity drone;
            block8: {
                block7: {
                    LivingEntity livingEntity;
                    if (!((Boolean)ConfigHelper.common().drones.droneDebuggerPathParticles.get()).booleanValue() || !((livingEntity = event.getEntity()) instanceof DroneEntity)) break block7;
                    drone = (DroneEntity)livingEntity;
                    if (!event.getEntity().level().isClientSide) break block8;
                }
                return;
            }
            if (drone.getDebugger().debuggingPlayers.isEmpty()) {
                return;
            }
            PathNavigation navi = drone.getNavigation();
            if (drone.level() instanceof ServerLevel && drone.level().getGameTime() % 10L == 0L && (path = navi.getPath()) != null) {
                for (int i = path.getNextNodeIndex(); i < path.getNodeCount(); ++i) {
                    BlockPos pos = path.getNode(i).asBlockPos();
                    BlockPos nextPos = i + 1 != path.getNodeCount() ? path.getNode(i + 1).asBlockPos() : pos;
                    BlockPos endPos = nextPos.subtract((Vec3i)pos);
                    Listener.spawnParticle(drone.getDebugger().debuggingPlayers, ParticleTypes.HAPPY_VILLAGER, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 0, 0.0, 0.0, 0.0, 0.0);
                    Listener.spawnParticle(drone.getDebugger().debuggingPlayers, ParticleTypes.END_ROD, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 0, endPos.getX(), endPos.getY(), endPos.getZ(), 0.1);
                }
                BlockPos pos = navi.getTargetPos();
                if (pos != null && drone.getDronePos().distanceToSqr(Vec3.atCenterOf((Vec3i)pos)) > 1.0) {
                    Listener.spawnParticle(drone.getDebugger().debuggingPlayers, ParticleTypes.HEART, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 0, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }

        private static <T extends ParticleOptions> void spawnParticle(Set<ServerPlayer> players, T type, double posX, double posY, double posZ, int particleCount, double xOffset, double yOffset, double zOffset, double speed) {
            ClientboundLevelParticlesPacket packet = new ClientboundLevelParticlesPacket(type, false, posX, posY, posZ, (float)xOffset, (float)yOffset, (float)zOffset, (float)speed, particleCount);
            players.forEach(player -> player.connection.send((Packet)packet));
        }
    }
}

