/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone;

import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.common.entity.semiblock.AbstractLogisticsFrameEntity;
import me.desht.pneumaticcraft.common.semiblock.IProvidingInventoryListener;
import me.desht.pneumaticcraft.common.semiblock.ISpecificProvider;
import me.desht.pneumaticcraft.common.semiblock.ISpecificRequester;
import me.desht.pneumaticcraft.common.util.IOHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class LogisticsManager {
    private static final int N_PRIORITIES = 4;
    private final List<List<AbstractLogisticsFrameEntity>> logistics = new ArrayList<List<AbstractLogisticsFrameEntity>>();
    private boolean droneAccess;

    public LogisticsManager() {
        for (int i = 0; i < 4; ++i) {
            this.logistics.add(new ArrayList());
        }
    }

    public void addLogisticFrame(AbstractLogisticsFrameEntity frame) {
        this.logistics.get(frame.getPriority()).add(frame);
    }

    public PriorityQueue<LogisticsTask> getTasks(Object holdingStack, boolean droneAccess) {
        this.droneAccess = droneAccess;
        ItemStack item = holdingStack instanceof ItemStack ? (ItemStack)holdingStack : ItemStack.EMPTY;
        FluidStack fluid = holdingStack instanceof FluidStack ? (FluidStack)holdingStack : FluidStack.EMPTY;
        PriorityQueue<LogisticsTask> tasks = new PriorityQueue<LogisticsTask>();
        for (int priority = this.logistics.size() - 1; priority >= 0; --priority) {
            for (int requesterId = 0; requesterId < this.logistics.get(priority).size(); ++requesterId) {
                AbstractLogisticsFrameEntity requester = this.logistics.get(priority).get(requesterId);
                if (droneAccess && requester.isObstructed(PathComputationType.AIR)) continue;
                for (int i = 0; i < priority; ++i) {
                    for (int providerId = 0; providerId < this.logistics.get(i).size(); ++providerId) {
                        int requestedAmount;
                        AbstractLogisticsFrameEntity provider = this.logistics.get(i).get(providerId);
                        if (droneAccess && provider.isObstructed(PathComputationType.AIR) || !provider.shouldProvideTo(priority)) continue;
                        if (!item.isEmpty()) {
                            requestedAmount = LogisticsManager.getRequestedAmount(requester, item, false);
                            if (requestedAmount > 0) {
                                ItemStack stack = item.copy();
                                stack.setCount(requestedAmount);
                                tasks.add(new LogisticsTask(provider, requester, stack));
                                return tasks;
                            }
                        } else if (!fluid.isEmpty() && (requestedAmount = LogisticsManager.getRequestedAmount(requester, fluid, false)) > 0) {
                            fluid = fluid.copy();
                            fluid.setAmount(requestedAmount);
                            tasks.add(new LogisticsTask(provider, requester, fluid));
                            return tasks;
                        }
                        this.tryProvide(provider, requester, tasks, item.isEmpty(), fluid.isEmpty());
                        if (tasks.isEmpty()) continue;
                        if (this.logistics.get(priority).size() > 1) {
                            this.logistics.get(priority).add(this.logistics.get(priority).remove(requesterId));
                        }
                        if (this.logistics.get(i).size() > 1) {
                            this.logistics.get(i).add(this.logistics.get(i).remove(providerId));
                        }
                        return tasks;
                    }
                }
            }
        }
        return tasks;
    }

    private void tryProvide(AbstractLogisticsFrameEntity provider, AbstractLogisticsFrameEntity requester, PriorityQueue<LogisticsTask> tasks, boolean tryItems, boolean tryFluids) {
        if (provider.getCachedTileEntity() == null) {
            return;
        }
        if (tryItems) {
            IOHelper.getInventoryForBlock(provider.getCachedTileEntity(), provider.getSide()).ifPresent(itemHandler -> {
                if (requester instanceof IProvidingInventoryListener) {
                    ((IProvidingInventoryListener)((Object)requester)).notify(new IProvidingInventoryListener.TileEntityAndFace(provider.getCachedTileEntity(), provider.getSide()));
                }
                for (int i = 0; i < itemHandler.getSlots(); ++i) {
                    int requestedAmount;
                    ItemStack providingStack = itemHandler.extractItem(i, 64, true);
                    if (providingStack.isEmpty() || provider instanceof ISpecificProvider && !((ISpecificProvider)((Object)provider)).canProvide(providingStack) || (requestedAmount = LogisticsManager.getRequestedAmount(requester, providingStack, true)) <= 0) continue;
                    ItemStack stack = providingStack.copy();
                    stack.setCount(requestedAmount);
                    tasks.add(new LogisticsTask(provider, requester, stack));
                    if (!this.droneAccess) continue;
                    return;
                }
            });
        }
        if (tryFluids) {
            IOHelper.getFluidHandlerForBlock(provider.getCachedTileEntity(), provider.getSide()).ifPresent(fluidHandler -> {
                int requestedAmount;
                boolean canDrain;
                FluidStack providingStack = fluidHandler.drain(16000, IFluidHandler.FluidAction.SIMULATE);
                if (!providingStack.isEmpty() && (canDrain = IntStream.range(0, fluidHandler.getTanks()).anyMatch(i -> fluidHandler.isFluidValid(i, providingStack))) && (!(provider instanceof ISpecificProvider) || ((ISpecificProvider)((Object)provider)).canProvide(providingStack)) && (requestedAmount = LogisticsManager.getRequestedAmount(requester, providingStack, true)) > 0) {
                    FluidStack stack = providingStack.copy();
                    stack.setAmount(requestedAmount);
                    tasks.add(new LogisticsTask(provider, requester, stack));
                }
            });
        }
    }

    private static int getRequestedAmount(AbstractLogisticsFrameEntity requester, ItemStack providingStack, boolean honourMin) {
        int minOrderSize;
        BlockEntity te = requester.getCachedTileEntity();
        if (te == null) {
            return 0;
        }
        int requestedAmount = requester instanceof ISpecificRequester ? ((ISpecificRequester)((Object)requester)).amountRequested(providingStack) : providingStack.getMaxStackSize();
        int n = minOrderSize = honourMin && requester instanceof ISpecificRequester ? ((ISpecificRequester)((Object)requester)).getMinItemOrderSize() : 1;
        if (requestedAmount < minOrderSize) {
            return 0;
        }
        if (requestedAmount < (providingStack = providingStack.copy()).getCount()) {
            providingStack.setCount(requestedAmount);
        }
        ItemStack remainder = providingStack.copy();
        remainder.grow(requester.getIncomingItems(providingStack));
        remainder = IOHelper.insert(te, remainder, requester.getSide(), true);
        providingStack.shrink(remainder.getCount());
        return providingStack.getCount() < minOrderSize ? 0 : Math.max(providingStack.getCount(), 0);
    }

    private static int getRequestedAmount(AbstractLogisticsFrameEntity requester, FluidStack providingStack, boolean honourMin) {
        int minOrderSize;
        BlockEntity te = requester.getCachedTileEntity();
        if (te == null) {
            return 0;
        }
        int requestedAmount = requester instanceof ISpecificRequester ? ((ISpecificRequester)((Object)requester)).amountRequested(providingStack) : providingStack.getAmount();
        int n = minOrderSize = honourMin && requester instanceof ISpecificRequester ? ((ISpecificRequester)((Object)requester)).getMinFluidOrderSize() : 1;
        if (requestedAmount < minOrderSize) {
            return 0;
        }
        if (requestedAmount < (providingStack = providingStack.copy()).getAmount()) {
            providingStack.setAmount(requestedAmount);
        }
        FluidStack remainder = providingStack.copy();
        remainder.grow(requester.getIncomingFluid(remainder.getFluid()));
        IOHelper.getFluidHandlerForBlock(te, requester.getSide()).ifPresent(fluidHandler -> {
            int fluidFilled = fluidHandler.fill(remainder, IFluidHandler.FluidAction.SIMULATE);
            if (fluidFilled > 0) {
                remainder.shrink(fluidFilled);
            }
        });
        providingStack.shrink(remainder.getAmount());
        return providingStack.getAmount() < minOrderSize ? 0 : providingStack.getAmount();
    }

    public static class LogisticsTask
    implements Comparable<LogisticsTask> {
        public final AbstractLogisticsFrameEntity provider;
        public final AbstractLogisticsFrameEntity requester;
        public final ItemStack transportingItem;
        public final FluidStack transportingFluid;

        LogisticsTask(AbstractLogisticsFrameEntity provider, AbstractLogisticsFrameEntity requester, @Nonnull ItemStack transportingItem) {
            this.provider = provider;
            this.requester = requester;
            this.transportingItem = transportingItem;
            this.transportingFluid = FluidStack.EMPTY;
        }

        LogisticsTask(AbstractLogisticsFrameEntity provider, AbstractLogisticsFrameEntity requester, FluidStack transportingFluid) {
            this.provider = provider;
            this.requester = requester;
            this.transportingItem = ItemStack.EMPTY;
            this.transportingFluid = transportingFluid;
        }

        public void informRequester() {
            if (!this.transportingItem.isEmpty()) {
                this.requester.informIncomingStack(this.transportingItem);
            } else {
                this.requester.informIncomingStack(this.transportingFluid);
            }
        }

        public boolean isStillValid(Object stack) {
            if (stack instanceof ItemStack) {
                if (!this.transportingItem.isEmpty()) {
                    int requestedAmount = LogisticsManager.getRequestedAmount(this.requester, (ItemStack)stack, false);
                    return requestedAmount == ((ItemStack)stack).getCount();
                }
            } else if (stack instanceof FluidStack) {
                if (!this.transportingFluid.isEmpty()) {
                    int requestedAmount = LogisticsManager.getRequestedAmount(this.requester, (FluidStack)stack, false);
                    return requestedAmount == ((FluidStack)stack).getAmount();
                }
            } else {
                throw new IllegalArgumentException("arg must be ItemStack or FluidStack! " + stack);
            }
            return false;
        }

        @Override
        public int compareTo(LogisticsTask task) {
            int value = !this.transportingItem.isEmpty() ? this.transportingItem.getCount() * 100 : this.transportingFluid.getAmount();
            int otherValue = !task.transportingItem.isEmpty() ? task.transportingItem.getCount() * 100 : task.transportingFluid.getAmount();
            return otherValue - value;
        }
    }
}

