/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.ai;

import java.util.Comparator;
import me.desht.pneumaticcraft.common.drone.IDroneBase;
import me.desht.pneumaticcraft.common.drone.progwidgets.IBlockOrdered;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.Vec3;

public class ChunkPositionSorter
implements Comparator<BlockPos> {
    private static final double EPSILON = 0.01;
    private final double x;
    private final double y;
    private final double z;
    private final IBlockOrdered.Ordering order;

    ChunkPositionSorter(IDroneBase entity) {
        this(entity, IBlockOrdered.Ordering.CLOSEST);
    }

    ChunkPositionSorter(IDroneBase entity, IBlockOrdered.Ordering order) {
        Vec3 vec = entity.getDronePos();
        this.x = Math.floor(vec.x) + 0.5;
        this.y = Math.floor(vec.y) + 0.5;
        this.z = Math.floor(vec.z) + 0.5;
        this.order = order;
    }

    public ChunkPositionSorter(double x, double y, double z, IBlockOrdered.Ordering order) {
        this.order = order;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Override
    public int compare(BlockPos c1, BlockPos c2) {
        if (this.order != IBlockOrdered.Ordering.CLOSEST && c1.getY() != c2.getY()) {
            return this.order == IBlockOrdered.Ordering.HIGH_TO_LOW ? c2.getY() - c1.getY() : c1.getY() - c2.getY();
        }
        double d = PneumaticCraftUtils.distBetweenSq(c1.getX(), c1.getY(), c1.getZ(), this.x, this.y, this.z) - PneumaticCraftUtils.distBetweenSq(c2.getX(), c2.getY(), c2.getZ(), this.x, this.y, this.z);
        if (Math.abs(d) < 0.01) {
            return c1.compareTo((Vec3i)c2);
        }
        return d < 0.0 ? -1 : 1;
    }
}

