/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.ai;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.desht.pneumaticcraft.common.drone.IDroneBase;
import me.desht.pneumaticcraft.common.drone.progwidgets.ICraftingWidget;
import me.desht.pneumaticcraft.common.util.DummyContainer;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.ItemTagMatcher;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.player.PlayerDestroyItemEvent;
import net.neoforged.neoforge.items.IItemHandler;

public class DroneAICrafting
extends Goal {
    private final ICraftingWidget widget;
    private final IDroneBase drone;
    private final int maxActions;
    private int actionCount;

    public DroneAICrafting(IDroneBase drone, ICraftingWidget widget) {
        this.drone = drone;
        this.widget = widget;
        this.maxActions = widget.useCount() ? widget.getCount() : 0;
        this.actionCount = 0;
    }

    public boolean canUse() {
        if (this.maxActions > 0 && this.actionCount >= this.maxActions) {
            return false;
        }
        CraftingContainer craftingGrid = this.widget.getCraftingGrid();
        return this.widget.getRecipe(this.drone.world(), craftingGrid).map(recipe -> {
            List<List<ItemStack>> equivalentsList = this.buildEquivalentsList(craftingGrid);
            if (equivalentsList.isEmpty()) {
                return false;
            }
            int[] equivIndices = new int[9];
            TransientCraftingContainer craftMatrix = new TransientCraftingContainer((AbstractContainerMenu)new DummyContainer(), 3, 3);
            do {
                for (int i = 0; i < equivalentsList.size(); ++i) {
                    ItemStack stack = equivalentsList.get(i).isEmpty() ? ItemStack.EMPTY : equivalentsList.get(i).get(equivIndices[i]);
                    craftMatrix.setItem(i, stack);
                }
                if (!recipe.matches((Container)craftMatrix, this.drone.world()) || !this.doCrafting(recipe.assemble((Container)craftMatrix, this.drone.world().registryAccess()), (CraftingContainer)craftMatrix)) continue;
                ++this.actionCount;
                return true;
            } while (this.count(equivIndices, equivalentsList));
            return false;
        }).orElse(false);
    }

    private List<List<ItemStack>> buildEquivalentsList(CraftingContainer craftingGrid) {
        ArrayList<List<ItemStack>> equivalentsList = new ArrayList<List<ItemStack>>();
        for (int i = 0; i < craftingGrid.getContainerSize(); ++i) {
            equivalentsList.add(new ArrayList());
            ItemStack recipeStack = craftingGrid.getItem(i);
            if (recipeStack.isEmpty()) continue;
            ArrayList<ItemStack> equivalents = new ArrayList<ItemStack>();
            for (int j = 0; j < this.drone.getInv().getSlots(); ++j) {
                ItemStack droneStack = this.drone.getInv().getStackInSlot(j);
                if (droneStack.isEmpty() || droneStack.getItem() != recipeStack.getItem() && !ItemTagMatcher.matchTags(droneStack, recipeStack)) continue;
                equivalents.add(droneStack);
            }
            if (equivalents.isEmpty()) {
                return Collections.emptyList();
            }
            ((List)equivalentsList.get(i)).addAll(equivalents);
        }
        return equivalentsList;
    }

    private boolean count(int[] curIndexes, List<List<ItemStack>> equivalentsList) {
        for (int i = 0; i < equivalentsList.size(); ++i) {
            List<ItemStack> list = equivalentsList.get(i);
            int n = i;
            curIndexes[n] = curIndexes[n] + 1;
            if (!list.isEmpty() && curIndexes[i] < list.size()) {
                return true;
            }
            curIndexes[i] = 0;
        }
        return false;
    }

    public boolean doCrafting(ItemStack craftedStack, CraftingContainer craftMatrix) {
        int i;
        for (i = 0; i < craftMatrix.getContainerSize(); ++i) {
            int requiredCount = 0;
            ItemStack stack = craftMatrix.getItem(i);
            if (stack.isEmpty()) continue;
            for (int j = 0; j < craftMatrix.getContainerSize(); ++j) {
                if (stack != craftMatrix.getItem(j)) continue;
                ++requiredCount;
            }
            if (requiredCount <= stack.getCount()) continue;
            return false;
        }
        EventHooks.firePlayerCraftingEvent((Player)this.drone.getFakePlayer(), (ItemStack)craftedStack, (Container)craftMatrix);
        for (i = 0; i < craftMatrix.getContainerSize(); ++i) {
            ItemStack stack = craftMatrix.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.getItem().hasCraftingRemainingItem(stack)) {
                ItemStack containerItem = stack.getItem().getCraftingRemainingItem(stack);
                if (!containerItem.isEmpty() && containerItem.isDamageableItem() && containerItem.getDamageValue() > containerItem.getMaxDamage()) {
                    NeoForge.EVENT_BUS.post((Event)new PlayerDestroyItemEvent((Player)this.drone.getFakePlayer(), containerItem, InteractionHand.MAIN_HAND));
                    continue;
                }
                IOHelper.insertOrDrop(this.drone.world(), containerItem, (IItemHandler)this.drone.getInv(), this.drone.getDronePos(), false);
            }
            stack.shrink(1);
        }
        for (i = 0; i < this.drone.getInv().getSlots(); ++i) {
            ItemStack stack = this.drone.getInv().getStackInSlot(i);
            if (stack.getCount() > 0) continue;
            this.drone.getInv().setStackInSlot(i, ItemStack.EMPTY);
        }
        IOHelper.insertOrDrop(this.drone.world(), craftedStack, (IItemHandler)this.drone.getInv(), this.drone.getDronePos(), false);
        return true;
    }
}

