/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.ai;

import java.util.List;
import me.desht.pneumaticcraft.common.drone.IDroneBase;
import me.desht.pneumaticcraft.common.drone.ai.DroneAIBlockInteraction;
import me.desht.pneumaticcraft.common.drone.progwidgets.IToolUser;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetAreaItemBase;
import me.desht.pneumaticcraft.common.entity.drone.DroneEntity;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.mixin.accessors.ServerPlayerGameModeAccess;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class DroneAIDig<W extends ProgWidgetAreaItemBase>
extends DroneAIBlockInteraction<W> {
    public DroneAIDig(IDroneBase drone, W widget) {
        super(drone, widget);
    }

    @Override
    protected boolean isValidPosition(BlockPos pos) {
        BlockState blockState = this.worldCache.getBlockState(pos);
        if (!DroneAIDig.ignoreBlock(blockState) && !pos.equals((Object)this.drone.getControllerPos())) {
            List<ItemStack> drops = DroneAIDig.getDrops((BlockGetter)this.worldCache, pos, this.drone);
            if (drops.isEmpty()) {
                return this.progWidget.isItemValidForFilters(ItemStack.EMPTY, blockState) && (this.swapBestItemToFirstSlot(pos) || !((IToolUser)((Object)this.progWidget)).requiresTool());
            }
            for (ItemStack droppedStack : drops) {
                if (!this.progWidget.isItemValidForFilters(droppedStack, blockState)) continue;
                return this.swapBestItemToFirstSlot(pos) || !((IToolUser)((Object)this.progWidget)).requiresTool();
            }
        }
        return false;
    }

    @Override
    protected boolean respectClaims() {
        return true;
    }

    private boolean swapBestItemToFirstSlot(BlockPos pos) {
        ItemStack currentStackSaved = this.drone.getInv().getStackInSlot(0).copy();
        this.drone.getInv().setStackInSlot(0, ItemStack.EMPTY);
        float baseSoftness = this.worldCache.getBlockState(pos).getDestroyProgress((Player)this.drone.getFakePlayer(), (BlockGetter)this.drone.world(), pos);
        this.drone.getInv().setStackInSlot(0, currentStackSaved);
        boolean hasDiggingTool = false;
        int bestSlot = 0;
        float bestSoftness = Float.MIN_VALUE;
        BlockState state = this.worldCache.getBlockState(pos);
        for (int i = 0; i < this.drone.getInv().getSlots(); ++i) {
            this.drone.getInv().setStackInSlot(0, this.drone.getInv().getStackInSlot(i));
            float softness = state.getDestroyProgress((Player)this.drone.getFakePlayer(), (BlockGetter)this.drone.world(), pos);
            if (!(softness > bestSoftness)) continue;
            bestSlot = i;
            bestSoftness = softness;
            if (!(softness > baseSoftness)) continue;
            hasDiggingTool = true;
        }
        this.drone.getInv().setStackInSlot(0, currentStackSaved);
        if (bestSlot != 0) {
            ItemStack bestItem = this.drone.getInv().getStackInSlot(bestSlot).copy();
            this.drone.getInv().setStackInSlot(bestSlot, this.drone.getInv().getStackInSlot(0));
            this.drone.getInv().setStackInSlot(0, bestItem);
        }
        return hasDiggingTool || !state.requiresCorrectToolForDrops();
    }

    @Override
    protected boolean doBlockInteraction(BlockPos pos, double squareDistToBlock) {
        ServerPlayerGameMode manager = this.drone.getFakePlayer().gameMode;
        ServerPlayerGameModeAccess access = (ServerPlayerGameModeAccess)manager;
        if (!access.isDestroyingBlock() || !access.hasDelayedDestroy()) {
            BlockState blockState = this.worldCache.getBlockState(pos);
            if (!DroneAIDig.ignoreBlock(blockState) && DroneAIDig.isBlockValidForFilter((BlockGetter)this.worldCache, pos, this.drone, this.progWidget)) {
                if (blockState.getDestroySpeed((BlockGetter)this.drone.world(), pos) < 0.0f) {
                    this.addToBlacklist(pos);
                    this.drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.dig.debug.cantDigBlock", pos);
                    this.drone.setDugBlock(null);
                    return false;
                }
                PlayerInteractEvent.LeftClickBlock event = CommonHooks.onLeftClickBlock((Player)this.drone.getFakePlayer(), (BlockPos)pos, (Direction)Direction.UP, (ServerboundPlayerActionPacket.Action)ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK);
                if (!event.isCanceled()) {
                    int limit = this.drone.world().getMaxBuildHeight();
                    manager.handleBlockBreakAction(pos, ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK, Direction.DOWN, limit, 0);
                    manager.handleBlockBreakAction(pos, ServerboundPlayerActionPacket.Action.STOP_DESTROY_BLOCK, Direction.DOWN, limit, 1);
                    this.drone.setDugBlock(pos);
                    return true;
                }
            }
            this.drone.setDugBlock(null);
            return false;
        }
        return true;
    }

    public static boolean isBlockValidForFilter(BlockGetter worldCache, BlockPos pos, IDroneBase drone, ProgWidgetAreaItemBase widget) {
        BlockState blockState = worldCache.getBlockState(pos);
        if (!blockState.isAir()) {
            for (ItemStack droppedStack : DroneAIDig.getDrops(worldCache, pos, drone)) {
                if (!widget.isItemValidForFilters(droppedStack, blockState)) continue;
                return true;
            }
            return widget.isItemValidForFilters(ItemStack.EMPTY, blockState);
        }
        return false;
    }

    private static List<ItemStack> getDrops(BlockGetter worldCache, BlockPos pos, IDroneBase drone) {
        BlockState state = worldCache.getBlockState(pos);
        DroneEntity d = drone instanceof DroneEntity ? (DroneEntity)drone : null;
        return state.getDrops(new LootParams.Builder((ServerLevel)drone.world()).withParameter(LootContextParams.BLOCK_STATE, (Object)state).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)pos)).withParameter(LootContextParams.TOOL, (Object)drone.getInv().getStackInSlot(0)).withOptionalParameter(LootContextParams.THIS_ENTITY, (Object)d).withOptionalParameter(LootContextParams.BLOCK_ENTITY, (Object)worldCache.getBlockEntity(pos)));
    }

    private static boolean ignoreBlock(BlockState state) {
        return state.isAir() || PneumaticCraftUtils.isBlockLiquid(state.getBlock());
    }
}

