/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.ai;

import me.desht.pneumaticcraft.common.drone.IDroneBase;
import me.desht.pneumaticcraft.common.drone.ai.DroneAIImExBase;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetInventoryBase;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.IOHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;

public class DroneAIEnergyExport
extends DroneAIImExBase<ProgWidgetInventoryBase> {
    public DroneAIEnergyExport(IDroneBase drone, ProgWidgetInventoryBase widget) {
        super(drone, widget);
    }

    @Override
    protected boolean doBlockInteraction(BlockPos pos, double squareDistToBlock) {
        return this.exportEnergy(pos, false) && super.doBlockInteraction(pos, squareDistToBlock);
    }

    @Override
    protected boolean isValidPosition(BlockPos pos) {
        return this.exportEnergy(pos, true);
    }

    private boolean exportEnergy(BlockPos pos, boolean simulate) {
        boolean didWork = false;
        int energy = this.drone.getEnergyStorage().getEnergyStored();
        if (energy == 0) {
            this.abort();
        } else {
            BlockEntity te = this.drone.world().getBlockEntity(pos);
            if (te != null) {
                Direction face;
                Direction[] directionArray = DirectionUtil.VALUES;
                int n = directionArray.length;
                for (int i = 0; !(i >= n || ((ProgWidgetInventoryBase)this.progWidget).isSideSelected(face = directionArray[i]) && (didWork = this.tryExportToSide(te, face, simulate))); ++i) {
                }
            }
        }
        return didWork;
    }

    private boolean tryExportToSide(BlockEntity te, Direction face, boolean simulate) {
        return IOHelper.getEnergyStorageForBlock(te, face).map(tileHandler -> {
            int receivable = tileHandler.receiveEnergy(((ProgWidgetInventoryBase)this.progWidget).useCount() ? this.getRemainingCount() : Integer.MAX_VALUE, true);
            int toTransfer = this.extractFromDrone(receivable, true);
            if (toTransfer > 0) {
                if (!simulate) {
                    this.decreaseCount(toTransfer);
                    this.extractFromDrone(toTransfer, false);
                    tileHandler.receiveEnergy(toTransfer, false);
                }
                return true;
            }
            return false;
        }).orElse(false);
    }

    private int extractFromDrone(int maxEnergy, boolean simulate) {
        return this.drone.getEnergyStorage().extractEnergy(maxEnergy, simulate);
    }
}

