/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.ai;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import me.desht.pneumaticcraft.api.harvesting.HarvestHandler;
import me.desht.pneumaticcraft.api.harvesting.HoeHandler;
import me.desht.pneumaticcraft.common.drone.IDroneBase;
import me.desht.pneumaticcraft.common.drone.ai.DroneAIBlockInteraction;
import me.desht.pneumaticcraft.common.drone.progwidgets.IToolUser;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetAreaItemBase;
import me.desht.pneumaticcraft.common.registry.ModHarvestHandlers;
import me.desht.pneumaticcraft.common.registry.ModHoeHandlers;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;

public class DroneAIHarvest<W extends ProgWidgetAreaItemBase>
extends DroneAIBlockInteraction<W> {
    public DroneAIHarvest(IDroneBase drone, W widget) {
        super(drone, widget);
    }

    @Override
    public boolean canUse() {
        if (this.abortIfRequiredHoeIsMissing()) {
            return false;
        }
        return super.canUse();
    }

    @Override
    protected boolean isValidPosition(BlockPos pos) {
        if (this.abortIfRequiredHoeIsMissing()) {
            return false;
        }
        return this.getApplicableHandler(pos).isPresent();
    }

    private boolean abortIfRequiredHoeIsMissing() {
        if (((IToolUser)((Object)this.progWidget)).requiresTool() && this.getDamageableHoe() == null) {
            this.abort();
            this.drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.harvest.debug.missingHoe");
            return true;
        }
        return false;
    }

    private Optional<HarvestHandler> getApplicableHandler(BlockPos pos) {
        BlockState state = this.worldCache.getBlockState(pos);
        return ModHarvestHandlers.HARVEST_HANDLER_REGISTRY.stream().filter(handler -> handler.canHarvest(this.drone.world(), (BlockGetter)this.worldCache, pos, state, this.drone) && this.hasApplicableItemFilters((HarvestHandler)handler, pos, state)).findFirst();
    }

    private boolean hasApplicableItemFilters(HarvestHandler harvestHandler, BlockPos pos, BlockState blockState) {
        List<ItemStack> droppedStacks = harvestHandler.addFilterItems(this.drone.world(), (BlockGetter)this.worldCache, pos, blockState, this.drone);
        return droppedStacks.stream().anyMatch(droppedStack -> this.progWidget.isItemValidForFilters((ItemStack)droppedStack, blockState));
    }

    @Override
    protected boolean respectClaims() {
        return true;
    }

    @Override
    protected boolean doBlockInteraction(BlockPos pos, double squareDistToBlock) {
        this.getApplicableHandler(pos).ifPresent(applicableHandler -> {
            BlockState state = this.worldCache.getBlockState(pos);
            if (applicableHandler.canHarvest(this.drone.world(), (BlockGetter)this.worldCache, pos, state, this.drone)) {
                Consumer<Player> damageableHoe = this.getDamageableHoe();
                if (damageableHoe != null) {
                    if (applicableHandler.harvestAndReplant(this.drone.world(), (BlockGetter)this.worldCache, pos, state, this.drone)) {
                        damageableHoe.accept((Player)this.drone.getFakePlayer());
                    }
                } else {
                    applicableHandler.harvest(this.drone.world(), (BlockGetter)this.worldCache, pos, state, this.drone);
                }
            }
        });
        return false;
    }

    private Consumer<Player> getDamageableHoe() {
        for (int i = 0; i < this.drone.getInv().getSlots(); ++i) {
            ItemStack stack = this.drone.getInv().getStackInSlot(i);
            HoeHandler handler = ModHoeHandlers.HOE_HANDLER_REGISTRY.stream().filter(hoeHandler -> hoeHandler.test(stack)).findFirst().orElse(null);
            if (handler == null) continue;
            return handler.getConsumer(stack);
        }
        return null;
    }
}

