/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.ai;

import me.desht.pneumaticcraft.common.drone.IDroneBase;
import me.desht.pneumaticcraft.common.drone.ai.DroneAIImExBase;
import me.desht.pneumaticcraft.common.drone.progwidgets.ICountWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ILiquidExport;
import me.desht.pneumaticcraft.common.drone.progwidgets.ILiquidFiltered;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetInventoryBase;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.FluidUtils;
import me.desht.pneumaticcraft.common.util.IOHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class DroneAILiquidExport<W extends ProgWidgetInventoryBase & ILiquidExport>
extends DroneAIImExBase<W> {
    public DroneAILiquidExport(IDroneBase drone, W widget) {
        super(drone, widget);
    }

    @Override
    protected boolean isValidPosition(BlockPos pos) {
        return this.fillTank(pos, true);
    }

    @Override
    protected boolean doBlockInteraction(BlockPos pos, double squareDistToBlock) {
        return this.fillTank(pos, false) && super.doBlockInteraction(pos, squareDistToBlock);
    }

    private boolean fillTank(BlockPos pos, boolean simulate) {
        if (this.drone.getFluidTank().getFluidAmount() == 0) {
            this.drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.liquidExport.debug.emptyDroneTank");
            this.abort();
            return false;
        }
        BlockEntity te = this.drone.world().getBlockEntity(pos);
        if (te != null) {
            FluidStack exportedFluid = this.drone.getFluidTank().drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
            if (!exportedFluid.isEmpty() && ((ILiquidFiltered)((Object)((ProgWidgetInventoryBase)this.progWidget))).isFluidValid(exportedFluid.getFluid())) {
                FillStatus status = FillStatus.NO_HANDLER;
                for (Direction side : DirectionUtil.VALUES) {
                    if (!((ProgWidgetInventoryBase)this.progWidget).isSideSelected(side) || (status = this.trySide(te, side, exportedFluid, simulate)) != FillStatus.OK) continue;
                    return true;
                }
                if (status == FillStatus.NO_SPACE) {
                    this.drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.liquidExport.debug.filledToMax", pos);
                    return false;
                }
            } else {
                this.drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.liquidExport.debug.noValidFluid");
                return false;
            }
        }
        if (((ILiquidExport)((Object)((ProgWidgetInventoryBase)this.progWidget))).isPlacingFluidBlocks() && (!((ProgWidgetInventoryBase)this.progWidget).useCount() || this.getRemainingCount() >= 1000) && FluidUtils.tryPourOutFluid((IFluidHandler)this.drone.getFluidTank(), this.drone.world(), pos, false, false, simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE)) {
            if (!simulate) {
                this.decreaseCount(1000);
            }
            return true;
        }
        return false;
    }

    private FillStatus trySide(BlockEntity te, Direction side, FluidStack fluidToExport, boolean simulate) {
        return IOHelper.getFluidHandlerForBlock(te, side).map(fluidHandler -> {
            int filledAmount = fluidHandler.fill(fluidToExport, IFluidHandler.FluidAction.SIMULATE);
            if (filledAmount > 0) {
                if (((ICountWidget)((Object)this.progWidget)).useCount()) {
                    filledAmount = Math.min(filledAmount, this.getRemainingCount());
                }
                if (!simulate) {
                    this.decreaseCount(fluidHandler.fill(this.drone.getFluidTank().drain(filledAmount, IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE));
                }
                return FillStatus.OK;
            }
            return FillStatus.NO_SPACE;
        }).orElse(FillStatus.NO_HANDLER);
    }

    private static enum FillStatus {
        OK,
        NO_HANDLER,
        NO_SPACE;

    }
}

