/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.ai;

import me.desht.pneumaticcraft.common.drone.IDroneBase;
import me.desht.pneumaticcraft.common.drone.ai.DroneAIImExBase;
import me.desht.pneumaticcraft.common.drone.progwidgets.ILiquidFiltered;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetInventoryBase;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetLiquidImport;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.IOHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class DroneAILiquidImport<W extends ProgWidgetInventoryBase>
extends DroneAIImExBase<W> {
    public DroneAILiquidImport(IDroneBase drone, W widget) {
        super(drone, widget);
    }

    @Override
    protected boolean isValidPosition(BlockPos pos) {
        return this.emptyTank(pos, true);
    }

    @Override
    protected boolean doBlockInteraction(BlockPos pos, double squareDistToBlock) {
        return this.emptyTank(pos, false) && super.doBlockInteraction(pos, squareDistToBlock);
    }

    private boolean shouldVoidExcess() {
        return this.progWidget instanceof ProgWidgetLiquidImport && ((ProgWidgetLiquidImport)this.progWidget).shouldVoidExcess();
    }

    private boolean emptyTank(BlockPos pos, boolean simulate) {
        if (!this.shouldVoidExcess() && this.drone.getFluidTank().getFluidAmount() == this.drone.getFluidTank().getCapacity()) {
            this.drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.liquidImport.debug.fullDroneTank");
            this.abort();
            return false;
        }
        BlockEntity te = this.drone.world().getBlockEntity(pos);
        if (te != null) {
            Direction side;
            boolean didWork = false;
            Direction[] directionArray = DirectionUtil.VALUES;
            int n = directionArray.length;
            for (int i = 0; !(i >= n || ((ProgWidgetInventoryBase)this.progWidget).isSideSelected(side = directionArray[i]) && (didWork = IOHelper.getFluidHandlerForBlock(te, side).map(handler -> this.tryImportFluid((IFluidHandler)handler, simulate)).orElse(false).booleanValue())); ++i) {
            }
            if (didWork) {
                return true;
            }
            this.drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.liquidImport.debug.emptiedToMax", pos);
        }
        if (!((ProgWidgetInventoryBase)this.progWidget).useCount() || this.getRemainingCount() >= 1000) {
            FluidState state = this.drone.world().getFluidState(pos);
            BlockState blockState = this.drone.world().getBlockState(pos);
            if (state.isSource() && ((ILiquidFiltered)((Object)((ProgWidgetInventoryBase)this.progWidget))).isFluidValid(state.getType())) {
                Block block;
                FluidStack stack = new FluidStack(state.getType(), 1000);
                if ((this.shouldVoidExcess() || this.drone.getFluidTank().fill(stack, IFluidHandler.FluidAction.SIMULATE) == 1000) && !simulate && (block = blockState.getBlock()) instanceof BucketPickup) {
                    BucketPickup pickup = (BucketPickup)block;
                    pickup.pickupBlock((Player)this.drone.getFakePlayer(), (LevelAccessor)this.drone.world(), pos, blockState);
                    this.decreaseCount(1000);
                    this.drone.getFluidTank().fill(stack, IFluidHandler.FluidAction.EXECUTE);
                    return true;
                }
                return true;
            }
        }
        return false;
    }

    private boolean tryImportFluid(IFluidHandler sourceHandler, boolean simulate) {
        FluidStack importedFluid = sourceHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
        if (!importedFluid.isEmpty() && ((ILiquidFiltered)((Object)((ProgWidgetInventoryBase)this.progWidget))).isFluidValid(importedFluid.getFluid())) {
            int filledAmount = this.drone.getFluidTank().fill(importedFluid, IFluidHandler.FluidAction.SIMULATE);
            if (filledAmount > 0) {
                if (((ProgWidgetInventoryBase)this.progWidget).useCount()) {
                    filledAmount = Math.min(filledAmount, this.getRemainingCount());
                }
                if (!simulate) {
                    this.decreaseCount(this.drone.getFluidTank().fill(sourceHandler.drain(filledAmount, IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE));
                }
                return true;
            }
            return this.shouldVoidExcess();
        }
        return false;
    }
}

