/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.ai;

import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.common.drone.IDroneBase;
import me.desht.pneumaticcraft.common.drone.ai.DroneAIBlockInteraction;
import me.desht.pneumaticcraft.common.drone.ai.DroneAIDig;
import me.desht.pneumaticcraft.common.drone.progwidgets.IBlockRightClicker;
import me.desht.pneumaticcraft.common.drone.progwidgets.ISidedWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetAreaItemBase;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CommandBlock;
import net.minecraft.world.level.block.StructureBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class DroneAIRightClickBlock
extends DroneAIBlockInteraction<ProgWidgetAreaItemBase> {
    private final List<BlockPos> visitedPositions = new ArrayList<BlockPos>();
    private final IBlockRightClicker.RightClickType clickType;

    public DroneAIRightClickBlock(IDroneBase drone, ProgWidgetAreaItemBase widget) {
        super(drone, widget);
        if (!(widget instanceof IBlockRightClicker)) {
            throw new IllegalArgumentException("expecting a widget implementing IBlockRightClicker!");
        }
        IBlockRightClicker rc = (IBlockRightClicker)((Object)widget);
        drone.getFakePlayer().setShiftKeyDown(rc.isSneaking());
        this.clickType = rc.getClickType();
    }

    @Override
    protected boolean isValidPosition(BlockPos pos) {
        if (this.visitedPositions.contains(pos)) {
            return false;
        }
        if (this.progWidget.isItemFilterEmpty()) {
            return true;
        }
        switch (this.clickType) {
            case CLICK_ITEM: {
                for (int i = 0; i < this.drone.getInv().getSlots(); ++i) {
                    if (!this.progWidget.isItemValidForFilters(this.drone.getInv().getStackInSlot(i))) continue;
                    return true;
                }
                return false;
            }
            case CLICK_BLOCK: {
                return DroneAIDig.isBlockValidForFilter((BlockGetter)this.drone.world(), pos, this.drone, this.progWidget);
            }
        }
        return false;
    }

    @Override
    protected boolean doBlockInteraction(BlockPos pos, double squareDistToBlock) {
        this.visitedPositions.add(pos);
        if (this.rightClick(pos)) {
            if (this.drone.getFakePlayer().getMainHandItem().getCount() <= 0) {
                this.drone.getFakePlayer().setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
            }
            this.drone.getInv().setStackInSlot(0, this.drone.getFakePlayer().getMainHandItem());
            this.drone.getDroneItemHandler().copyFromFakePlayer();
        }
        return false;
    }

    private boolean rightClick(BlockPos pos) {
        if (this.clickType == IBlockRightClicker.RightClickType.CLICK_ITEM) {
            return this.rightClickItem(this.drone.getFakePlayer(), pos);
        }
        return this.rightClickBlock(this.drone.getFakePlayer(), pos);
    }

    private boolean rightClickItem(FakePlayer fakePlayer, BlockPos pos) {
        if (!this.progWidget.isItemValidForFilters(this.drone.getInv().getStackInSlot(0)) && !this.trySwapItem()) {
            return false;
        }
        ItemStack stack = fakePlayer.getMainHandItem();
        Level world = fakePlayer.getCommandSenderWorld();
        try {
            Block block;
            BlockHitResult brtr = this.doTrace(world, pos, fakePlayer);
            if (brtr == null) {
                return false;
            }
            PlayerInteractEvent.RightClickBlock event = CommonHooks.onRightClickBlock((Player)fakePlayer, (InteractionHand)InteractionHand.MAIN_HAND, (BlockPos)pos, (BlockHitResult)brtr);
            if (event.isCanceled() || event.getUseItem() == Event.Result.DENY) {
                return false;
            }
            InteractionResult ret = stack.onItemUseFirst(new UseOnContext((Player)fakePlayer, InteractionHand.MAIN_HAND, brtr));
            if (ret != InteractionResult.PASS) {
                return ret.consumesAction();
            }
            if (stack.isEmpty() || fakePlayer.getCooldowns().isOnCooldown(stack.getItem())) {
                return false;
            }
            if (stack.getItem() instanceof BlockItem && ((block = ((BlockItem)stack.getItem()).getBlock()) instanceof CommandBlock || block instanceof StructureBlock)) {
                return false;
            }
            if (event.getUseItem() != Event.Result.DENY) {
                ItemStack copyBeforeUse = stack.copy();
                InteractionResult result = stack.useOn(new UseOnContext((Player)fakePlayer, InteractionHand.MAIN_HAND, brtr));
                if (result == InteractionResult.PASS) {
                    InteractionResultHolder rightClickResult = stack.getItem().use(world, (Player)fakePlayer, InteractionHand.MAIN_HAND);
                    fakePlayer.setItemInHand(InteractionHand.MAIN_HAND, (ItemStack)rightClickResult.getObject());
                }
                if (fakePlayer.getItemInHand(InteractionHand.MAIN_HAND).isEmpty()) {
                    EventHooks.onPlayerDestroyItem((Player)fakePlayer, (ItemStack)copyBeforeUse, (InteractionHand)InteractionHand.MAIN_HAND);
                }
                return true;
            }
        }
        catch (Throwable e) {
            Log.error("DroneAIRightClickBlock crashed! Stacktrace: ", new Object[0]);
            e.printStackTrace();
        }
        return false;
    }

    private boolean rightClickBlock(FakePlayer fakePlayer, BlockPos pos) {
        Level world = fakePlayer.getCommandSenderWorld();
        BlockState state = world.getBlockState(pos);
        BlockHitResult brtr = this.doTrace(world, pos, fakePlayer);
        if (brtr != null) {
            PlayerInteractEvent.RightClickBlock event = CommonHooks.onRightClickBlock((Player)fakePlayer, (InteractionHand)InteractionHand.MAIN_HAND, (BlockPos)pos, (BlockHitResult)brtr);
            try {
                InteractionResult res;
                if (!event.isCanceled() && event.getUseItem() != Event.Result.DENY && event.getUseBlock() != Event.Result.DENY && (res = state.use(world, (Player)fakePlayer, InteractionHand.MAIN_HAND, brtr)).consumesAction()) {
                    world.sendBlockUpdated(pos, state, state, 3);
                    return true;
                }
            }
            catch (Throwable e) {
                Log.error("DroneAIRightClickBlock crashed! Stacktrace: ", new Object[0]);
                e.printStackTrace();
            }
        }
        return false;
    }

    private boolean trySwapItem() {
        for (int i = 1; i < this.drone.getInv().getSlots(); ++i) {
            if (!this.progWidget.isItemValidForFilters(this.drone.getInv().getStackInSlot(i))) continue;
            ItemStack tmp = this.drone.getInv().getStackInSlot(i);
            this.drone.getInv().setStackInSlot(i, this.drone.getInv().getStackInSlot(0));
            this.drone.getInv().setStackInSlot(0, tmp);
            return true;
        }
        return false;
    }

    private BlockHitResult doTrace(Level world, BlockPos pos, FakePlayer fakePlayer) {
        BlockState state = world.getBlockState(pos);
        List l = state.getShape((BlockGetter)world, pos).toAabbs();
        Vec3 targetVec = l.isEmpty() ? Vec3.atCenterOf((Vec3i)pos) : ((AABB)l.get(0)).getCenter().add(Vec3.atLowerCornerOf((Vec3i)pos));
        Direction side = ISidedWidget.getDirForSides(((ISidedWidget)((Object)this.progWidget)).getSides());
        Vec3 saved = new Vec3(fakePlayer.getX(), fakePlayer.getY(), fakePlayer.getZ());
        Vec3 posVec = targetVec.add((double)side.getStepX(), (double)side.getStepY(), (double)side.getStepZ());
        fakePlayer.setPos(posVec.x, posVec.y, posVec.z);
        fakePlayer.lookAt(EntityAnchorArgument.Anchor.FEET, targetVec);
        BlockHitResult brtr = this.drone.world().clip(new ClipContext(posVec, targetVec, ClipContext.Block.OUTLINE, ClipContext.Fluid.SOURCE_ONLY, (Entity)fakePlayer));
        fakePlayer.setPos(saved.x, saved.y, saved.z);
        if (!brtr.getBlockPos().equals((Object)pos) || brtr.getDirection() != side) {
            return null;
        }
        return brtr;
    }
}

