/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.ai;

import me.desht.pneumaticcraft.common.drone.IDroneBase;
import me.desht.pneumaticcraft.common.drone.progwidgets.IItemFiltering;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class DroneAIVoidItem
extends Goal {
    private final IDroneBase drone;
    private final IItemFiltering widget;

    public DroneAIVoidItem(IDroneBase drone, IItemFiltering widget) {
        this.drone = drone;
        this.widget = widget;
    }

    public boolean canUse() {
        for (int i = 0; i < this.drone.getInv().getSlots(); ++i) {
            ItemStack stack = this.drone.getInv().getStackInSlot(i);
            if (stack.isEmpty() || !this.widget.isItemValidForFilters(stack)) continue;
            return true;
        }
        return false;
    }

    public void start() {
        for (int i = 0; i < this.drone.getInv().getSlots(); ++i) {
            ItemStack stack = this.drone.getInv().getStackInSlot(i);
            if (stack.isEmpty() || !this.widget.isItemValidForFilters(stack)) continue;
            this.drone.getInv().setStackInSlot(i, ItemStack.EMPTY);
            this.drone.addAirToDrone(-1 * stack.getCount());
            if (!(this.drone.world() instanceof ServerLevel)) continue;
            Vec3 vec = this.drone.getDronePos();
            ((ServerLevel)this.drone.world()).sendParticles((ParticleOptions)ParticleTypes.LAVA, vec.x, vec.y, vec.z, 5, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

