/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.ai;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import me.desht.pneumaticcraft.common.drone.IDroneBase;
import me.desht.pneumaticcraft.common.drone.ai.ChunkPositionSorter;
import me.desht.pneumaticcraft.common.drone.progwidgets.IAreaProvider;
import me.desht.pneumaticcraft.common.drone.progwidgets.IGotoWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidget;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class DroneEntityAIGoToLocation
extends Goal {
    protected final IDroneBase drone;
    private final ProgWidget gotoWidget;
    private final ChunkPositionSorter positionSorter;
    private final List<BlockPos> validArea;

    public DroneEntityAIGoToLocation(IDroneBase drone, ProgWidget gotoWidget) {
        this.drone = drone;
        this.setFlags(EnumSet.allOf(Goal.Flag.class));
        this.gotoWidget = gotoWidget;
        HashSet<BlockPos> set = new HashSet<BlockPos>();
        ((IAreaProvider)((Object)gotoWidget)).getArea(set);
        this.validArea = new ArrayList<BlockPos>(set);
        this.positionSorter = new ChunkPositionSorter(drone);
    }

    public boolean canUse() {
        this.validArea.sort(this.positionSorter);
        for (BlockPos c : this.validArea) {
            Vec3 vec3 = new Vec3((double)c.getX() + 0.5, (double)c.getY() + 0.5, (double)c.getZ() + 0.5);
            if (this.drone.getDronePos().distanceToSqr(vec3) < 0.75) {
                return false;
            }
            if (!this.drone.getPathNavigator().moveToXYZ(c.getX(), c.getY(), c.getZ())) continue;
            return !((IGotoWidget)((Object)this.gotoWidget)).doneWhenDeparting();
        }
        boolean teleport = this.drone.getPathNavigator().isGoingToTeleport();
        if (teleport) {
            return true;
        }
        for (BlockPos c : this.validArea) {
            this.drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.goto.debug.cantNavigate", c);
        }
        return false;
    }

    public boolean canContinueToUse() {
        return !this.drone.getPathNavigator().hasNoPath();
    }
}

