/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.ai;

import me.desht.pneumaticcraft.common.drone.IDroneBase;
import me.desht.pneumaticcraft.common.drone.ai.DroneAIImExBase;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetInventoryBase;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.IOHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class DroneEntityAIInventoryImport
extends DroneAIImExBase<ProgWidgetInventoryBase> {
    public DroneEntityAIInventoryImport(IDroneBase drone, ProgWidgetInventoryBase widget) {
        super(drone, widget);
    }

    @Override
    protected boolean isValidPosition(BlockPos pos) {
        return this.importItems(pos, true);
    }

    @Override
    protected boolean doBlockInteraction(BlockPos pos, double squareDistToBlock) {
        return this.importItems(pos, false) && super.doBlockInteraction(pos, squareDistToBlock);
    }

    private boolean importItems(BlockPos pos, boolean simulate) {
        Direction dir;
        BlockEntity te = this.drone.world().getBlockEntity(pos);
        boolean imported = false;
        Direction[] directionArray = DirectionUtil.VALUES;
        int n = directionArray.length;
        for (int i = 0; !(i >= n || ((ProgWidgetInventoryBase)this.progWidget).isSideSelected(dir = directionArray[i]) && (imported = IOHelper.getInventoryForBlock(te, dir).map(inv -> this.tryImport((IItemHandler)inv, pos, simulate)).orElse(false).booleanValue())); ++i) {
        }
        return imported;
    }

    private boolean tryImport(IItemHandler inv, BlockPos pos, boolean simulate) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            if (((ProgWidgetInventoryBase)this.progWidget).isItemValidForFilters(stack)) {
                ItemStack importedStack = inv.extractItem(i, stack.getCount(), true);
                if (importedStack.isEmpty()) continue;
                importedStack = importedStack.copy();
                if (((ProgWidgetInventoryBase)this.progWidget).useCount()) {
                    importedStack.setCount(Math.min(importedStack.getCount(), this.getRemainingCount()));
                }
                ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)this.drone.getInv(), (ItemStack)importedStack, (boolean)simulate);
                int removedItems = importedStack.getCount() - remainder.getCount();
                if (!simulate) {
                    inv.extractItem(i, removedItems, false);
                    this.decreaseCount(removedItems);
                    this.drone.addAirToDrone(-10);
                    if (!((ProgWidgetInventoryBase)this.progWidget).useCount() || this.getRemainingCount() > 0) continue;
                    return false;
                }
                if (removedItems > 0) {
                    return true;
                }
                this.drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.inventoryImport.debug.filledToMax", pos);
                continue;
            }
            this.drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.inventoryImport.debug.stackdoesntPassFilter", pos);
        }
        return false;
    }
}

