/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.ai;

import java.util.EnumSet;
import java.util.List;
import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.common.drone.IDroneBase;
import me.desht.pneumaticcraft.common.drone.ai.DistanceEntitySorter;
import me.desht.pneumaticcraft.common.drone.progwidgets.IItemPickupWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetAreaItemBase;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class DroneEntityAIPickupItems
extends Goal {
    private final IDroneBase drone;
    private final ProgWidgetAreaItemBase itemPickupWidget;
    private ItemEntity curPickingUpEntity;
    private final DistanceEntitySorter theNearestAttackableTargetSorter;
    private final boolean canSteal;
    private static final Direction[] DIRECTIONS = new Direction[]{Direction.UP, Direction.NORTH, Direction.WEST, Direction.EAST, Direction.SOUTH, Direction.DOWN};

    public DroneEntityAIPickupItems(IDroneBase drone, ProgWidgetAreaItemBase progWidgetPickupItem) {
        this.drone = drone;
        this.setFlags(EnumSet.allOf(Goal.Flag.class));
        this.itemPickupWidget = progWidgetPickupItem;
        this.theNearestAttackableTargetSorter = new DistanceEntitySorter(drone);
        if (!(progWidgetPickupItem instanceof IItemPickupWidget)) {
            throw new IllegalArgumentException("expecting a IItemPickupWidget!");
        }
        this.canSteal = ((IItemPickupWidget)((Object)this.itemPickupWidget)).canSteal();
    }

    public boolean canUse() {
        List<Entity> pickableItems = this.itemPickupWidget.getEntitiesInArea(this.drone.world(), entity -> entity instanceof ItemEntity && entity.isAlive());
        if (pickableItems.isEmpty()) {
            this.drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.itemPickup.debug.noItems");
            return false;
        }
        pickableItems.sort(this.theNearestAttackableTargetSorter);
        for (Entity ent : pickableItems) {
            if (ent.getPersistentData().getBoolean("PreventRemoteMovement") && !this.canSteal) continue;
            ItemStack stack = ((ItemEntity)ent).getItem();
            if (this.itemPickupWidget.isItemValidForFilters(stack)) {
                if (ItemHandlerHelper.insertItem((IItemHandler)this.drone.getInv(), (ItemStack)stack, (boolean)true).isEmpty()) {
                    return this.tryMoveToItem(ent);
                }
                this.drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.inventoryImport.debug.filledToMax");
                continue;
            }
            this.drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.itemPickup.debug.itemNotValid");
        }
        return false;
    }

    private boolean tryMoveToItem(Entity ent) {
        if (!this.drone.isBlockValidPathfindBlock(ent.blockPosition())) {
            for (Direction d : DIRECTIONS) {
                BlockPos pos2 = ent.blockPosition().relative(d);
                if (!this.drone.isBlockValidPathfindBlock(pos2) || !this.drone.getPathNavigator().moveToXYZ((double)pos2.getX() + 0.5, (double)pos2.getY() + 0.5, (double)pos2.getZ() + 0.5)) continue;
                this.curPickingUpEntity = (ItemEntity)ent;
                return true;
            }
        } else {
            if (this.drone.getPathNavigator().moveToEntity(ent)) {
                this.curPickingUpEntity = (ItemEntity)ent;
                return true;
            }
            this.drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.general.debug.cantNavigate");
        }
        return false;
    }

    public boolean canContinueToUse() {
        if (!this.curPickingUpEntity.isAlive()) {
            return false;
        }
        if (this.curPickingUpEntity.position().distanceToSqr(this.drone.getDronePos()) < 4.0) {
            ItemStack stack = this.curPickingUpEntity.getItem();
            if (this.itemPickupWidget.isItemValidForFilters(stack)) {
                DroneEntityAIPickupItems.tryPickupItem(this.drone, this.curPickingUpEntity);
            }
            return false;
        }
        return !this.drone.getPathNavigator().hasNoPath();
    }

    static void tryPickupItem(IDrone drone, ItemEntity itemEntity) {
        ItemStack remainder;
        ItemStack stack = itemEntity.getItem();
        int stackSize = stack.getCount();
        int collected = stackSize - (remainder = ItemHandlerHelper.insertItem((IItemHandler)drone.getInv(), (ItemStack)stack, (boolean)false)).getCount();
        if (collected > 0) {
            drone.onItemPickupEvent(itemEntity, collected);
        }
        if (remainder.isEmpty()) {
            itemEntity.discard();
        } else if (collected > 0) {
            itemEntity.setItem(remainder);
        }
    }
}

