/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import java.util.BitSet;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;

public class AxisOptions {
    public static final AxisOptions TRUE = new AxisOptions(true, true, true);
    private final BitSet options = new BitSet(3);

    public AxisOptions(boolean x, boolean y, boolean z) {
        this.options.set(0, x);
        this.options.set(1, y);
        this.options.set(2, z);
    }

    public boolean shouldCheck(Direction.Axis axis) {
        return this.options.get(axis.ordinal());
    }

    public void setCheck(Direction.Axis axis, boolean check) {
        this.options.set(axis.ordinal(), check);
    }

    public void writeToNBT(CompoundTag nbt) {
        nbt.putBoolean("checkX", this.shouldCheck(Direction.Axis.X));
        nbt.putBoolean("checkY", this.shouldCheck(Direction.Axis.Y));
        nbt.putBoolean("checkZ", this.shouldCheck(Direction.Axis.Z));
    }

    public void readFromNBT(CompoundTag nbt, boolean def) {
        this.setCheck(Direction.Axis.X, nbt.contains("checkX") ? nbt.getBoolean("checkX") : def);
        this.setCheck(Direction.Axis.Y, nbt.contains("checkY") ? nbt.getBoolean("checkY") : def);
        this.setCheck(Direction.Axis.Z, nbt.contains("checkZ") ? nbt.getBoolean("checkZ") : def);
    }

    public void writeToBuffer(FriendlyByteBuf buffer) {
        buffer.writeByte(this.options.toByteArray()[0]);
    }

    public void readFromBuffer(FriendlyByteBuf buffer) {
        this.options.clear();
        this.options.or(BitSet.valueOf(new byte[]{buffer.readByte()}));
    }
}

