/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.drone.IDroneBase;
import me.desht.pneumaticcraft.common.drone.ai.DroneAIManager;
import me.desht.pneumaticcraft.common.drone.progwidgets.IAreaProvider;
import me.desht.pneumaticcraft.common.drone.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.IVariableProvider;
import me.desht.pneumaticcraft.common.drone.progwidgets.IVariableWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.area.AreaTooBigException;
import me.desht.pneumaticcraft.common.drone.progwidgets.area.AreaType;
import me.desht.pneumaticcraft.common.drone.progwidgets.area.AreaTypeBox;
import me.desht.pneumaticcraft.common.drone.progwidgets.area.AreaTypeCylinder;
import me.desht.pneumaticcraft.common.drone.progwidgets.area.AreaTypeGrid;
import me.desht.pneumaticcraft.common.drone.progwidgets.area.AreaTypeLine;
import me.desht.pneumaticcraft.common.drone.progwidgets.area.AreaTypePyramid;
import me.desht.pneumaticcraft.common.drone.progwidgets.area.AreaTypeRandom;
import me.desht.pneumaticcraft.common.drone.progwidgets.area.AreaTypeSphere;
import me.desht.pneumaticcraft.common.drone.progwidgets.area.AreaTypeTorus;
import me.desht.pneumaticcraft.common.drone.progwidgets.area.AreaTypeWall;
import me.desht.pneumaticcraft.common.registry.ModProgWidgets;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Log;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class ProgWidgetArea
extends ProgWidget
implements IAreaProvider,
IVariableWidget {
    private DroneAIManager aiManager;
    private final BlockPos[] pos = new BlockPos[]{null, null};
    private final String[] varNames = new String[]{"", ""};
    public AreaType type = new AreaTypeBox();
    private IVariableProvider variableProvider;
    private UUID playerID;
    private static final Map<String, Integer> areaTypeToID = new HashMap<String, Integer>();
    private static final List<Supplier<? extends AreaType>> areaTypeFactories = new ArrayList<Supplier<? extends AreaType>>();

    public ProgWidgetArea() {
        super(ModProgWidgets.AREA.get());
    }

    private static <T extends AreaType> void register(String id, Supplier<T> factory) {
        if (areaTypeToID.containsKey(id)) {
            throw new IllegalStateException("Area type " + id + " could not be registered, duplicate id");
        }
        areaTypeFactories.add(factory);
        areaTypeToID.put(id, areaTypeFactories.size() - 1);
    }

    public static List<AreaType> getAllAreaTypes() {
        return areaTypeFactories.stream().map(Supplier::get).collect(Collectors.toList());
    }

    public static ProgWidgetArea fromPosition(BlockPos p1) {
        return ProgWidgetArea.fromPositions(p1, p1);
    }

    public static ProgWidgetArea fromPosition(BlockPos p1, int expand) {
        return ProgWidgetArea.fromPosition(p1, expand, expand, expand);
    }

    public static ProgWidgetArea fromPosition(BlockPos p1, int expandX, int expandY, int expandZ) {
        int x = expandX / 2;
        int y = expandY / 2;
        int z = expandZ / 2;
        return ProgWidgetArea.fromPositions(p1.offset(-x, -y, -z), p1.offset(x, y, z));
    }

    public static ProgWidgetArea fromPositions(BlockPos p1, BlockPos p2) {
        ProgWidgetArea area = new ProgWidgetArea();
        area.setPos(0, p1);
        area.setPos(1, p2);
        return area;
    }

    @Override
    public List<Component> getExtraStringInfo() {
        ArrayList<Component> res = new ArrayList<Component>();
        if (this.varNames[0].isEmpty() && this.varNames[1].isEmpty() && PneumaticCraftUtils.isValidPos(this.pos[0]) && this.pos[0].equals((Object)this.pos[1])) {
            res.add((Component)Component.literal((String)PneumaticCraftUtils.posToString(this.pos[0])));
        } else {
            if (!this.varNames[0].isEmpty()) {
                res.add((Component)Component.literal((String)("\"" + this.varNames[0] + "\"")));
            } else if (PneumaticCraftUtils.isValidPos(this.pos[0])) {
                res.add((Component)Component.literal((String)PneumaticCraftUtils.posToString(this.pos[0])));
            }
            if (!this.varNames[1].isEmpty() && !this.varNames[1].equals(this.varNames[0])) {
                res.add((Component)Component.literal((String)("\"" + this.varNames[1] + "\"")));
            } else if (PneumaticCraftUtils.isValidPos(this.pos[1]) && !this.pos[1].equals((Object)this.pos[0])) {
                res.add((Component)Component.literal((String)PneumaticCraftUtils.posToString(this.pos[1])));
            }
            if (res.size() == 2) {
                MutableComponent c = PneumaticCraftUtils.xlate(this.type.getTranslationKey(), new Object[0]);
                ArrayList<AreaType.AreaTypeWidget> widgets = new ArrayList<AreaType.AreaTypeWidget>();
                this.type.addUIWidgets(widgets);
                widgets.forEach(w -> c.append("/").append(w.getDisplayName()));
                res.add((Component)c);
            }
        }
        return res;
    }

    @Override
    public void getTooltip(List<Component> curTooltip) {
        super.getTooltip(curTooltip);
        if (!this.varNames[0].isEmpty() && this.varNames[0].equals(this.varNames[1])) {
            curTooltip.add((Component)Component.literal((String)String.format("Var \"%s\"", this.varNames[0])).withStyle(ChatFormatting.YELLOW));
        } else if (PneumaticCraftUtils.isValidPos(this.pos[0]) && this.pos[0].equals((Object)this.pos[1])) {
            curTooltip.add((Component)Component.literal((String)"P1: ").append((Component)Component.literal((String)PneumaticCraftUtils.posToString(this.pos[0])).withStyle(ChatFormatting.YELLOW)));
        } else {
            int n = curTooltip.size();
            for (int i = 0; i < 2; ++i) {
                String text;
                String string = this.varNames[i].isEmpty() ? (this.pos[i] == null ? null : PneumaticCraftUtils.posToString(this.pos[i])) : (text = String.format("Var \"%s\"", this.varNames[i]));
                if (text == null) continue;
                curTooltip.add((Component)Component.literal((String)("P" + (i + 1) + ": ")).append((Component)Component.literal((String)text).withStyle(ChatFormatting.YELLOW)));
            }
            if (curTooltip.size() - n == 2) {
                this.addAreaTypeTooltip(curTooltip);
            }
        }
    }

    public void addAreaTypeTooltip(List<Component> curTooltip) {
        curTooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.area.type", new Object[0]).append((Component)PneumaticCraftUtils.xlate(this.type.getTranslationKey(), new Object[0]).withStyle(ChatFormatting.YELLOW)));
        ArrayList<AreaType.AreaTypeWidget> widgets = new ArrayList<AreaType.AreaTypeWidget>();
        this.type.addUIWidgets(widgets);
        for (AreaType.AreaTypeWidget widget : widgets) {
            curTooltip.add((Component)PneumaticCraftUtils.xlate(widget.title, new Object[0]).append(" ").append((Component)widget.getDisplayName().copy().withStyle(ChatFormatting.YELLOW)));
        }
    }

    @Override
    public void addErrors(List<Component> curInfo, List<IProgWidget> widgets) {
        super.addErrors(curInfo, widgets);
        if (this.varNames[0].isEmpty() && this.varNames[1].isEmpty() && this.pos[0] == null && this.pos[1] == null) {
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.area.error.noArea", new Object[0]));
        }
        if (!(this.type instanceof AreaTypeBox)) {
            IProgWidget p = this;
            while ((p = p.getParent()) != null) {
                ProgWidgetType<?> type = p.getType();
                if (type != ModProgWidgets.ENTITY_ATTACK.get() && type != ModProgWidgets.ENTITY_IMPORT.get() && type != ModProgWidgets.ENTITY_RIGHT_CLICK.get() && type != ModProgWidgets.CONDITION_ENTITY.get() && type != ModProgWidgets.PICKUP_ITEM.get()) continue;
                curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.area.error.onlyAreaTypeBox", PneumaticCraftUtils.xlate(p.getTranslationKey(), new Object[0])));
                break;
            }
        }
    }

    private BlockPos[] getAreaPoints() {
        BlockPos[] points = new BlockPos[2];
        for (int i = 0; i < 2; ++i) {
            points[i] = this.varNames[i].isEmpty() ? this.pos[i] : (this.variableProvider != null ? (BlockPos)this.variableProvider.getCoordinate(this.playerID, this.varNames[i]).orElse(null) : null);
        }
        if (points[0] == null && points[1] == null) {
            return new BlockPos[]{null, null};
        }
        if (points[0] == null) {
            return new BlockPos[]{points[1], null};
        }
        if (points[1] == null) {
            return new BlockPos[]{points[0], null};
        }
        return points;
    }

    @Override
    public boolean hasStepInput() {
        return false;
    }

    @Override
    public ProgWidgetType<?> returnType() {
        return ModProgWidgets.AREA.get();
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of(ModProgWidgets.AREA.get());
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_AREA;
    }

    @Override
    public void getArea(Set<BlockPos> area) {
        this.getArea(area, this.type);
    }

    public void getArea(Set<BlockPos> area, AreaType areaType) {
        int maxZ;
        int maxY;
        int maxX;
        int minZ;
        int minY;
        int minX;
        BlockPos[] areaPoints = this.getAreaPoints();
        if (areaPoints[0] == null) {
            return;
        }
        if (areaPoints[1] != null) {
            minX = Math.min(areaPoints[0].getX(), areaPoints[1].getX());
            minY = Math.min(areaPoints[0].getY(), areaPoints[1].getY());
            minZ = Math.min(areaPoints[0].getZ(), areaPoints[1].getZ());
            maxX = Math.max(areaPoints[0].getX(), areaPoints[1].getX());
            maxY = Math.max(areaPoints[0].getY(), areaPoints[1].getY());
            maxZ = Math.max(areaPoints[0].getZ(), areaPoints[1].getZ());
        } else {
            minX = maxX = areaPoints[0].getX();
            minY = maxY = areaPoints[0].getY();
            minZ = maxZ = areaPoints[0].getZ();
        }
        BlockPos p1 = areaPoints[0];
        BlockPos p2 = areaPoints[1] != null ? areaPoints[1] : p1;
        int size = (maxX - minX + 1) * (maxY - minY + 1) * (maxZ - minZ + 1);
        int maxSize = (Integer)ConfigHelper.common().general.maxProgrammingArea.get();
        if (size > maxSize && this.aiManager != null) {
            IDroneBase drone = this.aiManager.getDrone();
            Log.warning("Drone @ {} (DIM {}) was killed due to excessively large area ({} > {}). See 'maxProgrammingArea' in config.", drone.getDronePos().toString(), drone.world().dimension().location(), size, maxSize);
            drone.overload("areaTooLarge", maxSize);
            return;
        }
        Consumer<BlockPos> addFunc = p -> {
            if (area.add((BlockPos)p) && area.size() > maxSize) {
                throw new AreaTooBigException();
            }
        };
        try {
            areaType.addArea(addFunc, p1, p2, minX, minY, minZ, maxX, maxY, maxZ);
        }
        catch (AreaTooBigException areaTooBigException) {
            // empty catch block
        }
    }

    private AABB getAABB() {
        int maxZ;
        int maxY;
        int maxX;
        int minZ;
        int minY;
        int minX;
        BlockPos[] areaPoints = this.getAreaPoints();
        if (areaPoints[0] == null) {
            return null;
        }
        if (areaPoints[1] != null) {
            minX = Math.min(areaPoints[0].getX(), areaPoints[1].getX());
            minY = Math.min(areaPoints[0].getY(), areaPoints[1].getY());
            minZ = Math.min(areaPoints[0].getZ(), areaPoints[1].getZ());
            maxX = Math.max(areaPoints[0].getX(), areaPoints[1].getX());
            maxY = Math.max(areaPoints[0].getY(), areaPoints[1].getY());
            maxZ = Math.max(areaPoints[0].getZ(), areaPoints[1].getZ());
        } else {
            minX = maxX = areaPoints[0].getX();
            minY = maxY = areaPoints[0].getY();
            minZ = maxZ = areaPoints[0].getZ();
        }
        return new AABB((double)minX, (double)minY, (double)minZ, (double)(maxX + 1), (double)(maxY + 1), (double)(maxZ + 1));
    }

    List<Entity> getEntitiesWithinArea(Level world, Predicate<? super Entity> predicate) {
        AABB aabb = this.getAABB();
        return aabb != null ? world.getEntities((Entity)null, aabb, predicate) : new ArrayList<Entity>();
    }

    @Override
    public void writeToPacket(FriendlyByteBuf buf) {
        super.writeToPacket(buf);
        BlockPos pos1 = this.getPos(0).orElse(BlockPos.ZERO);
        BlockPos pos2 = this.getPos(1).orElse(BlockPos.ZERO);
        buf.writeBlockPos(pos1);
        BlockPos offset = pos1.subtract((Vec3i)pos2).offset(127, 127, 127);
        buf.writeBlockPos(offset);
        buf.writeVarInt(areaTypeToID.get(this.type.getName()).intValue());
        this.type.writeToPacket(buf);
        buf.writeUtf(this.varNames[0]);
        buf.writeUtf(this.varNames[1]);
    }

    @Override
    public void readFromPacket(FriendlyByteBuf buf) {
        super.readFromPacket(buf);
        this.pos[0] = buf.readBlockPos();
        BlockPos offset = buf.readBlockPos().offset(-127, -127, -127);
        this.pos[1] = this.pos[0].subtract((Vec3i)offset);
        this.type = ProgWidgetArea.createType(buf.readVarInt());
        this.type.readFromPacket(buf);
        this.varNames[0] = buf.readUtf(64);
        this.varNames[1] = buf.readUtf(64);
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        this.getPos(0).ifPresent(pos -> tag.put("pos1", (Tag)NbtUtils.writeBlockPos((BlockPos)pos)));
        this.getPos(1).ifPresent(pos -> tag.put("pos2", (Tag)NbtUtils.writeBlockPos((BlockPos)pos)));
        tag.putString("type", this.type.getName());
        this.type.writeToNBT(tag);
        if (!this.varNames[0].isEmpty()) {
            tag.putString("var1", this.varNames[0]);
        } else {
            tag.remove("var1");
        }
        if (!this.varNames[1].isEmpty()) {
            tag.putString("var2", this.varNames[1]);
        } else {
            tag.remove("var2");
        }
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        if (tag.contains("x1")) {
            this.pos[0] = new BlockPos(tag.getInt("x1"), tag.getInt("y1"), tag.getInt("z1"));
            this.pos[1] = new BlockPos(tag.getInt("x2"), tag.getInt("y2"), tag.getInt("z2"));
            this.varNames[0] = tag.getString("coord1Variable");
            this.varNames[1] = tag.getString("coord2Variable");
        } else {
            this.pos[0] = NbtUtils.readBlockPos((CompoundTag)tag.getCompound("pos1"));
            this.pos[1] = NbtUtils.readBlockPos((CompoundTag)tag.getCompound("pos2"));
            this.varNames[0] = tag.getString("var1");
            this.varNames[1] = tag.getString("var2");
        }
        this.type = ProgWidgetArea.createType(tag.getString("type"));
        this.type.readFromNBT(tag);
    }

    public static AreaType createType(String id) {
        if (!areaTypeToID.containsKey(id)) {
            Log.error("No Area type found for id '{}'! Substituting Box!", id);
            return new AreaTypeBox();
        }
        return ProgWidgetArea.createType(areaTypeToID.get(id));
    }

    public static AreaType createType(int id) {
        return areaTypeFactories.get(id).get();
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.EASY;
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.GREEN;
    }

    public void setPos(int index, BlockPos newPos) {
        this.pos[index] = newPos;
    }

    public Optional<BlockPos> getPos(int index) {
        return Optional.ofNullable(this.pos[index]);
    }

    public String getVarName(int index) {
        return this.varNames[index];
    }

    public void setVarName(int index, String varName) {
        this.varNames[index] = varName;
    }

    @Override
    public void setAIManager(DroneAIManager aiManager) {
        this.aiManager = aiManager;
        this.variableProvider = aiManager;
    }

    @Override
    public void addVariables(Set<String> variables) {
        variables.add(this.varNames[0]);
        variables.add(this.varNames[1]);
    }

    public void setVariableProvider(IVariableProvider provider, UUID playerID) {
        this.variableProvider = provider;
        this.playerID = playerID;
    }

    static {
        ProgWidgetArea.register("box", AreaTypeBox::new);
        ProgWidgetArea.register("sphere", AreaTypeSphere::new);
        ProgWidgetArea.register("line", AreaTypeLine::new);
        ProgWidgetArea.register("wall", AreaTypeWall::new);
        ProgWidgetArea.register("cylinder", AreaTypeCylinder::new);
        ProgWidgetArea.register("pyramid", AreaTypePyramid::new);
        ProgWidgetArea.register("grid", AreaTypeGrid::new);
        ProgWidgetArea.register("random", AreaTypeRandom::new);
        ProgWidgetArea.register("torus", AreaTypeTorus::new);
    }
}

