/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import java.util.List;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.drone.IDroneBase;
import me.desht.pneumaticcraft.common.drone.ai.DroneAIRightClickBlock;
import me.desht.pneumaticcraft.common.drone.progwidgets.IBlockRightClicker;
import me.desht.pneumaticcraft.common.drone.progwidgets.IMaxActions;
import me.desht.pneumaticcraft.common.drone.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ISidedWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetAreaItemBase;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetPlace;
import me.desht.pneumaticcraft.common.registry.ModProgWidgets;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.goal.Goal;

public class ProgWidgetBlockRightClick
extends ProgWidgetPlace
implements IBlockRightClicker,
ISidedWidget {
    private Direction clickSide = Direction.UP;
    private boolean sneaking;
    private IBlockRightClicker.RightClickType clickType = IBlockRightClicker.RightClickType.CLICK_ITEM;

    public ProgWidgetBlockRightClick() {
        super(ModProgWidgets.BLOCK_RIGHT_CLICK.get());
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_BLOCK_RIGHT_CLICK;
    }

    @Override
    public Goal getWidgetAI(IDroneBase drone, IProgWidget widget) {
        return this.setupMaxActions(new DroneAIRightClickBlock(drone, (ProgWidgetAreaItemBase)widget), (IMaxActions)((Object)widget));
    }

    @Override
    public boolean supportsMaxActions() {
        return false;
    }

    @Override
    public boolean isSneaking() {
        return this.sneaking;
    }

    public void setSneaking(boolean sneaking) {
        this.sneaking = sneaking;
    }

    @Override
    public IBlockRightClicker.RightClickType getClickType() {
        return this.clickType;
    }

    public void setClickType(IBlockRightClicker.RightClickType clickType) {
        this.clickType = clickType;
    }

    public Direction getClickSide() {
        return this.clickSide;
    }

    public void setClickSide(Direction clickSide) {
        this.clickSide = clickSide;
    }

    @Override
    public void getTooltip(List<Component> curTooltip) {
        super.getTooltip(curTooltip);
        curTooltip.add((Component)Component.translatable((String)"pneumaticcraft.gui.progWidget.blockRightClick.clickSide").append(": " + ClientUtils.translateDirection(this.clickSide)));
        if (this.sneaking) {
            curTooltip.add((Component)Component.translatable((String)"pneumaticcraft.gui.progWidget.blockRightClick.sneaking"));
        }
        curTooltip.add((Component)Component.translatable((String)"pneumaticcraft.gui.progWidget.blockRightClick.operation").append(": ").append((Component)Component.translatable((String)this.clickType.getTranslationKey())));
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        if (this.sneaking) {
            tag.putBoolean("sneaking", true);
        }
        tag.putInt("dir", this.clickSide.get3DDataValue());
        tag.putString("clickType", this.clickType.toString());
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        this.sneaking = tag.getBoolean("sneaking");
        this.clickSide = Direction.from3DDataValue((int)tag.getInt("dir"));
        this.clickType = tag.contains("clickType") ? IBlockRightClicker.RightClickType.valueOf(tag.getString("clickType")) : IBlockRightClicker.RightClickType.CLICK_ITEM;
    }

    @Override
    public void writeToPacket(FriendlyByteBuf buf) {
        super.writeToPacket(buf);
        buf.writeBoolean(this.sneaking);
        buf.writeEnum((Enum)this.clickSide);
        buf.writeEnum((Enum)this.clickType);
    }

    @Override
    public void readFromPacket(FriendlyByteBuf buf) {
        super.readFromPacket(buf);
        this.sneaking = buf.readBoolean();
        this.clickSide = (Direction)buf.readEnum(Direction.class);
        this.clickType = (IBlockRightClicker.RightClickType)buf.readEnum(IBlockRightClicker.RightClickType.class);
    }

    @Override
    public void setSides(boolean[] sides) {
        this.clickSide = ISidedWidget.getDirForSides(sides);
    }

    @Override
    public boolean[] getSides() {
        return ISidedWidget.getSidesFromDir(this.clickSide);
    }
}

