/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.drone.IDroneBase;
import me.desht.pneumaticcraft.common.drone.ai.DroneAIBlockCondition;
import me.desht.pneumaticcraft.common.drone.progwidgets.ICondition;
import me.desht.pneumaticcraft.common.drone.progwidgets.IJump;
import me.desht.pneumaticcraft.common.drone.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.IVariableSetWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetInventoryBase;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetJump;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetText;
import me.desht.pneumaticcraft.common.thirdparty.computer_common.ProgWidgetCC;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.DyeColor;

public abstract class ProgWidgetCondition
extends ProgWidgetInventoryBase
implements ICondition,
IJump,
IVariableSetWidget {
    private DroneAIBlockCondition evaluator;
    private boolean isAndFunction;
    private ICondition.Operator operator = ICondition.Operator.GE;
    private String measureVar = "";

    public ProgWidgetCondition(ProgWidgetType<?> type) {
        super(type);
    }

    @Override
    public Goal getWidgetAI(IDroneBase drone, IProgWidget widget) {
        if (this.evaluator == null || !(widget instanceof ProgWidgetCC)) {
            this.evaluator = this.getEvaluator(drone, widget);
        }
        return this.evaluator;
    }

    protected abstract DroneAIBlockCondition getEvaluator(IDroneBase var1, IProgWidget var2);

    @Override
    public String getMeasureVar() {
        return this.measureVar;
    }

    @Override
    public void setMeasureVar(String measureVar) {
        this.measureVar = measureVar;
    }

    @Override
    public void getTooltip(List<Component> curTooltip) {
        super.getTooltip(curTooltip);
        if (!this.measureVar.isEmpty()) {
            curTooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.condition.measure", new Object[0]).append(this.measureVar));
        }
    }

    @Override
    public void addErrors(List<Component> curInfo, List<IProgWidget> widgets) {
        super.addErrors(curInfo, widgets);
        if (this.measureVar.isEmpty() && this.getConnectedParameters()[this.getParameters().size() - 1] == null && this.getConnectedParameters()[this.getParameters().size() * 2 - 1] == null) {
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.condition.error.noFlowControl", new Object[0]));
        }
    }

    @Override
    public IProgWidget getOutputWidget(IDroneBase drone, List<IProgWidget> allWidgets) {
        if (this.evaluator != null) {
            boolean evaluation = this.evaluate(drone, this);
            if (evaluation) {
                drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.condition.evaluatedTrue");
            } else {
                drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.condition.evaluatedFalse");
            }
            return ProgWidgetJump.jumpToLabel(drone, allWidgets, this, evaluation);
        }
        Log.error("Shouldn't be happening! ProgWidgetCondition evaluator is null for some reason", new Object[0]);
        return super.getOutputWidget(drone, allWidgets);
    }

    @Override
    public boolean evaluate(IDroneBase drone, IProgWidget widget) {
        return this.evaluator.getResult();
    }

    @Override
    public boolean isAndFunction() {
        return this.isAndFunction;
    }

    @Override
    public void setAndFunction(boolean isAndFunction) {
        this.isAndFunction = isAndFunction;
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.MEDIUM;
    }

    @Override
    public List<String> getPossibleJumpLocations() {
        IProgWidget widget = this.getConnectedParameters()[this.getParameters().size() - 1];
        ProgWidgetText textWidget = widget != null ? (ProgWidgetText)widget : null;
        IProgWidget widget2 = this.getConnectedParameters()[this.getParameters().size() * 2 - 1];
        ProgWidgetText textWidget2 = widget2 != null ? (ProgWidgetText)widget2 : null;
        ArrayList<String> locations = new ArrayList<String>();
        if (textWidget != null) {
            locations.add(textWidget.string);
        }
        if (textWidget2 != null) {
            locations.add(textWidget2.string);
        }
        return locations;
    }

    @Override
    public int getRequiredCount() {
        return this.getCount();
    }

    @Override
    public void setRequiredCount(int count) {
        this.setCount(count);
    }

    @Override
    public ICondition.Operator getOperator() {
        return this.operator;
    }

    @Override
    public void setOperator(ICondition.Operator operator) {
        this.operator = operator;
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        if (this.isAndFunction) {
            tag.putBoolean("isAndFunction", true);
        }
        tag.putByte("operator", (byte)this.operator.ordinal());
        if (!this.measureVar.isEmpty()) {
            tag.putString("measureVar", this.measureVar);
        }
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        this.isAndFunction = tag.getBoolean("isAndFunction");
        this.operator = ICondition.Operator.values()[tag.getByte("operator")];
        this.measureVar = tag.getString("measureVar");
    }

    @Override
    public void writeToPacket(FriendlyByteBuf buf) {
        super.writeToPacket(buf);
        buf.writeBoolean(this.isAndFunction);
        buf.writeByte(this.operator.ordinal());
        buf.writeUtf(this.measureVar, 64);
    }

    @Override
    public void readFromPacket(FriendlyByteBuf buf) {
        super.readFromPacket(buf);
        this.isAndFunction = buf.readBoolean();
        this.operator = ICondition.Operator.values()[buf.readByte()];
        this.measureVar = buf.readUtf(64);
    }

    @Override
    protected boolean isUsingSides() {
        return false;
    }

    @Override
    public List<Component> getExtraStringInfo() {
        MutableComponent anyAll = PneumaticCraftUtils.xlate(this.isAndFunction() ? "pneumaticcraft.gui.misc.all" : "pneumaticcraft.gui.misc.any", new Object[0]).append(" " + this.getOperator().toString() + " " + this.getRequiredCount());
        return this.measureVar.isEmpty() ? Collections.singletonList(anyAll) : ImmutableList.of((Object)anyAll, (Object)this.varAsTextComponent(this.measureVar));
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.CYAN;
    }

    @Override
    public void addVariables(Set<String> variables) {
        super.addVariables(variables);
        if (!this.getMeasureVar().isEmpty()) {
            variables.add(this.getMeasureVar());
        }
    }

    @Override
    public String getVariable() {
        return this.getMeasureVar();
    }

    @Override
    public void setVariable(String variable) {
        this.setMeasureVar(variable);
    }
}

