/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.drone.ai.DroneAIManager;
import me.desht.pneumaticcraft.common.drone.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.IVariableWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.item.GPSToolItem;
import me.desht.pneumaticcraft.common.registry.ModProgWidgets;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;

public class ProgWidgetCoordinate
extends ProgWidget
implements IVariableWidget {
    private BlockPos coord;
    private String variable = "";
    private boolean useVariable;
    private DroneAIManager aiManager;

    public ProgWidgetCoordinate() {
        super(ModProgWidgets.COORDINATE.get());
    }

    public static ProgWidgetCoordinate fromPos(BlockPos pos) {
        ProgWidgetCoordinate w = new ProgWidgetCoordinate();
        w.setCoordinate(pos);
        return w;
    }

    public static ProgWidgetCoordinate fromGPSTool(ItemStack gpsTool) {
        ProgWidgetCoordinate w = new ProgWidgetCoordinate();
        w.loadFromGPSTool(gpsTool);
        return w;
    }

    @Override
    public boolean hasStepInput() {
        return false;
    }

    @Override
    public ProgWidgetType<?> returnType() {
        return ModProgWidgets.COORDINATE.get();
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of(ModProgWidgets.COORDINATE.get());
    }

    @Override
    public void addWarnings(List<Component> curInfo, List<IProgWidget> widgets) {
        super.addWarnings(curInfo, widgets);
        if (!this.useVariable && this.coord == null) {
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.coordinate.warning.noCoordinate", new Object[0]));
        }
    }

    @Override
    public void addErrors(List<Component> curInfo, List<IProgWidget> widgets) {
        super.addErrors(curInfo, widgets);
        if (this.useVariable && this.variable.isEmpty()) {
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.general.error.emptyVariable", new Object[0]));
        }
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.GREEN;
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.ADVANCED;
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_COORDINATE;
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        if (this.coord != null) {
            tag.put("coord", (Tag)NbtUtils.writeBlockPos((BlockPos)this.coord));
        }
        if (!this.variable.isEmpty()) {
            tag.putString("variable", this.variable);
        }
        if (this.useVariable) {
            tag.putBoolean("useVariable", true);
        }
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        this.coord = tag.contains("coord") ? NbtUtils.readBlockPos((CompoundTag)tag.getCompound("coord")) : (tag.contains("posX") ? new BlockPos(tag.getInt("posX"), tag.getInt("posY"), tag.getInt("posZ")) : null);
        this.variable = tag.getString("variable");
        this.useVariable = tag.getBoolean("useVariable");
    }

    @Override
    public void writeToPacket(FriendlyByteBuf buf) {
        super.writeToPacket(buf);
        buf.writeNullable((Object)this.coord, FriendlyByteBuf::writeBlockPos);
        buf.writeUtf(this.variable);
        buf.writeBoolean(this.useVariable);
    }

    @Override
    public void readFromPacket(FriendlyByteBuf buf) {
        super.readFromPacket(buf);
        this.coord = (BlockPos)buf.readNullable(FriendlyByteBuf::readBlockPos);
        this.variable = buf.readUtf(64);
        this.useVariable = buf.readBoolean();
    }

    @Override
    public void setAIManager(DroneAIManager aiManager) {
        this.aiManager = aiManager;
    }

    public Optional<BlockPos> getCoordinate() {
        if (this.useVariable && this.aiManager != null) {
            return this.aiManager.getCoordinate(this.aiManager.getDrone().getOwnerUUID(), this.variable);
        }
        return this.getRawCoordinate();
    }

    public Optional<BlockPos> getRawCoordinate() {
        return Optional.ofNullable(this.coord);
    }

    public void setCoordinate(BlockPos pos) {
        this.coord = pos;
    }

    public void setVariable(String varName) {
        this.variable = varName;
    }

    public String getVariable() {
        return this.variable;
    }

    public boolean isUsingVariable() {
        return this.useVariable;
    }

    public void setUsingVariable(boolean useVariable) {
        this.useVariable = useVariable;
    }

    public void loadFromGPSTool(ItemStack gpsTool) {
        String variable = GPSToolItem.getVariable(gpsTool);
        if (variable.isEmpty()) {
            this.setCoordinate(GPSToolItem.getGPSLocation(gpsTool).orElse(BlockPos.ZERO));
            this.setUsingVariable(false);
        } else {
            this.setVariable(variable);
            this.setUsingVariable(true);
        }
    }

    @Override
    public void getTooltip(List<Component> curTooltip) {
        super.getTooltip(curTooltip);
        if (this.useVariable) {
            curTooltip.add((Component)Component.literal((String)("XYZ: var '" + this.variable + "'")));
        } else {
            curTooltip.add((Component)Component.literal((String)PneumaticCraftUtils.posToString(this.coord)));
        }
    }

    @Override
    public List<Component> getExtraStringInfo() {
        return this.useVariable ? Collections.singletonList(this.varAsTextComponent(this.variable)) : Collections.singletonList(Component.literal((String)PneumaticCraftUtils.posToString(this.coord)));
    }

    @Override
    public void addVariables(Set<String> variables) {
        variables.add(this.variable);
    }
}

