/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.drone.IDroneBase;
import me.desht.pneumaticcraft.common.drone.progwidgets.AxisOptions;
import me.desht.pneumaticcraft.common.drone.progwidgets.ICondition;
import me.desht.pneumaticcraft.common.drone.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetConditionBase;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetCoordinateOperator;
import me.desht.pneumaticcraft.common.registry.ModProgWidgets;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ProgWidgetCoordinateCondition
extends ProgWidgetConditionBase {
    private final AxisOptions axisOptions = new AxisOptions(false, false, false);
    private ICondition.Operator operator = ICondition.Operator.GE;

    public ProgWidgetCoordinateCondition() {
        super(ModProgWidgets.CONDITION_COORDINATE.get());
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of(ModProgWidgets.COORDINATE.get(), ModProgWidgets.COORDINATE.get(), ModProgWidgets.TEXT.get());
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.ADVANCED;
    }

    @Override
    public void addErrors(List<Component> curInfo, List<IProgWidget> widgets) {
        super.addErrors(curInfo, widgets);
        if (!(this.axisOptions.shouldCheck(Direction.Axis.X) || this.axisOptions.shouldCheck(Direction.Axis.Y) || this.axisOptions.shouldCheck(Direction.Axis.Z))) {
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.conditionCoordinate.error.noAxisSelected", new Object[0]));
        }
    }

    @Override
    public boolean evaluate(IDroneBase drone, IProgWidget widget) {
        BlockPos pos1 = ProgWidgetCoordinateOperator.calculateCoordinate(widget, 0, ProgWidgetCoordinateOperator.EnumOperator.PLUS_MINUS);
        BlockPos pos2 = ProgWidgetCoordinateOperator.calculateCoordinate(widget, 1, ProgWidgetCoordinateOperator.EnumOperator.PLUS_MINUS);
        return !(this.axisOptions.shouldCheck(Direction.Axis.X) && !this.evaluate(pos1.getX(), pos2.getX()) || this.axisOptions.shouldCheck(Direction.Axis.Y) && !this.evaluate(pos1.getY(), pos2.getY()) || this.axisOptions.shouldCheck(Direction.Axis.Z) && !this.evaluate(pos1.getZ(), pos2.getZ()));
    }

    public AxisOptions getAxisOptions() {
        return this.axisOptions;
    }

    private boolean evaluate(int arg1, int arg2) {
        return this.operator.evaluate(arg1, arg2);
    }

    public ICondition.Operator getOperator() {
        return this.operator;
    }

    public void setOperator(ICondition.Operator operator) {
        this.operator = operator;
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        this.axisOptions.writeToNBT(tag);
        tag.putByte("operator", (byte)this.operator.ordinal());
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        this.axisOptions.readFromNBT(tag, false);
        this.operator = ICondition.Operator.values()[tag.getByte("operator")];
    }

    @Override
    public void writeToPacket(FriendlyByteBuf buf) {
        super.writeToPacket(buf);
        this.axisOptions.writeToBuffer(buf);
        buf.writeByte(this.operator.ordinal());
    }

    @Override
    public void readFromPacket(FriendlyByteBuf buf) {
        super.readFromPacket(buf);
        this.axisOptions.readFromBuffer(buf);
        this.operator = ICondition.Operator.values()[buf.readByte()];
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_CONDITION_COORDINATE;
    }

    @Override
    public void getTooltip(List<Component> curTooltip) {
        super.getTooltip(curTooltip);
        curTooltip.add((Component)Component.literal((String)("Condition: \"" + this.getCondition() + "\"")));
    }

    @Override
    public List<Component> getExtraStringInfo() {
        String condition = this.getCondition();
        return condition.isEmpty() ? Collections.emptyList() : Collections.singletonList(Component.literal((String)condition));
    }

    public String getCondition() {
        return Arrays.stream(Direction.Axis.values()).filter(this.axisOptions::shouldCheck).map(axis -> String.format("%1$s1 %2$s %1$s2", axis.getName(), this.operator.toString())).collect(Collectors.joining(" and "));
    }
}

