/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.drone.IDroneBase;
import me.desht.pneumaticcraft.common.drone.ai.DroneAIManager;
import me.desht.pneumaticcraft.common.drone.progwidgets.AxisOptions;
import me.desht.pneumaticcraft.common.drone.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.IVariableSetWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetCoordinate;
import me.desht.pneumaticcraft.common.registry.ModProgWidgets;
import me.desht.pneumaticcraft.common.util.ITranslatableEnum;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;

public class ProgWidgetCoordinateOperator
extends ProgWidget
implements IVariableSetWidget {
    private EnumOperator operator = EnumOperator.PLUS_MINUS;
    private String variable = "";
    private DroneAIManager aiManager;
    private final AxisOptions axisOptions = new AxisOptions(true, true, true);

    public ProgWidgetCoordinateOperator() {
        super(ModProgWidgets.COORDINATE_OPERATOR.get());
    }

    @Override
    public boolean hasStepInput() {
        return true;
    }

    @Override
    public ProgWidgetType<?> returnType() {
        return null;
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of(ModProgWidgets.COORDINATE.get());
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.GRAY;
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.ADVANCED;
    }

    @Override
    public void addErrors(List<Component> curInfo, List<IProgWidget> widgets) {
        super.addErrors(curInfo, widgets);
        if (this.variable.equals("")) {
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.general.error.emptyVariable", new Object[0]));
        }
        if (!(this.axisOptions.shouldCheck(Direction.Axis.X) || this.axisOptions.shouldCheck(Direction.Axis.Y) || this.axisOptions.shouldCheck(Direction.Axis.Z))) {
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.conditionCoordinate.error.noAxisSelected", new Object[0]));
        }
        if (this.operator == EnumOperator.MAX_MIN) {
            if (this.getConnectedParameters()[0] == null && this.getConnectedParameters()[this.getParameters().size()] == null) {
                curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.coordinateOperator.noParameter", new Object[0]));
            }
        } else if (this.operator == EnumOperator.MULIPLY_DIVIDE) {
            IProgWidget w = this.getConnectedParameters()[1];
            while (w instanceof ProgWidgetCoordinate) {
                ProgWidgetCoordinate pwc = (ProgWidgetCoordinate)w;
                if (!pwc.isUsingVariable()) {
                    BlockPos pos = pwc.getCoordinate().orElse(BlockPos.ZERO);
                    if (this.axisOptions.shouldCheck(Direction.Axis.X) && pos.getX() == 0 || this.axisOptions.shouldCheck(Direction.Axis.Y) && pos.getY() == 0 || this.axisOptions.shouldCheck(Direction.Axis.Z) && pos.getZ() == 0) {
                        curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.coordinateOperator.divideByZero", new Object[0]));
                        break;
                    }
                }
                w = w.getConnectedParameters()[0];
            }
        }
    }

    @Override
    public IProgWidget getOutputWidget(IDroneBase drone, List<IProgWidget> allWidgets) {
        if (!this.variable.equals("")) {
            BlockPos curPos = ProgWidgetCoordinateOperator.calculateCoordinate(this, 0, this.operator, this.axisOptions);
            this.aiManager.setCoordinate(this.variable, curPos);
        }
        return super.getOutputWidget(drone, allWidgets);
    }

    public static BlockPos calculateCoordinate(IProgWidget widget, int argIndex, EnumOperator operator, AxisOptions axisOptions) {
        return ProgWidgetCoordinateOperator.doCalc((ProgWidgetCoordinate)widget.getConnectedParameters()[argIndex], (ProgWidgetCoordinate)widget.getConnectedParameters()[argIndex + widget.getParameters().size()], operator, axisOptions);
    }

    public static BlockPos calculateCoordinate(IProgWidget widget, int argIndex, EnumOperator operator) {
        return ProgWidgetCoordinateOperator.calculateCoordinate(widget, argIndex, operator, AxisOptions.TRUE);
    }

    private static BlockPos doCalc(ProgWidgetCoordinate whiteList, ProgWidgetCoordinate blackList, EnumOperator op, AxisOptions axisOptions) {
        BlockPos curPos = op.initialValue(whiteList, blackList);
        if (whiteList != null) {
            whiteList = (ProgWidgetCoordinate)whiteList.getConnectedParameters()[0];
            while (whiteList != null) {
                curPos = ProgWidgetCoordinateOperator.getNextPos(curPos, whiteList.getCoordinate().orElse(BlockPos.ZERO), op, true, axisOptions);
                whiteList = (ProgWidgetCoordinate)whiteList.getConnectedParameters()[0];
            }
        } else if (blackList != null) {
            blackList = (ProgWidgetCoordinate)blackList.getConnectedParameters()[0];
        }
        while (blackList != null) {
            curPos = ProgWidgetCoordinateOperator.getNextPos(curPos, blackList.getCoordinate().orElse(BlockPos.ZERO), op, false, axisOptions);
            blackList = (ProgWidgetCoordinate)blackList.getConnectedParameters()[0];
        }
        return curPos;
    }

    private static BlockPos getNextPos(BlockPos curPos, BlockPos rawPos, EnumOperator op, boolean isWhiteList, AxisOptions axisOptions) {
        BlockPos pos = new BlockPos(axisOptions.shouldCheck(Direction.Axis.X) ? rawPos.getX() : op.defaultValue(isWhiteList), axisOptions.shouldCheck(Direction.Axis.Y) ? rawPos.getY() : op.defaultValue(isWhiteList), axisOptions.shouldCheck(Direction.Axis.Z) ? rawPos.getZ() : op.defaultValue(isWhiteList));
        return op.apply(curPos, pos, isWhiteList);
    }

    @Override
    public ResourceLocation getTexture() {
        return this.operator.texture;
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        if (!this.variable.isEmpty()) {
            tag.putString("variable", this.variable);
        }
        tag.putByte("operator", (byte)this.operator.ordinal());
        this.axisOptions.writeToNBT(tag);
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        this.variable = tag.getString("variable");
        this.operator = EnumOperator.values()[tag.getByte("operator")];
        this.axisOptions.readFromNBT(tag, true);
    }

    @Override
    public void writeToPacket(FriendlyByteBuf buf) {
        super.writeToPacket(buf);
        buf.writeUtf(this.variable);
        buf.writeByte(this.operator.ordinal());
        this.axisOptions.writeToBuffer(buf);
    }

    @Override
    public void readFromPacket(FriendlyByteBuf buf) {
        super.readFromPacket(buf);
        this.variable = buf.readUtf(64);
        this.operator = EnumOperator.values()[buf.readByte()];
        this.axisOptions.readFromBuffer(buf);
    }

    public EnumOperator getOperator() {
        return this.operator;
    }

    public void setOperator(EnumOperator operator) {
        this.operator = operator;
    }

    @Override
    public String getVariable() {
        return this.variable;
    }

    @Override
    public void setVariable(String variable) {
        this.variable = variable;
    }

    @Override
    public void setAIManager(DroneAIManager aiManager) {
        this.aiManager = aiManager;
    }

    public AxisOptions getAxisOptions() {
        return this.axisOptions;
    }

    @Override
    public void getTooltip(List<Component> curTooltip) {
        super.getTooltip(curTooltip);
        curTooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.itemAssign.settingVariable", this.variable));
        curTooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.coordinateOperator.operator", new Object[0]).append(" ").append((Component)PneumaticCraftUtils.xlate(this.operator.getTranslationKey(), new Object[0])));
        this.getAxesString().ifPresent(t -> curTooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.coordinateOperator.axes", new Object[0]).append(" ").append(t)));
    }

    @Override
    public List<Component> getExtraStringInfo() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object[])new Component[]{this.varAsTextComponent(this.variable), PneumaticCraftUtils.xlate(this.operator.getTranslationKey(), new Object[0])});
        this.getAxesString().ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    private Optional<Component> getAxesString() {
        List l = Arrays.stream(Direction.Axis.values()).filter(this.axisOptions::shouldCheck).map(axis -> axis.getName().toUpperCase()).collect(Collectors.toList());
        return !l.isEmpty() && l.size() < 3 ? Optional.of(Component.literal((String)String.join((CharSequence)"/", l))) : Optional.empty();
    }

    @Override
    public void addVariables(Set<String> variables) {
        variables.add(this.variable);
    }

    public static enum EnumOperator implements ITranslatableEnum
    {
        PLUS_MINUS("plus_minus", 0, 0),
        MULIPLY_DIVIDE("multiply_divide", 1, 1),
        MAX_MIN("max_min", Integer.MIN_VALUE, Integer.MAX_VALUE);

        public final ResourceLocation texture;
        private final String name;
        private final int defWhite;
        private final int defBlack;

        private EnumOperator(String name, int defWhite, int defBlack) {
            this.name = name;
            this.texture = Textures.progWidgetTexture("coordinate_operation_" + name + ".png");
            this.defWhite = defWhite;
            this.defBlack = defBlack;
        }

        @Override
        public String getTranslationKey() {
            return "pneumaticcraft.gui.progWidget.coordinateOperator." + this.name;
        }

        public int defaultValue(boolean isWhiteList) {
            return isWhiteList ? this.defWhite : this.defBlack;
        }

        public BlockPos initialValue(ProgWidgetCoordinate whiteList, ProgWidgetCoordinate blackList) {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case PLUS_MINUS -> {
                    if (whiteList != null) {
                        yield whiteList.getCoordinate().orElse(BlockPos.ZERO);
                    }
                    if (blackList != null) {
                        yield BlockPos.ZERO.subtract((Vec3i)blackList.getCoordinate().orElse(BlockPos.ZERO));
                    }
                    yield BlockPos.ZERO;
                }
                case MULIPLY_DIVIDE -> {
                    if (whiteList != null) {
                        yield whiteList.getCoordinate().orElse(BlockPos.ZERO);
                    }
                    yield BlockPos.ZERO;
                }
                case MAX_MIN -> whiteList != null ? whiteList.getCoordinate().orElse(BlockPos.ZERO) : (blackList != null ? blackList.getCoordinate().orElse(BlockPos.ZERO) : BlockPos.ZERO);
            };
        }

        public BlockPos apply(BlockPos p1, BlockPos p2, boolean isWhiteList) {
            switch (this) {
                case PLUS_MINUS: {
                    return isWhiteList ? new BlockPos(p1.getX() + p2.getX(), p1.getY() + p2.getY(), p1.getZ() + p2.getZ()) : new BlockPos(p1.getX() - p2.getX(), p1.getY() - p2.getY(), p1.getZ() - p2.getZ());
                }
                case MULIPLY_DIVIDE: {
                    if (!(isWhiteList || p2.getX() != 0 && p2.getY() != 0 && p2.getZ() != 0)) {
                        return p1;
                    }
                    return isWhiteList ? new BlockPos(p1.getX() * p2.getX(), p1.getY() * p2.getY(), p1.getZ() * p2.getZ()) : new BlockPos(p1.getX() / p2.getX(), p1.getY() / p2.getY(), p1.getZ() / p2.getZ());
                }
                case MAX_MIN: {
                    return isWhiteList ? new BlockPos(Math.max(p1.getX(), p2.getX()), Math.max(p1.getY(), p2.getY()), Math.max(p1.getZ(), p2.getZ())) : new BlockPos(Math.min(p1.getX(), p2.getX()), Math.min(p1.getY(), p2.getY()), Math.min(p1.getZ(), p2.getZ()));
                }
            }
            return p1;
        }
    }
}

