/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import java.util.Collections;
import java.util.List;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.drone.ai.DroneAIBlockInteraction;
import me.desht.pneumaticcraft.common.drone.progwidgets.IBlockOrdered;
import me.desht.pneumaticcraft.common.drone.progwidgets.IMaxActions;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetAreaItemBase;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;

public abstract class ProgWidgetDigAndPlace
extends ProgWidgetAreaItemBase
implements IBlockOrdered,
IMaxActions {
    private IBlockOrdered.Ordering order;
    private int maxActions = 1;
    private boolean useMaxActions;

    @Override
    public IBlockOrdered.Ordering getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(IBlockOrdered.Ordering order) {
        this.order = order;
    }

    @Override
    public void getTooltip(List<Component> curTooltip) {
        super.getTooltip(curTooltip);
        curTooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.message.misc.order", PneumaticCraftUtils.xlate(this.order.getTranslationKey(), new Object[0])));
    }

    ProgWidgetDigAndPlace(ProgWidgetType<?> type, IBlockOrdered.Ordering order) {
        super(type);
        this.order = order;
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        tag.putInt("order", this.order.ordinal());
        if (this.useMaxActions) {
            tag.putBoolean("useMaxActions", true);
        }
        tag.putInt("maxActions", this.maxActions);
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        this.order = IBlockOrdered.Ordering.values()[tag.getInt("order")];
        this.useMaxActions = tag.getBoolean("useMaxActions");
        this.maxActions = tag.getInt("maxActions");
    }

    @Override
    public void writeToPacket(FriendlyByteBuf buf) {
        super.writeToPacket(buf);
        buf.writeByte(this.order.ordinal());
        buf.writeBoolean(this.useMaxActions);
        buf.writeVarInt(this.maxActions);
    }

    @Override
    public void readFromPacket(FriendlyByteBuf buf) {
        super.readFromPacket(buf);
        this.order = IBlockOrdered.Ordering.values()[buf.readByte()];
        this.useMaxActions = buf.readBoolean();
        this.maxActions = buf.readVarInt();
    }

    @Override
    public List<Component> getExtraStringInfo() {
        return Collections.singletonList(PneumaticCraftUtils.xlate(this.order.getTranslationKey(), new Object[0]));
    }

    @Override
    public void setMaxActions(int maxActions) {
        this.maxActions = maxActions;
    }

    @Override
    public int getMaxActions() {
        return this.maxActions;
    }

    @Override
    public void setUseMaxActions(boolean useMaxActions) {
        this.useMaxActions = useMaxActions;
    }

    @Override
    public boolean useMaxActions() {
        return this.useMaxActions;
    }

    DroneAIBlockInteraction<?> setupMaxActions(DroneAIBlockInteraction<?> ai, IMaxActions widget) {
        return widget.useMaxActions() ? ai.setMaxActions(widget.getMaxActions()) : ai;
    }
}

