/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.drone.IDroneBase;
import me.desht.pneumaticcraft.common.drone.progwidgets.EntityFilterPair;
import me.desht.pneumaticcraft.common.drone.progwidgets.IEntityProvider;
import me.desht.pneumaticcraft.common.drone.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetDroneCondition;
import me.desht.pneumaticcraft.common.entity.drone.DroneEntity;
import me.desht.pneumaticcraft.common.registry.ModProgWidgets;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class ProgWidgetDroneConditionEntity
extends ProgWidgetDroneCondition
implements IEntityProvider {
    private EntityFilterPair<ProgWidgetDroneConditionEntity> entityFilters;

    public ProgWidgetDroneConditionEntity() {
        super(ModProgWidgets.DRONE_CONDITION_ENTITY.get());
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of(ModProgWidgets.TEXT.get(), ModProgWidgets.TEXT.get());
    }

    @Override
    public void addErrors(List<Component> curInfo, List<IProgWidget> widgets) {
        super.addErrors(curInfo, widgets);
        EntityFilterPair.addErrors(this, curInfo);
    }

    @Override
    public int getEntityFilterPosition() {
        return 0;
    }

    @Override
    protected int getCount(IDroneBase d, IProgWidget widget) {
        DroneEntity drone = (DroneEntity)d;
        int count = 0;
        for (Entity e : drone.getPassengers()) {
            if (!((IEntityProvider)((Object)widget)).isEntityValid(e)) continue;
            ++count;
        }
        this.maybeRecordMeasuredVal(d, count);
        return count;
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_CONDITION_DRONE_ENTITY;
    }

    @Override
    public List<Entity> getValidEntities(Level world) {
        return new ArrayList<Entity>();
    }

    @Override
    public boolean isEntityValid(Entity entity) {
        if (this.entityFilters == null) {
            this.entityFilters = new EntityFilterPair<ProgWidgetDroneConditionEntity>(this);
        }
        return this.entityFilters.isEntityValid(entity);
    }
}

