/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import com.google.common.collect.ImmutableList;
import java.util.List;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.drone.IDroneBase;
import me.desht.pneumaticcraft.common.drone.progwidgets.IItemFiltering;
import me.desht.pneumaticcraft.common.drone.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetDroneCondition;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetItemFilter;
import me.desht.pneumaticcraft.common.registry.ModProgWidgets;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class ProgWidgetDroneConditionItem
extends ProgWidgetDroneCondition
implements IItemFiltering {
    public ProgWidgetDroneConditionItem() {
        super(ModProgWidgets.DRONE_CONDITION_ITEM.get());
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of(ModProgWidgets.ITEM_FILTER.get(), ModProgWidgets.TEXT.get());
    }

    @Override
    protected int getCount(IDroneBase drone, IProgWidget widget) {
        if (!(widget instanceof IItemFiltering)) {
            return 0;
        }
        IItemFiltering filtering = (IItemFiltering)((Object)widget);
        int count = 0;
        for (int i = 0; i < drone.getInv().getSlots(); ++i) {
            ItemStack droneStack = drone.getInv().getStackInSlot(i);
            if (!filtering.isItemValidForFilters(droneStack)) continue;
            count += droneStack.getCount();
        }
        this.maybeRecordMeasuredVal(drone, count);
        return count;
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_CONDITION_DRONE_ITEM_INVENTORY;
    }

    @Override
    public boolean isItemValidForFilters(ItemStack item) {
        return ProgWidgetItemFilter.isItemValidForFilters(item, ProgWidgetDroneConditionItem.getConnectedWidgetList(this, 0, ModProgWidgets.ITEM_FILTER.get()), ProgWidgetDroneConditionItem.getConnectedWidgetList(this, this.getParameters().size(), ModProgWidgets.ITEM_FILTER.get()), null);
    }
}

