/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import com.google.common.collect.ImmutableList;
import java.util.List;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.drone.IDroneBase;
import me.desht.pneumaticcraft.common.drone.ai.DroneAIBlockCondition;
import me.desht.pneumaticcraft.common.drone.progwidgets.ICondition;
import me.desht.pneumaticcraft.common.drone.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetAreaItemBase;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetCondition;
import me.desht.pneumaticcraft.common.registry.ModProgWidgets;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class ProgWidgetEnergyCondition
extends ProgWidgetCondition {
    public ProgWidgetEnergyCondition() {
        super(ModProgWidgets.CONDITION_RF.get());
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_CONDITION_ENERGY;
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of(ModProgWidgets.AREA.get(), ModProgWidgets.TEXT.get());
    }

    @Override
    protected DroneAIBlockCondition getEvaluator(IDroneBase drone, IProgWidget widget) {
        return new DroneAIBlockCondition(drone, (ProgWidgetAreaItemBase)widget){

            @Override
            protected boolean evaluate(BlockPos pos) {
                BlockEntity te = this.drone.world().getBlockEntity(pos);
                if (te == null) {
                    return false;
                }
                int energy = 0;
                for (Direction face : DirectionUtil.VALUES) {
                    if (!ProgWidgetEnergyCondition.this.getSides()[face.get3DDataValue()]) continue;
                    energy = Math.max(energy, this.getEnergy(te, face));
                }
                ProgWidgetEnergyCondition.this.maybeRecordMeasuredVal(this.drone, energy);
                return ((ICondition)((Object)this.progWidget)).getOperator().evaluate(energy, ((ICondition)((Object)this.progWidget)).getRequiredCount());
            }

            private int getEnergy(BlockEntity te, Direction side) {
                return IOHelper.getEnergyStorageForBlock(te, side).map(IEnergyStorage::getEnergyStored).orElse(0);
            }
        };
    }
}

